/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.HashSet;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IHeatTransfer;
import mekanism.api.MekanismAPI;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.item.ItemEnergized;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemNetworkReader
extends ItemEnergized {
    public static double ENERGY_PER_USE = 400.0;

    public ItemNetworkReader() {
        super(60000.0);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            boolean drain;
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            boolean bl = drain = !player.field_71075_bZ.field_75098_d;
            if (this.getEnergy(stack) >= ENERGY_PER_USE) {
                if (tileEntity instanceof ITransmitterTile) {
                    if (drain) {
                        this.setEnergy(stack, this.getEnergy(stack) - ENERGY_PER_USE);
                    }
                    IGridTransmitter transmitter = ((ITransmitterTile)tileEntity).getTransmitter();
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Transmitters: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkSize()));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Acceptors: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkAcceptorSize()));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Needed: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkNeeded()));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Buffer: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkBuffer()));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Throughput: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkFlow()));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Capacity: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkCapacity()));
                    if (transmitter instanceof IHeatTransfer) {
                        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Temperature: " + (Object)((Object)EnumColor.DARK_GREY) + ((IHeatTransfer)((Object)transmitter)).getTemp() + "K above ambient"));
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    return true;
                }
                if (tileEntity instanceof IHeatTransfer) {
                    if (drain) {
                        this.setEnergy(stack, this.getEnergy(stack) - ENERGY_PER_USE);
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Temperature: " + (Object)((Object)EnumColor.DARK_GREY) + ((IHeatTransfer)tileEntity).getTemp() + "K above ambient"));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    return true;
                }
                if (tileEntity != null) {
                    if (drain) {
                        this.setEnergy(stack, this.getEnergy(stack) - ENERGY_PER_USE);
                    }
                    HashSet iteratedNetworks = new HashSet();
                    for (ForgeDirection iterSide : ForgeDirection.VALID_DIRECTIONS) {
                        Coord4D coord = Coord4D.get(tileEntity).getFromSide(iterSide);
                        if (!(coord.getTileEntity((IBlockAccess)world) instanceof ITransmitterTile)) continue;
                        IGridTransmitter transmitter = ((ITransmitterTile)coord.getTileEntity((IBlockAccess)world)).getTransmitter();
                        if (!((DynamicNetwork)transmitter.getTransmitterNetwork()).possibleAcceptors.containsKey(coord.getFromSide(iterSide.getOpposite())) || iteratedNetworks.contains(transmitter.getTransmitterNetwork())) continue;
                        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[" + transmitter.getTransmissionType().getName() + "]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + " *Connected sides: " + (Object)((Object)EnumColor.DARK_GREY) + ((DynamicNetwork)transmitter.getTransmitterNetwork()).acceptorDirections.get(coord.getFromSide(iterSide.getOpposite()))));
                        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                        iteratedNetworks.add(transmitter.getTransmitterNetwork());
                    }
                    return true;
                }
            }
            if (player.func_70093_af() && MekanismAPI.debug) {
                String[] strings = TransmitterNetworkRegistry.getInstance().toStrings();
                player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "---------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism Debug]" + (Object)((Object)EnumColor.GREY) + " ----------"));
                for (String s : strings) {
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_GREY) + s));
                }
                player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
            }
        }
        return false;
    }

    @Override
    public boolean canSend(ItemStack itemstack) {
        return false;
    }
}

