/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.content.boiler.BoilerCache;
import mekanism.common.content.boiler.BoilerUpdateProtocol;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityBoilerCasing
extends TileEntityMultiblock<SynchronizedBoilerData>
implements IHeatTransfer {
    public Set<SynchronizedTankData.ValveData> valveViewing = new HashSet<SynchronizedTankData.ValveData>();
    public int clientWaterCapacity;
    public int clientSteamCapacity;
    public float prevWaterScale;

    public TileEntityBoilerCasing() {
        this("BoilerCasing");
    }

    public TileEntityBoilerCasing(String name) {
        super(name);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            float targetScale;
            if (this.structure != null && this.clientHasStructure && this.isRendering && (double)Math.abs(this.prevWaterScale - (targetScale = (float)(((SynchronizedBoilerData)this.structure).waterStored != null ? ((SynchronizedBoilerData)this.structure).waterStored.amount : 0) / (float)this.clientWaterCapacity)) > 0.01) {
                this.prevWaterScale = (9.0f * this.prevWaterScale + targetScale) / 10.0f;
            }
            if (!this.clientHasStructure || !this.isRendering) {
                for (SynchronizedTankData.ValveData valveData : this.valveViewing) {
                    TileEntityBoilerCasing tileEntity = (TileEntityBoilerCasing)valveData.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            if (((SynchronizedBoilerData)this.structure).waterStored != null && ((SynchronizedBoilerData)this.structure).waterStored.amount <= 0) {
                ((SynchronizedBoilerData)this.structure).waterStored = null;
                this.func_70296_d();
            }
            if (((SynchronizedBoilerData)this.structure).steamStored != null && ((SynchronizedBoilerData)this.structure).steamStored.amount <= 0) {
                ((SynchronizedBoilerData)this.structure).steamStored = null;
                this.func_70296_d();
            }
            if (this.isRendering) {
                boolean bl;
                boolean newHot;
                boolean needsValveUpdate = false;
                for (SynchronizedTankData.ValveData data : ((SynchronizedBoilerData)this.structure).valves) {
                    if (data.activeTicks > 0) {
                        --data.activeTicks;
                    }
                    if (data.activeTicks > 0 != data.prevActive) {
                        needsValveUpdate = true;
                    }
                    data.prevActive = data.activeTicks > 0;
                }
                boolean bl2 = false;
                boolean bl3 = newHot = ((SynchronizedBoilerData)this.structure).temperature >= SynchronizedBoilerData.BASE_BOIL_TEMP - (double)0.01f;
                if (newHot != ((SynchronizedBoilerData)this.structure).clientHot) {
                    bl = true;
                    ((SynchronizedBoilerData)this.structure).clientHot = newHot;
                }
                double[] d = ((SynchronizedBoilerData)this.structure).simulateHeat();
                ((SynchronizedBoilerData)this.structure).applyTemperatureChange();
                ((SynchronizedBoilerData)this.structure).lastEnvironmentLoss = d[1];
                if (((SynchronizedBoilerData)this.structure).temperature >= SynchronizedBoilerData.BASE_BOIL_TEMP && ((SynchronizedBoilerData)this.structure).waterStored != null) {
                    int steamAmount = ((SynchronizedBoilerData)this.structure).steamStored != null ? ((SynchronizedBoilerData)this.structure).steamStored.amount : 0;
                    double heatAvailable = ((SynchronizedBoilerData)this.structure).getHeatAvailable();
                    ((SynchronizedBoilerData)this.structure).lastMaxBoil = (int)Math.floor(heatAvailable / SynchronizedBoilerData.getHeatEnthalpy());
                    int amountToBoil = Math.min(((SynchronizedBoilerData)this.structure).lastMaxBoil, ((SynchronizedBoilerData)this.structure).waterStored.amount);
                    amountToBoil = Math.min(amountToBoil, ((SynchronizedBoilerData)this.structure).steamVolume * 160000 - steamAmount);
                    ((SynchronizedBoilerData)this.structure).waterStored.amount -= amountToBoil;
                    if (((SynchronizedBoilerData)this.structure).steamStored == null) {
                        ((SynchronizedBoilerData)this.structure).steamStored = new FluidStack(FluidRegistry.getFluid((String)"steam"), amountToBoil);
                    } else {
                        ((SynchronizedBoilerData)this.structure).steamStored.amount += amountToBoil;
                    }
                    ((SynchronizedBoilerData)this.structure).temperature -= (double)amountToBoil * SynchronizedBoilerData.getHeatEnthalpy() / (double)((SynchronizedBoilerData)this.structure).locations.size();
                    ((SynchronizedBoilerData)this.structure).lastBoilRate = amountToBoil;
                } else {
                    ((SynchronizedBoilerData)this.structure).lastBoilRate = 0;
                    ((SynchronizedBoilerData)this.structure).lastMaxBoil = 0;
                }
                if (needsValveUpdate || ((SynchronizedBoilerData)this.structure).needsRenderUpdate() || bl) {
                    this.sendPacketToRenderer();
                }
                ((SynchronizedBoilerData)this.structure).prevWater = ((SynchronizedBoilerData)this.structure).waterStored != null ? ((SynchronizedBoilerData)this.structure).waterStored.copy() : null;
                ((SynchronizedBoilerData)this.structure).prevSteam = ((SynchronizedBoilerData)this.structure).steamStored != null ? ((SynchronizedBoilerData)this.structure).steamStored.copy() : null;
                MekanismUtils.saveChunk(this);
            }
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player) {
        if (!player.func_70093_af() && this.structure != null) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            player.openGui((Object)Mekanism.instance, 54, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    protected SynchronizedBoilerData getNewStructure() {
        return new SynchronizedBoilerData();
    }

    public BoilerCache getNewCache() {
        return new BoilerCache();
    }

    protected BoilerUpdateProtocol getProtocol() {
        return new BoilerUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedBoilerData> getManager() {
        return Mekanism.boilerManager;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedBoilerData)this.structure).waterVolume * 16000);
            data.add(((SynchronizedBoilerData)this.structure).steamVolume * 160000);
            data.add(((SynchronizedBoilerData)this.structure).lastEnvironmentLoss);
            data.add(((SynchronizedBoilerData)this.structure).lastBoilRate);
            data.add(((SynchronizedBoilerData)this.structure).superheatingElements);
            data.add(((SynchronizedBoilerData)this.structure).temperature);
            data.add(((SynchronizedBoilerData)this.structure).lastMaxBoil);
            if (((SynchronizedBoilerData)this.structure).waterStored != null) {
                data.add(1);
                data.add(((SynchronizedBoilerData)this.structure).waterStored.getFluidID());
                data.add(((SynchronizedBoilerData)this.structure).waterStored.amount);
            } else {
                data.add(0);
            }
            if (((SynchronizedBoilerData)this.structure).steamStored != null) {
                data.add(1);
                data.add(((SynchronizedBoilerData)this.structure).steamStored.getFluidID());
                data.add(((SynchronizedBoilerData)this.structure).steamStored.amount);
            } else {
                data.add(0);
            }
            ((SynchronizedBoilerData)this.structure).upperRenderLocation.write(data);
            if (this.isRendering) {
                data.add(((SynchronizedBoilerData)this.structure).clientHot);
                HashSet<SynchronizedTankData.ValveData> toSend = new HashSet<SynchronizedTankData.ValveData>();
                for (SynchronizedTankData.ValveData valveData : ((SynchronizedBoilerData)this.structure).valves) {
                    if (valveData.activeTicks <= 0) continue;
                    toSend.add(valveData);
                }
                data.add(toSend.size());
                for (SynchronizedTankData.ValveData valveData : toSend) {
                    valveData.location.write(data);
                    data.add(valveData.side.ordinal());
                }
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K && this.clientHasStructure) {
            this.clientWaterCapacity = dataStream.readInt();
            this.clientSteamCapacity = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).lastEnvironmentLoss = dataStream.readDouble();
            ((SynchronizedBoilerData)this.structure).lastBoilRate = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).superheatingElements = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).temperature = dataStream.readDouble();
            ((SynchronizedBoilerData)this.structure).lastMaxBoil = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).waterStored = dataStream.readInt() == 1 ? new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()) : null;
            ((SynchronizedBoilerData)this.structure).steamStored = dataStream.readInt() == 1 ? new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()) : null;
            ((SynchronizedBoilerData)this.structure).upperRenderLocation = Coord4D.read(dataStream);
            if (this.isRendering) {
                ((SynchronizedBoilerData)this.structure).clientHot = dataStream.readBoolean();
                SynchronizedBoilerData.clientHotMap.put(((SynchronizedBoilerData)this.structure).inventoryID, ((SynchronizedBoilerData)this.structure).clientHot);
                int size = dataStream.readInt();
                this.valveViewing.clear();
                for (int i = 0; i < size; ++i) {
                    SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                    data.location = Coord4D.read(dataStream);
                    data.side = ForgeDirection.getOrientation((int)dataStream.readInt());
                    this.valveViewing.add(data);
                    TileEntityBoilerCasing tileEntity = (TileEntityBoilerCasing)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = true;
                }
            }
        }
    }

    public int getScaledWaterLevel(int i) {
        if (this.clientWaterCapacity == 0 || ((SynchronizedBoilerData)this.structure).waterStored == null) {
            return 0;
        }
        return ((SynchronizedBoilerData)this.structure).waterStored.amount * i / this.clientWaterCapacity;
    }

    public int getScaledSteamLevel(int i) {
        if (this.clientSteamCapacity == 0 || ((SynchronizedBoilerData)this.structure).steamStored == null) {
            return 0;
        }
        return ((SynchronizedBoilerData)this.structure).steamStored.amount * i / this.clientSteamCapacity;
    }

    @Override
    public double getTemp() {
        return 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return SynchronizedBoilerData.CASING_INVERSE_CONDUCTION_COEFFICIENT;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return SynchronizedBoilerData.CASING_INSULATION_COEFFICIENT;
    }

    @Override
    public void transferHeatTo(double heat) {
        if (this.structure != null) {
            ((SynchronizedBoilerData)this.structure).heatToAbsorb += heat;
        }
    }

    @Override
    public double[] simulateHeat() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public double applyTemperatureChange() {
        return 0.0;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return this.structure != null;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        return null;
    }

    @Override
    public String func_145825_b() {
        return LangUtils.localize("gui.thermoelectricBoiler");
    }
}

