/*
 * Decompiled with CFR 0.152.
 */
package defense.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.IItemFrequency;
import defense.client.ClientPlayerTickHandler;
import defense.client.ClientTickHandler;
import defense.client.gui.GuiCruiseLauncher;
import defense.client.gui.GuiEMPTower;
import defense.client.gui.GuiFrequency;
import defense.client.gui.GuiLauncherScreen;
import defense.client.gui.GuiRadarStation;
import defense.client.render.RenderUtils;
import defense.client.render.block.BlockRenderingHandler;
import defense.client.render.entity.RenderEntityExplosive;
import defense.client.render.entity.RenderExplosion;
import defense.client.render.entity.RenderGrenade;
import defense.client.render.entity.RenderLightBeam;
import defense.client.render.entity.RenderMissile;
import defense.client.render.item.RenderItemMachine;
import defense.client.render.item.RenderItemMissile;
import defense.client.render.item.RenderRocketLauncher;
import defense.client.render.particle.FXAntimatterPartical;
import defense.client.render.particle.FXElectricBolt;
import defense.client.render.particle.FXElectricBoltSpawner;
import defense.client.render.particle.FXEnderPortalPartical;
import defense.client.render.particle.FXShockWave;
import defense.client.render.particle.FXSmoke;
import defense.client.render.tile.RenderBombBlock;
import defense.client.render.tile.RenderCruiseLauncher;
import defense.client.render.tile.RenderEmpTower;
import defense.client.render.tile.RenderLauncherBase;
import defense.client.render.tile.RenderLauncherFrame;
import defense.client.render.tile.RenderLauncherScreen;
import defense.client.render.tile.RenderRadarStation;
import defense.common.CommonProxy;
import defense.common.DefenseTech;
import defense.common.DefenseTechBlocks;
import defense.common.DefenseTechItems;
import defense.common.entity.EntityBombCart;
import defense.common.entity.EntityExplosion;
import defense.common.entity.EntityExplosive;
import defense.common.entity.EntityFlyingBlock;
import defense.common.entity.EntityFragments;
import defense.common.entity.EntityGrenade;
import defense.common.entity.EntityLightBeam;
import defense.common.entity.EntityMissile;
import defense.common.entity.RenderEntityBlock;
import defense.common.entity.RenderShrapnel;
import defense.common.explosion.missile.MissileMovingSound;
import defense.common.potion.PoisonFrostBite;
import defense.common.tile.TileCruiseLauncher;
import defense.common.tile.TileEMPTower;
import defense.common.tile.TileExplosive;
import defense.common.tile.TileLauncherBase;
import defense.common.tile.TileLauncherFrame;
import defense.common.tile.TileLauncherScreen;
import defense.common.tile.TileRadarStation;
import java.util.List;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderLivingEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private boolean disableReflectionFX = false;

    @Override
    public void preInit() {
        super.preInit();
        FMLCommonHandler.instance().bus().register((Object)new ClientPlayerTickHandler());
        FMLCommonHandler.instance().bus().register((Object)new ClientTickHandler());
    }

    @Override
    public void init() {
        super.init();
        MinecraftForgeClient.registerItemRenderer((Item)DefenseTechItems.itemRocketLauncher, (IItemRenderer)new RenderRocketLauncher());
        MinecraftForgeClient.registerItemRenderer((Item)DefenseTechItems.itemMissile, (IItemRenderer)new RenderItemMissile());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)DefenseTechBlocks.blockMachine), (IItemRenderer)new RenderItemMachine());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlyingBlock.class, (Render)new RenderEntityBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntityFragments.class, (Render)new RenderShrapnel());
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosive.class, (Render)new RenderEntityExplosive());
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, (Render)new RenderMissile(0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosion.class, (Render)new RenderExplosion());
        RenderingRegistry.registerEntityRenderingHandler(EntityLightBeam.class, (Render)new RenderLightBeam());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (Render)new RenderGrenade());
        RenderingRegistry.registerEntityRenderingHandler(EntityBombCart.class, (Render)new RenderMinecart());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBombBlock());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRenderingHandler());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCruiseLauncher.class, (TileEntitySpecialRenderer)new RenderCruiseLauncher());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherBase.class, (TileEntitySpecialRenderer)new RenderLauncherBase());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherScreen.class, (TileEntitySpecialRenderer)new RenderLauncherScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherFrame.class, (TileEntitySpecialRenderer)new RenderLauncherFrame());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRadarStation.class, (TileEntitySpecialRenderer)new RenderRadarStation());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEMPTower.class, (TileEntitySpecialRenderer)new RenderEmpTower());
        ClientRegistry.bindTileEntitySpecialRenderer(TileExplosive.class, (TileEntitySpecialRenderer)new RenderBombBlock());
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer entityPlayer, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (entityPlayer.field_71071_by.func_70448_g() != null && entityPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof IItemFrequency) {
            return new GuiFrequency(entityPlayer, entityPlayer.field_71071_by.func_70448_g());
        }
        if (tileEntity instanceof TileCruiseLauncher) {
            return new GuiCruiseLauncher(entityPlayer.field_71071_by, (TileCruiseLauncher)tileEntity);
        }
        if (tileEntity instanceof TileLauncherScreen) {
            return new GuiLauncherScreen((TileLauncherScreen)tileEntity);
        }
        if (tileEntity instanceof TileRadarStation) {
            return new GuiRadarStation((TileRadarStation)tileEntity);
        }
        if (tileEntity instanceof TileEMPTower) {
            return new GuiEMPTower((TileEMPTower)tileEntity);
        }
        return null;
    }

    @Override
    public boolean isFancyGraphicsEnabled() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    @Override
    public int getParticleSetting() {
        return Minecraft.func_71410_x().field_71474_y.field_74362_aa;
    }

    @Override
    public void spawnParticle(String name, World world, Pos3D position, double motionX, double motionY, double motionZ, float red, float green, float blue, float scale, double distance) {
        Object fx = null;
        if (name.equals("smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance);
        } else if (name.equals("missile_smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance).setAge(100);
        } else if (name.equals("portal")) {
            fx = new FXEnderPortalPartical(world, position, red, green, blue, scale, distance);
        } else if (name.equals("antimatter")) {
            fx = new FXAntimatterPartical(world, position, red, green, blue, scale, distance);
        } else if (name.equals("digging")) {
            fx = new EntityDiggingFX(world, position.xPos, position.yPos, position.zPos, motionX, motionY, motionZ, Block.func_149729_e((int)((int)red)), 0, (int)green);
            fx.func_70541_f(blue);
        } else if (name.equals("shockwave")) {
            fx = new FXShockWave(world, position, red, green, blue, scale, distance);
        }
        if (fx != null) {
            ((EntityFX)fx).field_70159_w = motionX;
            ((EntityFX)fx).field_70181_x = motionY;
            ((EntityFX)fx).field_70179_y = motionZ;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void spawnShock(World world, Pos3D startVec, Pos3D targetVec) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBolt(world, startVec, targetVec, 0L));
    }

    @Override
    public void spawnShock(World world, Pos3D startVec, Pos3D targetVec, int duration) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBoltSpawner(world, startVec, targetVec, 0L, duration));
    }

    @Override
    public void playSound(EntityMissile missile) {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new MissileMovingSound(missile));
    }

    @Override
    public List<Entity> getEntityFXs() {
        if (!this.disableReflectionFX) {
            try {
                EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
                List[] fxLayers = (List[])ReflectionHelper.getPrivateValue(EffectRenderer.class, (Object)renderer, (int)2);
                return fxLayers[0];
            }
            catch (Exception e) {
                DefenseTech.LOGGER.severe("Failed to use relfection on entity effects.");
                e.printStackTrace();
                this.disableReflectionFX = true;
            }
        }
        return null;
    }

    public void renderingLivingEvent(RenderLivingEvent.Specials.Pre evt) {
        if (evt.entity instanceof EntityLivingBase && evt.entity.func_70660_b((Potion)PoisonFrostBite.INSTANCE) != null) {
            try {
                ModelBase modelBase = (ModelBase)ReflectionHelper.getPrivateValue(RendererLivingEntity.class, (Object)evt.renderer, (int)2);
                if (modelBase != null) {
                    if (evt.entity.func_82150_aj()) {
                        GL11.glDepthMask((boolean)false);
                    } else {
                        GL11.glDepthMask((boolean)true);
                    }
                    float f1 = evt.entity.field_70173_aa;
                    RenderUtils.setTerrainTexture();
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    float f2 = f1 * 0.01f;
                    float f3 = f1 * 0.01f;
                    GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    evt.renderer.func_77042_a(modelBase);
                    GL11.glMatrixMode((int)5888);
                    GL11.glEnable((int)3042);
                    float f4 = 0.5f;
                    GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)1.0f);
                    GL11.glDisable((int)2896);
                    GL11.glBlendFunc((int)1, (int)1);
                    modelBase.func_78088_a((Entity)evt.entity, (float)evt.entity.field_70165_t, (float)evt.entity.field_70163_u, (float)evt.entity.field_70161_v, evt.entity.field_70125_A, evt.entity.field_70177_z, 0.0625f);
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode((int)5888);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                }
            }
            catch (Exception e) {
                DefenseTech.LOGGER.severe("Failed to render entity layer object");
                e.printStackTrace();
            }
        }
    }
}

