/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosion;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.client.model.missile.ModelAntimatterMissile;
import defense.client.model.missile.ModelMissileBase;
import defense.common.Settings;
import defense.common.explosion.Explosion;
import defense.common.explosive.Explosive;
import defense.common.explosive.blast.BlastAntimatter;
import mekanism.api.Pos3D;
import mekanism.common.recipe.ShapedMekanismRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ExAntimatter
extends Explosion {
    public ExAntimatter() {
        super("antimatter", 4);
        this.setFuseTime(300);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getMissileModel() {
        return new ModelAntimatterMissile();
    }

    @Override
    public void onDetonation(World worldObj, Pos3D position, int fuseTicks) {
        super.onDetonation(worldObj, position, fuseTicks);
        if (fuseTicks % 25 == 0) {
            worldObj.func_72908_a(position.xPos, position.yPos, position.zPos, "defense:alarm", 4.0f, 1.0f);
        }
    }

    @Override
    public void init() {
        GameRegistry.addRecipe((IRecipe)new ShapedMekanismRecipe(this.getItemStack(), new Object[]{"AAA", "AEA", "AAA", Character.valueOf('E'), Explosive.nuclear.getItemStack(), Character.valueOf('A'), "antimatterGram"}));
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastAntimatter(world, entity, x, y, z, Settings.ANTIMATTER_SIZE, Settings.DESTROY_BEDROCK).explode();
    }
}

