/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosion;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.client.model.missile.ModelAnvilMissile;
import defense.client.model.missile.ModelFragmentationMissile;
import defense.client.model.missile.ModelMissileBase;
import defense.client.model.missile.ModelShrapnelMissile;
import defense.common.explosion.Explosion;
import defense.common.explosive.Explosive;
import defense.common.explosive.blast.BlastShrapnel;
import mekanism.common.recipe.ShapedMekanismRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ExShrapnel
extends Explosion {
    public ExShrapnel(String name, int tier) {
        super(name, tier);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getMissileModel() {
        if (this.getUnlocalizedName().equalsIgnoreCase("shrapnel")) {
            return new ModelShrapnelMissile();
        }
        if (this.getUnlocalizedName().equalsIgnoreCase("anvil")) {
            return new ModelAnvilMissile();
        }
        return new ModelFragmentationMissile();
    }

    @Override
    public void init() {
        if (this.getID() == Explosive.shrapnel.getID()) {
            GameRegistry.addRecipe((IRecipe)new ShapedMekanismRecipe(this.getItemStack(), new Object[]{"???", "?@?", "???", Character.valueOf('@'), repulsive.getItemStack(), Character.valueOf('?'), Items.field_151032_g}));
        } else if (this.getID() == Explosive.anvil.getID()) {
            GameRegistry.addRecipe((IRecipe)new ShapedMekanismRecipe(this.getItemStack(10), new Object[]{"SSS", "SAS", "SSS", Character.valueOf('A'), Blocks.field_150467_bQ, Character.valueOf('S'), Explosive.shrapnel.getItemStack()}));
        } else if (this.getID() == Explosive.fragmentation.getID()) {
            GameRegistry.addRecipe((IRecipe)new ShapedMekanismRecipe(this.getItemStack(), new Object[]{" @ ", "@?@", " @ ", Character.valueOf('?'), incendiary.getItemStack(), Character.valueOf('@'), Explosive.shrapnel.getItemStack()}));
        }
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        if (this.getTier() == 2) {
            new BlastShrapnel(world, entity, x, y, z, 15.0f, true, true, false).explode();
        } else if (this.getID() == Explosive.anvil.getID()) {
            new BlastShrapnel(world, entity, x, y, z, 25.0f, false, false, true).explode();
        } else {
            new BlastShrapnel(world, entity, x, y, z, 30.0f, true, false, false).explode();
        }
    }
}

