/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosion.missile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.client.model.missile.ModelClusterMissile;
import defense.client.model.missile.ModelMissileBase;
import defense.common.entity.EntityMissile;
import defense.common.explosion.missile.Missile;
import defense.common.explosive.blast.BlastRepulsive;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class MissileCluster
extends Missile {
    public static final int MAX_CLUSTER = 12;
    protected double spread = 20.0;

    public MissileCluster(String name, int tier) {
        super(name, tier);
        this.hasBlock = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getMissileModel() {
        return new ModelClusterMissile();
    }

    @Override
    public void update(EntityMissile missileObj) {
        if (missileObj.field_70181_x < -0.5) {
            if (missileObj.missileCount < 12) {
                if (!missileObj.field_70170_p.field_72995_K) {
                    Pos3D position = new Pos3D((Entity)missileObj);
                    EntityMissile clusterMissile = new EntityMissile(missileObj.field_70170_p, position.clone(), position.clone(), 0);
                    double radius = this.spread;
                    double theta = 0.0;
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    if (missileObj.missileCount > 0) {
                        theta = (double)missileObj.missileCount / 12.0 * Math.PI * 2.0;
                        x = radius * Math.cos(theta);
                        clusterMissile.field_70165_t += Math.cos(theta) * 5.0;
                        z = radius * Math.sin(theta);
                        clusterMissile.field_70161_v += Math.sin(theta) * 5.0;
                    }
                    clusterMissile.missileType = EntityMissile.MissileType.CruiseMissile;
                    clusterMissile.protectionTime = 20 + missileObj.targetHeight - 1;
                    clusterMissile.launch(missileObj.targetVector.clone().translate(new Pos3D(x, y, z)));
                    missileObj.field_70170_p.func_72838_d((Entity)clusterMissile);
                }
                missileObj.protectionTime = 20;
                ++missileObj.missileCount;
            } else {
                missileObj.func_70106_y();
            }
        }
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastRepulsive(world, entity, x, y, z, 6.0f).setDestroyItems().explode();
    }

    @Override
    public boolean isCruise() {
        return false;
    }
}

