/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosion.missile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.IItemTracker;
import defense.client.model.missile.ModelHomingMissile;
import defense.client.model.missile.ModelMissileBase;
import defense.common.Vector2;
import defense.common.entity.EntityMissile;
import defense.common.explosion.missile.Missile;
import defense.common.explosive.blast.BlastRepulsive;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class MissileHoming
extends Missile {
    public MissileHoming() {
        super("homing", 1);
        this.hasBlock = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getMissileModel() {
        return new ModelHomingMissile();
    }

    @Override
    public void launch(EntityMissile missileObj) {
        WorldServer worldServer;
        Entity trackingEntity;
        if (!missileObj.field_70170_p.field_72995_K && (trackingEntity = (worldServer = (WorldServer)missileObj.field_70170_p).func_73045_a(missileObj.trackingVar)) != null) {
            if (trackingEntity == missileObj) {
                missileObj.setExplode();
            }
            missileObj.targetVector = new Pos3D(trackingEntity);
        }
    }

    @Override
    public void update(EntityMissile missileObj) {
        WorldServer worldServer;
        Entity trackingEntity;
        if ((float)missileObj.airborneTicks > missileObj.missileFlightTime / 2.0f && missileObj.missileType == EntityMissile.MissileType.MISSILE && (trackingEntity = (worldServer = (WorldServer)missileObj.field_70170_p).func_73045_a(missileObj.trackingVar)) != null) {
            if (trackingEntity.equals((Object)missileObj)) {
                missileObj.setExplode();
            }
            missileObj.targetVector = new Pos3D(trackingEntity);
            missileObj.missileType = EntityMissile.MissileType.CruiseMissile;
            missileObj.deltaPathX = missileObj.targetVector.xPos - missileObj.field_70165_t;
            missileObj.deltaPathY = missileObj.targetVector.yPos - missileObj.field_70163_u;
            missileObj.deltaPathZ = missileObj.targetVector.zPos - missileObj.field_70161_v;
            missileObj.flatDistance = Vector2.distance(new Vector2(missileObj.startPos), new Vector2(missileObj.targetVector));
            missileObj.maxHeight = 150 + (int)(missileObj.flatDistance * 1.8);
            missileObj.missileFlightTime = (float)Math.max(100.0, 2.4 * missileObj.flatDistance);
            missileObj.acceleration = (float)missileObj.maxHeight * 2.0f / (missileObj.missileFlightTime * missileObj.missileFlightTime);
            if (missileObj.xiaoDanMotion.equals((Object)new Pos3D()) || missileObj.xiaoDanMotion == null) {
                float suDu = 0.3f;
                missileObj.xiaoDanMotion = new Pos3D();
                missileObj.xiaoDanMotion.xPos = missileObj.deltaPathX / (double)(missileObj.missileFlightTime * suDu);
                missileObj.xiaoDanMotion.yPos = missileObj.deltaPathY / (double)(missileObj.missileFlightTime * suDu);
                missileObj.xiaoDanMotion.zPos = missileObj.deltaPathZ / (double)(missileObj.missileFlightTime * suDu);
            }
        }
    }

    @Override
    public boolean onInteract(EntityMissile missileObj, EntityPlayer entityPlayer) {
        Entity trackingEntity;
        if (!missileObj.field_70170_p.field_72995_K && missileObj.airborneTicks <= 0 && entityPlayer.func_71045_bC() != null && entityPlayer.func_71045_bC().func_77973_b() instanceof IItemTracker && (trackingEntity = ((IItemTracker)entityPlayer.func_71045_bC().func_77973_b()).getTrackingEntity(missileObj.field_70170_p, entityPlayer.func_71045_bC())) != null && missileObj.trackingVar != trackingEntity.func_145782_y()) {
            missileObj.trackingVar = trackingEntity.func_145782_y();
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Missile target locked to: " + trackingEntity.func_70005_c_()));
            if (missileObj.getLauncher() != null && missileObj.getLauncher().getController() != null) {
                Pos3D newTarget = new Pos3D(trackingEntity);
                newTarget.yPos = 0.0;
                missileObj.getLauncher().getController().setTarget(newTarget);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCruise() {
        return false;
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastRepulsive(world, entity, x, y, z, 4.0f).setDestroyItems().explode();
    }
}

