/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosion.missile;

import defense.common.entity.EntityMissile;
import defense.common.explosion.missile.MissileCluster;
import defense.common.explosive.Explosive;
import defense.common.explosive.blast.BlastNuclear;
import mekanism.api.Pos3D;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class MissileNuclearCluster
extends MissileCluster {
    public static final int MAX_CLUSTER = 4;

    public MissileNuclearCluster() {
        super("nuclearCluster", 3);
        this.hasBlock = false;
    }

    @Override
    public void update(EntityMissile missileObj) {
        if (missileObj.field_70181_x < -0.5) {
            if (missileObj.missileCount < 4) {
                if (!missileObj.field_70170_p.field_72995_K) {
                    Pos3D position = new Pos3D((Entity)missileObj);
                    EntityMissile clusterMissile = new EntityMissile(missileObj.field_70170_p, position, new Pos3D((Entity)missileObj), Explosive.nuclear.getID());
                    missileObj.field_70170_p.func_72838_d((Entity)clusterMissile);
                    clusterMissile.missileType = EntityMissile.MissileType.CruiseMissile;
                    clusterMissile.protectionTime = 20;
                    clusterMissile.launch(missileObj.targetVector.clone().translate(new Pos3D((double)(missileObj.missileCount - 2) * Math.random() * 30.0, (double)(missileObj.missileCount - 2) * Math.random() * 30.0, (double)(missileObj.missileCount - 2) * Math.random() * 30.0)));
                }
                missileObj.protectionTime = 20;
                ++missileObj.missileCount;
            } else {
                missileObj.func_70106_y();
            }
        }
    }

    @Override
    public void createExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastNuclear(world, entity, x, y, z, 30.0f, 50.0f).setNuclear().explode();
    }

    @Override
    public boolean isCruise() {
        return false;
    }
}

