/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.IExplosive;
import defense.client.model.missile.ModelMissileBase;
import defense.common.DefenseTechBlocks;
import defense.common.explosion.ExAntiGravitational;
import defense.common.explosion.ExAntimatter;
import defense.common.explosion.ExBreaching;
import defense.common.explosion.ExChemical;
import defense.common.explosion.ExCondensed;
import defense.common.explosion.ExDebilitation;
import defense.common.explosion.ExEMP;
import defense.common.explosion.ExEndothermic;
import defense.common.explosion.ExExothermic;
import defense.common.explosion.ExIncendiary;
import defense.common.explosion.ExNuclear;
import defense.common.explosion.ExRedMatter;
import defense.common.explosion.ExRejuvenation;
import defense.common.explosion.ExRepulsive;
import defense.common.explosion.ExSMine;
import defense.common.explosion.ExShrapnel;
import defense.common.explosion.ExSonic;
import defense.common.explosion.Explosion;
import defense.common.explosion.missile.MissileAntiBallistic;
import defense.common.explosion.missile.MissileCluster;
import defense.common.explosion.missile.MissileHoming;
import defense.common.explosion.missile.MissileModule;
import defense.common.explosion.missile.MissileNuclearCluster;
import defense.common.explosive.ExplosiveRegistry;
import mekanism.api.Pos3D;
import mekanism.common.util.LangUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class Explosive
implements IExplosive {
    public static Explosive condensed;
    public static Explosive shrapnel;
    public static Explosive incendiary;
    public static Explosive debilitation;
    public static Explosive chemical;
    public static Explosive anvil;
    public static Explosive repulsive;
    public static Explosive attractive;
    public static Explosive fragmentation;
    public static Explosive contagious;
    public static Explosive sonic;
    public static Explosive breaching;
    public static Explosive rejuvenation;
    public static Explosive thermobaric;
    public static Explosive sMine;
    public static Explosive nuclear;
    public static Explosive emp;
    public static Explosive exothermic;
    public static Explosive endothermic;
    public static Explosive antiGrav;
    public static Explosive hypersonic;
    public static Explosive antimatter;
    public static Explosive redMatter;
    public static Explosion missileModule;
    public static Explosion homing;
    public static Explosion antiBallistic;
    public static Explosion cluster;
    public static Explosion nuclearCluster;
    public static boolean registered;
    private String nameID;
    private int tier;
    private int fuseTime;
    public boolean isDisabled;
    protected boolean isMobile = false;
    protected boolean hasBlock;
    protected boolean hasGrenade;
    protected boolean hasMinecart;
    protected boolean hasMissile;

    public static void register() {
        if (!registered) {
            condensed = ExplosiveRegistry.register(new ExCondensed("condensed", 1));
            shrapnel = ExplosiveRegistry.register(new ExShrapnel("shrapnel", 1));
            incendiary = ExplosiveRegistry.register(new ExIncendiary("incendiary", 1));
            debilitation = ExplosiveRegistry.register(new ExDebilitation("debilitation", 1));
            chemical = ExplosiveRegistry.register(new ExChemical("chemical", 1));
            anvil = ExplosiveRegistry.register(new ExShrapnel("anvil", 1));
            repulsive = ExplosiveRegistry.register(new ExRepulsive("repulsive", 1));
            attractive = ExplosiveRegistry.register(new ExRepulsive("attractive", 1));
            fragmentation = ExplosiveRegistry.register(new ExShrapnel("fragmentation", 2));
            contagious = ExplosiveRegistry.register(new ExChemical("contagious", 2));
            sonic = ExplosiveRegistry.register(new ExSonic("sonic", 2));
            breaching = ExplosiveRegistry.register(new ExBreaching());
            rejuvenation = ExplosiveRegistry.register(new ExRejuvenation());
            thermobaric = ExplosiveRegistry.register(new ExNuclear("thermobaric", 2));
            sMine = ExplosiveRegistry.register(new ExSMine("sMine", 2));
            nuclear = ExplosiveRegistry.register(new ExNuclear("nuclear", 3));
            emp = ExplosiveRegistry.register(new ExEMP());
            exothermic = ExplosiveRegistry.register(new ExExothermic());
            endothermic = ExplosiveRegistry.register(new ExEndothermic());
            antiGrav = ExplosiveRegistry.register(new ExAntiGravitational());
            hypersonic = ExplosiveRegistry.register(new ExSonic("hypersonic", 3));
            antimatter = ExplosiveRegistry.register(new ExAntimatter());
            redMatter = ExplosiveRegistry.register(new ExRedMatter());
            missileModule = (Explosion)ExplosiveRegistry.register(new MissileModule());
            homing = (Explosion)ExplosiveRegistry.register(new MissileHoming());
            antiBallistic = (Explosion)ExplosiveRegistry.register(new MissileAntiBallistic());
            cluster = (Explosion)ExplosiveRegistry.register(new MissileCluster("cluster", 2));
            nuclearCluster = (Explosion)ExplosiveRegistry.register(new MissileNuclearCluster());
        }
        registered = true;
    }

    protected Explosive(String name, int t) {
        this.nameID = name;
        this.tier = t;
        this.fuseTime = 100;
        this.hasBlock = true;
        this.hasMissile = true;
        this.hasGrenade = this.tier <= 1;
        this.hasMinecart = this.tier <= 2;
    }

    @Override
    public final int getID() {
        return ExplosiveRegistry.getID(this.getUnlocalizedName());
    }

    @Override
    public String getUnlocalizedName() {
        return this.nameID;
    }

    @Override
    public String getExplosiveName() {
        return LangUtils.localize((String)("explosive." + this.nameID + ".name"));
    }

    @Override
    public String getGrenadeName() {
        return LangUtils.localize((String)("grenade." + this.nameID + ".name"));
    }

    @Override
    public String getMissileName() {
        return LangUtils.localize((String)("missile." + this.nameID + ".name"));
    }

    @Override
    public String getMinecartName() {
        return LangUtils.localize((String)("minecart." + this.nameID + ".name"));
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int t) {
        this.tier = t;
    }

    public Explosive setFuseTime(int fuse) {
        this.fuseTime = fuse;
        return this;
    }

    public int getYinXin() {
        return this.fuseTime;
    }

    public void onPreDetonation(World world, Entity entity) {
        world.func_72956_a(entity, "game.tnt.primed", 1.0f, 1.0f);
    }

    public void onDetonation(World world, Pos3D position, int fuseTicks) {
        world.func_72869_a("smoke", position.xPos, position.yPos + 0.5, position.zPos, 0.0, 0.0, 0.0);
    }

    public int onBlockExploded() {
        return (int)((double)(this.fuseTime / 2) + Math.random() * (double)this.fuseTime / 4.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getBlockModel() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBlockResource() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelMissileBase getMissileModel() {
        return null;
    }

    public boolean hasGrenadeForm() {
        return this.hasGrenade;
    }

    public boolean hasMissileForm() {
        return this.hasMissile;
    }

    public boolean hasMinecartForm() {
        return this.hasMinecart;
    }

    public boolean hasBlockForm() {
        return this.hasBlock;
    }

    public void init() {
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack(DefenseTechBlocks.blockExplosive, amount, this.getID());
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        return false;
    }

    @Override
    public void createExplosion(World world, double x, double y, double z, Entity entity) {
        if (!this.isDisabled) {
            this.doCreateExplosion(world, x, y, z, entity);
        }
    }

    public abstract void doCreateExplosion(World var1, double var2, double var4, double var6, Entity var8);

    static {
        registered = false;
    }
}

