/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import defense.common.DefenseUtils;
import defense.common.entity.EntityExplosion;
import defense.common.explosive.blast.Blast;
import defense.common.explosive.blast.BlastRedmatter;
import mekanism.api.Coord4D;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastAntimatter
extends Blast {
    private boolean destroyBedrock;

    public BlastAntimatter(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastAntimatter(World world, Entity entity, double x, double y, double z, float size, boolean destroyBedrock) {
        this(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        super.doPreExplode();
        this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:antimatter", 7.0f, (float)((double)this.field_77287_j.field_73012_v.nextFloat() * 0.1 + (double)0.9f));
        this.doDamageEntities(this.getRadius(), 2.1474836E9f);
    }

    @Override
    public void doExplode() {
        if (!this.field_77287_j.field_72995_K) {
            int x = (int)(-this.getRadius());
            while ((float)x < this.getRadius()) {
                int y = (int)(-this.getRadius());
                while ((float)y < this.getRadius()) {
                    int z = (int)(-this.getRadius());
                    while ((float)z < this.getRadius()) {
                        Coord4D coord;
                        Block block;
                        Pos3D targetPosition = this.position.clone().translate(new Pos3D((double)x, (double)y, (double)z));
                        double dist = this.position.distance(targetPosition);
                        if (dist < (double)this.getRadius() && !(block = (coord = targetPosition.getCoord(this.field_77287_j.field_73011_w.field_76574_g)).getBlock((IBlockAccess)this.field_77287_j)).isAir((IBlockAccess)this.field_77287_j, coord.xCoord, coord.yCoord, coord.zCoord) && (this.destroyBedrock || !(block.func_149712_f(this.field_77287_j, coord.xCoord, coord.yCoord, coord.zCoord) < 0.0f)) && (dist < (double)(this.getRadius() - 1.0f) || (double)this.field_77287_j.field_73012_v.nextFloat() > 0.7) && DefenseUtils.canBreak(this.field_77287_j, block, coord.xCoord, coord.yCoord, coord.zCoord)) {
                            this.field_77287_j.func_147468_f(coord.xCoord, coord.yCoord, coord.zCoord);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    @Override
    public void doPostExplode() {
        this.doDamageEntities(this.getRadius(), 2.1474836E9f);
    }

    @Override
    protected boolean onDamageEntity(Entity entity) {
        if (entity instanceof EntityExplosion && ((EntityExplosion)entity).blast instanceof BlastRedmatter) {
            entity.func_70106_y();
            return true;
        }
        return false;
    }

    @Override
    public long getEnergy() {
        return 30000000L;
    }
}

