/*
 * Decompiled with CFR 0.152.
 */
package defense.common.explosive.blast;

import defense.common.DefenseTechBlocks;
import defense.common.DefenseUtils;
import defense.common.block.BlockExplosive;
import defense.common.entity.EntityFlyingBlock;
import defense.common.entity.EntityMissile;
import defense.common.explosive.blast.Blast;
import defense.common.explosive.thread.ThreadLargeExplosion;
import defense.common.tile.TileExplosive;
import java.util.Iterator;
import java.util.List;
import mekanism.api.Pos3D;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class BlastSonic
extends Blast {
    private float nengLiang;
    private ThreadLargeExplosion thread;
    private boolean hasShockWave = false;

    public BlastSonic(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastSonic(World world, Entity entity, double x, double y, double z, float size, float nengLiang) {
        this(world, entity, x, y, z, size);
        this.nengLiang = nengLiang;
    }

    public Blast setShockWave() {
        this.hasShockWave = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        if (!this.field_77287_j.field_72995_K) {
            if (this.hasShockWave) {
                int x = (int)(-this.getRadius() * 2.0f);
                while ((float)x < this.getRadius() * 2.0f) {
                    int y = (int)(-this.getRadius() * 2.0f);
                    while ((float)y < this.getRadius() * 2.0f) {
                        int z = (int)(-this.getRadius() * 2.0f);
                        while ((float)z < this.getRadius() * 2.0f) {
                            Pos3D targetPosition = this.position.clone().translate(new Pos3D((double)x, (double)y, (double)z));
                            Block block = this.field_77287_j.func_147439_a((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos);
                            if (DefenseUtils.canBreak(this.field_77287_j, block, targetPosition.xPos, targetPosition.yPos, targetPosition.zPos) && !this.field_77287_j.func_147437_c((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos)) {
                                Material material = block.func_149688_o();
                                if (block != Blocks.field_150357_h && !(block instanceof BlockLiquid) && (block.getExplosionResistance(this.field_77283_e, this.field_77287_j, (int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos, this.position.xPos, this.position.yPos, this.position.zPos) > this.nengLiang || material == Material.field_151592_s)) {
                                    this.field_77287_j.func_147468_f((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos);
                                }
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            this.thread = new ThreadLargeExplosion(this.field_77287_j, this.position, (int)this.getRadius(), this.nengLiang, this.field_77283_e, new ThreadLargeExplosion.IThreadCallBack(){

                @Override
                public float getResistance(World world, Pos3D explosionPosition, Pos3D targetPosition, Entity source, Block block) {
                    float resistance = 0.0f;
                    resistance = block instanceof BlockLiquid || block instanceof IFluidBlock ? 1.0f : block.getExplosionResistance(source, world, (int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos, explosionPosition.xPos, explosionPosition.yPos, explosionPosition.zPos);
                    return resistance;
                }
            });
            this.thread.start();
        }
        if (this.hasShockWave) {
            this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:hypersonic", 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        } else {
            this.field_77287_j.func_72908_a(this.position.xPos, this.position.yPos, this.position.zPos, "defense:sonicwave", 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExplode() {
        List allEntities;
        int r = this.callCount;
        if (!this.field_77287_j.field_72995_K && this.thread != null && this.thread.isComplete) {
            Iterator it = this.thread.results.iterator();
            while (it.hasNext()) {
                Block block;
                Pos3D targetPosition = (Pos3D)it.next();
                double distance = targetPosition.clone().distance(this.position);
                if (distance > (double)r || distance < (double)(r - 3) || !DefenseUtils.canBreak(this.field_77287_j, block = this.field_77287_j.func_147439_a((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos), targetPosition.xPos, targetPosition.yPos, targetPosition.zPos) || this.field_77287_j.func_147437_c((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos) || block == Blocks.field_150357_h || block == Blocks.field_150343_Z) continue;
                int metadata = this.field_77287_j.func_72805_g((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos);
                if (!(distance < (double)(r - 1)) && this.field_77287_j.field_73012_v.nextInt(3) <= 0) continue;
                if (block == DefenseTechBlocks.blockExplosive) {
                    BlockExplosive.detonate(this.field_77287_j, (int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos, ((TileExplosive)this.field_77287_j.func_147438_o((int)((int)targetPosition.xPos), (int)((int)targetPosition.yPos), (int)((int)targetPosition.zPos))).explosiveID, 1);
                } else {
                    this.field_77287_j.func_147468_f((int)targetPosition.xPos, (int)targetPosition.yPos, (int)targetPosition.zPos);
                }
                targetPosition.translate(0.5, 0.5, 0.5);
                if ((double)this.field_77287_j.field_73012_v.nextFloat() < 0.3 * (double)(this.getRadius() - (float)r)) {
                    EntityFlyingBlock entity = new EntityFlyingBlock(this.field_77287_j, targetPosition, block, metadata);
                    this.field_77287_j.func_72838_d((Entity)entity);
                    entity.yawChange = 50.0f * this.field_77287_j.field_73012_v.nextFloat();
                    entity.pitchChange = 100.0f * this.field_77287_j.field_73012_v.nextFloat();
                }
                it.remove();
            }
        }
        int radius = 2 * this.callCount;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.xPos - (double)radius), (double)(this.position.yPos - (double)radius), (double)(this.position.zPos - (double)radius), (double)(this.position.xPos + (double)radius), (double)(this.position.yPos + (double)radius), (double)(this.position.zPos + (double)radius));
        List list = allEntities = this.field_77287_j.func_72872_a(Entity.class, bounds);
        synchronized (list) {
            for (Entity entity : allEntities) {
                if (entity instanceof EntityMissile) {
                    ((EntityMissile)entity).setExplode();
                    break;
                }
                double xDifference = entity.field_70165_t - this.position.xPos;
                double zDifference = entity.field_70161_v - this.position.zPos;
                r = (int)this.getRadius();
                if (xDifference < 0.0) {
                    r = (int)(-this.getRadius());
                }
                entity.field_70159_w += ((double)r - xDifference) * 0.02 * (double)this.field_77287_j.field_73012_v.nextFloat();
                entity.field_70181_x += (double)(3.0f * this.field_77287_j.field_73012_v.nextFloat());
                r = (int)this.getRadius();
                if (zDifference < 0.0) {
                    r = (int)(-this.getRadius());
                }
                entity.field_70179_y += ((double)r - zDifference) * 0.02 * (double)this.field_77287_j.field_73012_v.nextFloat();
            }
        }
        if ((float)this.callCount > this.getRadius()) {
            this.controller.endExplosion();
        }
    }

    @Override
    public int proceduralInterval() {
        return 4;
    }

    @Override
    public long getEnergy() {
        return 3000L;
    }
}

