/*
 * Decompiled with CFR 0.152.
 */
package defense.common.item;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import defense.api.FrequencyGrid;
import defense.api.IBlockFrequency;
import defense.api.IItemFrequency;
import defense.common.CreativeTabHandler;
import defense.common.DefenseTech;
import defense.common.DefenseTechBlocks;
import defense.common.DefenseTechItems;
import defense.common.Reference;
import defense.common.Settings;
import defense.common.base.IItemPacket;
import defense.common.entity.EntityLightBeam;
import defense.common.network.PacketItem;
import defense.common.tile.TileLauncherPrefab;
import defense.common.tile.TileLauncherScreen;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Pos3D;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemEnergized;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemLaserDesignator
extends ItemEnergized
implements IItemFrequency,
IItemPacket {
    public static final int YONG_DIAN_LIANG = 8000;

    public ItemLaserDesignator() {
        super(100000.0);
        this.func_77655_b("laserDesignator");
        this.func_77637_a(CreativeTabHandler.INSTANCE);
        this.func_111206_d("defense:laserDesignator");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.field_77791_bV = reg.func_94245_a(this.func_111208_A());
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, par3List, par4);
        if (this.getFrequency(itemStack) > 0) {
            par3List.add(LangUtils.localize((String)"info.misc.freq") + " " + this.getFrequency(itemStack));
        } else {
            par3List.add(LangUtils.localize((String)"info.designator.noFreq"));
        }
    }

    @Override
    public int getFrequency(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0;
        }
        return itemStack.field_77990_d.func_74762_e("frequency");
    }

    @Override
    public void setFrequency(int frequency, ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74768_a("frequency", frequency);
    }

    public int getLauncherCountDown(ItemStack par1ItemStack) {
        if (par1ItemStack.field_77990_d == null) {
            return -1;
        }
        return par1ItemStack.field_77990_d.func_74762_e("countDown");
    }

    public void setLauncherCountDown(ItemStack par1ItemStack, int value) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.field_77990_d.func_74768_a("countDown", value);
    }

    public int getLauncherCount(ItemStack par1ItemStack) {
        if (par1ItemStack.field_77990_d == null) {
            return 0;
        }
        return par1ItemStack.field_77990_d.func_74762_e("launcherCount");
    }

    public void setLauncherCount(ItemStack par1ItemStack, int value) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.field_77990_d.func_74768_a("launcherCount", value);
    }

    public int getLauncherDelay(ItemStack par1ItemStack) {
        if (par1ItemStack.field_77990_d == null) {
            return 0;
        }
        return par1ItemStack.field_77990_d.func_74762_e("launcherDelay");
    }

    public void setLauncherDelay(ItemStack par1ItemStack, int value) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.field_77990_d.func_74768_a("launcherDelay", value);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, par3Entity, par4, par5);
        if (!world.field_72995_K) {
            ArrayList<TileLauncherPrefab> connectedLaunchers = new ArrayList<TileLauncherPrefab>();
            if (this.getLauncherCountDown(itemStack) > 0 || this.getLauncherCount(itemStack) > 0) {
                Pos3D position = new Pos3D(par3Entity.field_70165_t, par3Entity.field_70163_u, par3Entity.field_70161_v);
                for (IBlockFrequency blockFrequency : FrequencyGrid.instance().get(world, position, Settings.MAX_MISSILE_DISTANCE, this.getFrequency(itemStack))) {
                    TileLauncherPrefab missileLauncher;
                    if (!(blockFrequency instanceof TileLauncherPrefab) || !(missileLauncher = (TileLauncherPrefab)blockFrequency).canLaunch()) continue;
                    connectedLaunchers.add(missileLauncher);
                }
            }
            if (this.getLauncherCountDown(itemStack) > 0 && connectedLaunchers.size() > 0) {
                if (this.getLauncherCountDown(itemStack) % 20 == 0) {
                    ((EntityPlayer)par3Entity).func_145747_a((IChatComponent)new ChatComponentText(Reference.CHAT_DESC + EnumColor.GREY + " " + LangUtils.localize((String)"message.designator.callTime") + " " + (int)Math.floor(this.getLauncherCountDown(itemStack) / 20)));
                }
                if (this.getLauncherCountDown(itemStack) == 1) {
                    this.setLauncherCount(itemStack, connectedLaunchers.size());
                    this.setLauncherDelay(itemStack, 0);
                    ((EntityPlayer)par3Entity).func_145747_a((IChatComponent)new ChatComponentText(Reference.CHAT_DESC + EnumColor.GREY + " " + LangUtils.localize((String)"message.designator.blast")));
                }
                this.setLauncherCountDown(itemStack, this.getLauncherCountDown(itemStack) - 1);
            }
            if (this.getLauncherCount(itemStack) > 0 && this.getLauncherCount(itemStack) <= connectedLaunchers.size() && connectedLaunchers.size() > 0) {
                if (this.getLauncherDelay(itemStack) % 40 == 0) {
                    System.out.println(((TileLauncherPrefab)connectedLaunchers.get(this.getLauncherCount(itemStack) - 1)).getTarget());
                    ((TileLauncherPrefab)connectedLaunchers.get(this.getLauncherCount(itemStack) - 1)).launch();
                    this.setLauncherCount(itemStack, this.getLauncherCount(itemStack) - 1);
                }
                if (this.getLauncherCount(itemStack) == 0) {
                    this.setLauncherDelay(itemStack, 0);
                    connectedLaunchers.clear();
                }
                this.setLauncherDelay(itemStack, this.getLauncherDelay(itemStack) + 1);
            }
        }
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int x, int y, int z, int par7, float par8, float par9, float par10) {
        TileEntity tileEntity;
        if (!par3World.field_72995_K && (tileEntity = par3World.func_147438_o(x, y, z)) != null && tileEntity instanceof TileLauncherPrefab) {
            TileLauncherPrefab missileLauncher = (TileLauncherPrefab)tileEntity;
            if (missileLauncher.getFrequency() > 0) {
                this.setFrequency(missileLauncher.getFrequency(), par1ItemStack);
                par2EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText(Reference.CHAT_DESC + EnumColor.GREY + " " + LangUtils.localize((String)"message.designator.setFreq") + " " + EnumColor.DARK_GREY + this.getFrequency(par1ItemStack)));
            } else {
                par2EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText(Reference.CHAT_DESC + EnumColor.GREY + " " + LangUtils.localize((String)"message.designator.failFreq")));
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition objectMouseOver;
        if (world.field_72995_K && (objectMouseOver = player.func_70614_a((double)(Settings.MAX_MISSILE_DISTANCE * 2), 1.0f)) != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block block = world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
            int blockMetadata = world.func_72805_g(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
            if (this.getLauncherCountDown(stack) > 0) {
                return stack;
            }
            if (block == DefenseTechBlocks.blockMachine) {
                return stack;
            }
            int airStrikeFreq = this.getFrequency(stack);
            if (airStrikeFreq > 0) {
                if (this.getEnergy(stack) >= 8000.0) {
                    Pos3D position = new Pos3D(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    boolean doAirStrike = false;
                    int errorCount = 0;
                    for (IBlockFrequency blockFrequency : FrequencyGrid.instance().get(world, position, Settings.MAX_MISSILE_DISTANCE, airStrikeFreq)) {
                        if (!(blockFrequency instanceof TileLauncherPrefab)) continue;
                        TileLauncherPrefab missileLauncher = (TileLauncherPrefab)blockFrequency;
                        double yHit = objectMouseOver.field_72312_c;
                        if (missileLauncher instanceof TileLauncherScreen) {
                            yHit = missileLauncher.getTarget() != null ? missileLauncher.getTarget().yPos : 0.0;
                        }
                        missileLauncher.setTarget(new Pos3D((double)objectMouseOver.field_72311_b, yHit, (double)objectMouseOver.field_72309_d));
                        ArrayList<Integer> data = new ArrayList<Integer>();
                        data.add(2);
                        data.add((int)missileLauncher.getTarget().xPos);
                        data.add((int)missileLauncher.getTarget().yPos);
                        data.add((int)missileLauncher.getTarget().zPos);
                        Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)missileLauncher), data));
                        if (missileLauncher.canLaunch()) {
                            doAirStrike = true;
                            continue;
                        }
                        player.func_145747_a((IChatComponent)new ChatComponentText("#" + ++errorCount + " Missile Launcher Error: " + missileLauncher.getStatus()));
                    }
                    if (doAirStrike && this.getLauncherCountDown(stack) >= 0) {
                        ArrayList<Integer> data = new ArrayList<Integer>();
                        data.add(objectMouseOver.field_72311_b);
                        data.add(objectMouseOver.field_72312_c);
                        data.add(objectMouseOver.field_72309_d);
                        DefenseTech.netHandler.sendToServer((IMessage)new PacketItem.ItemMessage(data));
                        player.func_145747_a((IChatComponent)new ChatComponentText(Reference.CHAT_DESC + EnumColor.GREY + " " + LangUtils.localize((String)"message.designator.callBlast")));
                    }
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(Reference.CHAT_DESC + EnumColor.GREY + " " + LangUtils.localize((String)"message.designator.nopower")));
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(Reference.CHAT_DESC + EnumColor.GREY + " " + LangUtils.localize((String)"message.designator.noFreq")));
            }
        }
        return stack;
    }

    @Override
    public void handlePacket(EntityPlayer player, ByteBuf data) {
        ItemStack itemStack = player.func_71045_bC();
        Pos3D position = new Pos3D((double)data.readInt(), (double)data.readInt(), (double)data.readInt());
        ((ItemLaserDesignator)DefenseTechItems.itemLaserDesignator).setLauncherCountDown(itemStack, 119);
        player.field_70170_p.func_72908_a(position.xPos, (double)player.field_70170_p.func_72976_f((int)position.yPos, (int)position.zPos), position.zPos, "defense:airstrike", 5.0f, (1.0f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        player.field_70170_p.func_72838_d((Entity)new EntityLightBeam(player.field_70170_p, position, 100, 0.0f, 1.0f, 0.0f));
        if (itemStack.func_77973_b() instanceof ItemEnergized) {
            ItemEnergized item = (ItemEnergized)itemStack.func_77973_b();
            item.setEnergy(itemStack, item.getEnergy(itemStack) - 1000.0);
        }
    }
}

