/*
 * Decompiled with CFR 0.152.
 */
package defense.common.tile;

import cpw.mods.fml.common.eventhandler.Event;
import defense.api.ExplosionEvent;
import defense.api.ExplosiveType;
import defense.api.ILauncherContainer;
import defense.api.ILauncherController;
import defense.api.IMissile;
import defense.common.DefenseTech;
import defense.common.base.IBlockActivate;
import defense.common.entity.EntityMissile;
import defense.common.explosion.Explosion;
import defense.common.explosive.ExplosiveRegistry;
import defense.common.item.ItemMissile;
import defense.common.tile.TileLauncherPrefab;
import io.netty.buffer.ByteBuf;
import mekanism.api.Pos3D;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;

public class TileCruiseLauncher
extends TileLauncherPrefab
implements IBlockActivate,
IInventory,
ILauncherContainer {
    public IMissile daoDan = null;
    public float rotationYaw = 0.0f;
    public float rotationPitch = 0.0f;

    public TileCruiseLauncher() {
        super("CruiseLauncher", 1.0E7);
        this.targetPos = new Pos3D();
        this.inventory = new ItemStack[2];
    }

    @Override
    public String getStatus() {
        String color = "\u00a74";
        String status = LangUtils.localize((String)"gui.misc.idle");
        if (this.getEnergy() < this.getMaxEnergy()) {
            status = LangUtils.localize((String)"gui.launcherCruise.statusNoPower");
        } else if (this.daoDan == null) {
            status = LangUtils.localize((String)"gui.launcherCruise.statusEmpty");
        } else if (this.targetPos == null) {
            status = LangUtils.localize((String)"gui.launcherCruise.statusInvalid");
        } else {
            color = "\u00a72";
            status = LangUtils.localize((String)"gui.launcherCruise.statusReady");
        }
        return color + status;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int packetType = dataStream.readInt();
            if (packetType == 1) {
                this.setFrequency(dataStream.readInt());
            } else if (packetType == 2) {
                this.targetPos = new Pos3D((double)dataStream.readInt(), (double)dataStream.readInt(), (double)dataStream.readInt());
            }
            return;
        }
        super.handlePacketData(dataStream);
    }

    public String func_145825_b() {
        return LangUtils.localize((String)"gui.launcherCruise.name");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ChargeUtils.discharge((int)1, (IStrictEnergyStorage)this);
        if (this.getYawFromTarget() - this.rotationYaw != 0.0f) {
            this.rotationYaw = (float)((double)this.rotationYaw + (double)(this.getYawFromTarget() - this.rotationYaw) * 0.1);
        }
        if (this.getPitchFromTarget() - this.rotationPitch != 0.0f) {
            this.rotationPitch = (float)((double)this.rotationPitch + (double)(this.getPitchFromTarget() - this.rotationPitch) * 0.1);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.setMissile();
            if (this.ticker % 40 == 0 && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.launch();
            }
        }
    }

    @Override
    public void placeMissile(ItemStack itemStack) {
        this.inventory[0] = itemStack;
    }

    public void setMissile() {
        if (!this.field_145850_b.field_72995_K) {
            int haoMa;
            if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof ItemMissile && ExplosiveRegistry.get(haoMa = this.inventory[0].func_77960_j()) instanceof Explosion) {
                Explosion missile = (Explosion)ExplosiveRegistry.get(haoMa);
                ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ExplosiveType.AIR, missile);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (!evt.isCanceled()) {
                    if (this.daoDan == null && missile.isCruise() && missile.getTier() <= 3) {
                        Pos3D startingPosition = new Pos3D((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.0f), (double)((float)this.field_145849_e + 0.5f));
                        this.daoDan = new EntityMissile(this.field_145850_b, startingPosition, new Pos3D((TileEntity)this), haoMa);
                        this.field_145850_b.func_72838_d((Entity)this.daoDan);
                        return;
                    }
                    if (this.daoDan != null && this.daoDan.getExplosiveType().getID() == haoMa) {
                        return;
                    }
                }
            }
            if (this.daoDan != null) {
                ((Entity)this.daoDan).func_70106_y();
            }
            this.daoDan = null;
        }
    }

    private float getPitchFromTarget() {
        double distance = Math.sqrt((this.targetPos.xPos - (double)this.field_145851_c) * (this.targetPos.xPos - (double)this.field_145851_c) + (this.targetPos.zPos - (double)this.field_145849_e) * (this.targetPos.zPos - (double)this.field_145849_e));
        return (float)Math.toDegrees(Math.atan((this.targetPos.yPos - (double)((float)this.field_145848_d + 0.5f)) / distance));
    }

    private float getYawFromTarget() {
        double xDifference = this.targetPos.xPos - (double)((float)this.field_145851_c + 0.5f);
        double yDifference = this.targetPos.zPos - (double)((float)this.field_145849_e + 0.5f);
        return (float)Math.toDegrees(Math.atan2(yDifference, xDifference));
    }

    @Override
    public boolean canLaunch() {
        Explosion missile;
        return this.daoDan != null && this.inventory[0] != null && (missile = (Explosion)ExplosiveRegistry.get(this.inventory[0].func_77960_j())) != null && missile.getID() == this.daoDan.getExplosiveType().getID() && missile.isCruise() && missile.getTier() <= 3 && this.getEnergy() == this.getMaxEnergy() && !this.isTooClose(this.targetPos);
    }

    @Override
    public void launch() {
        if (this.canLaunch()) {
            this.func_70298_a(0, 1);
            this.setEnergy(0.0);
            this.daoDan.launch(this.targetPos);
            this.daoDan = null;
        }
    }

    public boolean isTooClose(Pos3D target) {
        return new Pos3D((double)this.field_145851_c, 0.0, (double)this.field_145849_e).distance(new Pos3D(target.xPos, 0.0, target.zPos)) < 8.0;
    }

    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean onActivated(EntityPlayer player) {
        if (player.field_71071_by.func_70448_g() != null) {
            if (player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemMissile) {
                if (this.func_70301_a(0) == null) {
                    this.func_70299_a(0, player.field_71071_by.func_70448_g());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    return true;
                }
                ItemStack player_held = player.field_71071_by.func_70448_g();
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.func_70301_a(0));
                }
                this.func_70299_a(0, player_held);
                return true;
            }
        } else if (this.func_70301_a(0) != null) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.func_70301_a(0));
            this.func_70299_a(0, null);
            return true;
        }
        player.openGui((Object)DefenseTech.INSTANCE, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public ILauncherController.LauncherType getLauncherType() {
        return ILauncherController.LauncherType.CRUISE;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        Explosion missile;
        return itemStack != null && itemStack.func_77973_b() instanceof ItemMissile && this.func_70301_a(slotID) == null && ExplosiveRegistry.get(itemStack.func_77960_j()) instanceof Explosion && (missile = (Explosion)ExplosiveRegistry.get(itemStack.func_77960_j())).isCruise() && missile.getTier() <= 3;
    }

    @Override
    public void setContainingMissile(IMissile missile) {
        this.daoDan = missile;
    }

    @Override
    public ILauncherController getController() {
        return this;
    }

    @Override
    public IMissile getMissile() {
        return this.daoDan;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }
}

