/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.helpers;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AEHelper {
    public static IGrid getGrid(IGridNode node) throws GridAccessException {
        if (node == null) {
            throw new GridAccessException();
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        return grid;
    }

    public static ITickManager getTick(IGridNode node) throws GridAccessException {
        IGrid grid = AEHelper.getGrid(node);
        if (grid == null) {
            throw new GridAccessException();
        }
        ITickManager pg = (ITickManager)grid.getCache(ITickManager.class);
        if (pg == null) {
            throw new GridAccessException();
        }
        return pg;
    }

    public static IStorageGrid getStorage(IGridNode node) throws GridAccessException {
        IGrid grid = AEHelper.getGrid(node);
        if (grid == null) {
            throw new GridAccessException();
        }
        IStorageGrid pg = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (pg == null) {
            throw new GridAccessException();
        }
        return pg;
    }

    public static P2PCache getP2P(IGridNode node) throws GridAccessException {
        IGrid grid = AEHelper.getGrid(node);
        if (grid == null) {
            throw new GridAccessException();
        }
        P2PCache pg = (P2PCache)grid.getCache(P2PCache.class);
        if (pg == null) {
            throw new GridAccessException();
        }
        return pg;
    }

    public static ISecurityGrid getSecurity(IGridNode node) throws GridAccessException {
        IGrid grid = AEHelper.getGrid(node);
        if (grid == null) {
            throw new GridAccessException();
        }
        ISecurityGrid sg = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        if (sg == null) {
            throw new GridAccessException();
        }
        return sg;
    }

    public static ICraftingGrid getCrafting(IGridNode node) throws GridAccessException {
        IGrid grid = AEHelper.getGrid(node);
        if (grid == null) {
            throw new GridAccessException();
        }
        ICraftingGrid sg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        if (sg == null) {
            throw new GridAccessException();
        }
        return sg;
    }

    public static boolean canInsert(IGridNode node, ItemStack stack) {
        try {
            return AEHelper.getStorage(node).getItemInventory().canAccept((IAEStack)AEItemStack.create((ItemStack)stack));
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public static IAEItemStack insert(IGridNode node, ItemStack stack, IActionHost host, boolean simulate) {
        if (AEHelper.canInsert(node, stack)) {
            try {
                return (IAEItemStack)AEHelper.getStorage(node).getItemInventory().injectItems((IAEStack)AEItemStack.create((ItemStack)stack), simulate ? Actionable.SIMULATE : Actionable.MODULATE, (BaseActionSource)new MachineSource(host));
            }
            catch (GridAccessException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public static ItemStack getInsertable(IGridNode node, ItemStack stack, IActionHost host) {
        IAEItemStack aeStack = AEHelper.insert(node, stack, host, true);
        if (aeStack == null) {
            return stack;
        }
        ItemStack result = stack.func_77946_l();
        result.field_77994_a = (int)((long)result.field_77994_a - aeStack.getStackSize());
        if (result.field_77994_a <= 0) {
            return null;
        }
        return result;
    }

    public static ItemStack extract(IGridNode node, ItemStack stack, IActionHost host) {
        try {
            return ((IAEItemStack)AEHelper.getStorage(node).getItemInventory().extractItems((IAEStack)AEItemStack.create((ItemStack)stack), Actionable.MODULATE, (BaseActionSource)new MachineSource(host))).getItemStack();
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public static IAEItemStack extract(IGridNode node, IAEItemStack stack, IActionHost host) {
        try {
            return (IAEItemStack)AEHelper.getStorage(node).getItemInventory().extractItems((IAEStack)stack, Actionable.MODULATE, (BaseActionSource)new MachineSource(host));
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public static boolean canInsert(IGridNode node, FluidStack stack) {
        try {
            return AEHelper.getStorage(node).getFluidInventory().canAccept((IAEStack)AEFluidStack.create((Object)stack));
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public static IAEFluidStack insert(IGridNode node, FluidStack stack, IActionHost host, boolean simulate) {
        if (AEHelper.canInsert(node, stack)) {
            try {
                return (IAEFluidStack)AEHelper.getStorage(node).getFluidInventory().injectItems((IAEStack)AEFluidStack.create((Object)stack), simulate ? Actionable.SIMULATE : Actionable.MODULATE, (BaseActionSource)new MachineSource(host));
            }
            catch (GridAccessException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public static IAEFluidStack extract(IGridNode node, FluidStack stack, IActionHost host, boolean simulate) {
        try {
            return (IAEFluidStack)AEHelper.getStorage(node).getFluidInventory().extractItems((IAEStack)AEFluidStack.create((Object)stack), simulate ? Actionable.SIMULATE : Actionable.MODULATE, (BaseActionSource)new MachineSource(host));
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public static IAEFluidStack extract(IGridNode node, IAEFluidStack stack, IActionHost host) {
        try {
            return (IAEFluidStack)AEHelper.getStorage(node).getFluidInventory().extractItems((IAEStack)stack, Actionable.MODULATE, (BaseActionSource)new MachineSource(host));
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public static ItemStack find(IGridNode node, ItemStack stack) {
        IAEItemStack aeItemStack = AEHelper.findAEStack(node, stack);
        if (aeItemStack == null) {
            return null;
        }
        return aeItemStack.getItemStack();
    }

    public static IAEItemStack findAEStack(IGridNode node, ItemStack stack) {
        try {
            return (IAEItemStack)AEHelper.getStorage(node).getItemInventory().getStorageList().findPrecise((IAEStack)AEItemStack.create((ItemStack)stack));
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public static IAEFluidStack find(IGridNode node, FluidStack stack) {
        try {
            return (IAEFluidStack)AEHelper.getStorage(node).getFluidInventory().getStorageList().findPrecise((IAEStack)AEFluidStack.create((Object)stack));
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public static Iterator<IAEItemStack> getItrItems(IGridNode node) {
        try {
            return AEHelper.getStorage(node).getItemInventory().getStorageList().iterator();
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public static Iterator<IAEFluidStack> getItrFluids(IGridNode node) {
        try {
            return AEHelper.getStorage(node).getFluidInventory().getStorageList().iterator();
        }
        catch (GridAccessException e) {
            return null;
        }
    }
}

