/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import logisticspipes.gui.popup.GuiAddMacro;
import logisticspipes.interfaces.IDiskProvider;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.orderer.DiscContent;
import logisticspipes.network.packets.orderer.DiskMacroRequestPacket;
import logisticspipes.network.packets.orderer.DiskSetNamePacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.SubGuiScreen;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiDiskPopup
extends SubGuiScreen {
    private boolean editname = false;
    private boolean displaycursor = false;
    private long oldSystemTime = 0L;
    private int mouseX = 0;
    private int mouseY = 0;
    private String name1;
    private String name2;
    private int scroll = 0;
    private int selected = -1;
    private final IDiskProvider diskProvider;
    private final int searchWidth = 120;

    public GuiDiskPopup(IDiskProvider diskProvider) {
        super(150, 200, 0, 0);
        this.diskProvider = diskProvider;
        this.name2 = "";
        this.name1 = diskProvider.getDisk().func_77942_o() ? diskProvider.getDisk().func_77978_p().func_74779_i("name") : "Disk";
    }

    protected void func_73864_a(int i, int j, int k) {
        int x = i - this.guiLeft;
        int y = j - this.guiTop;
        this.mouseX = i;
        this.mouseY = j;
        if (k == 0) {
            if (10 < x && x < 138 && 29 < y && y < 44) {
                this.editname = true;
            } else if (this.editname) {
                this.writeDiskName();
            } else {
                super.func_73864_a(i, j, k);
            }
        } else {
            super.func_73864_a(i, j, k);
        }
    }

    private void writeDiskName() {
        this.editname = false;
        MainProxy.sendPacketToServer(PacketHandler.getPacket(DiskSetNamePacket.class).setString(this.name1 + this.name2).setPosX(this.diskProvider.getX()).setPosY(this.diskProvider.getY()).setPosZ(this.diskProvider.getZ()));
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.diskProvider.getDisk().func_77942_o()) {
            nbt = this.diskProvider.getDisk().func_77978_p();
        }
        nbt.func_74778_a("name", this.name1 + this.name2);
        this.diskProvider.getDisk().func_77982_d(nbt);
        MainProxy.sendPacketToServer(PacketHandler.getPacket(DiscContent.class).setStack(this.diskProvider.getDisk()).setPosX(this.diskProvider.getX()).setPosY(this.diskProvider.getY()).setPosZ(this.diskProvider.getZ()));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(0, this.xCenter + 16, this.bottom - 27, 50, 10, "Request"));
        this.field_146292_n.add(new SmallGuiButton(1, this.xCenter + 16, this.bottom - 15, 50, 10, "Exit"));
        this.field_146292_n.add(new SmallGuiButton(2, this.xCenter - 66, this.bottom - 27, 50, 10, "Add/Edit"));
        this.field_146292_n.add(new SmallGuiButton(3, this.xCenter - 66, this.bottom - 15, 50, 10, "Delete"));
        this.field_146292_n.add(new SmallGuiButton(4, this.xCenter - 12, this.bottom - 27, 25, 10, "/\\"));
        this.field_146292_n.add(new SmallGuiButton(5, this.xCenter - 12, this.bottom - 15, 25, 10, "\\/"));
    }

    @Override
    protected void renderGuiBackground(int par1, int par2) {
        NBTTagList list;
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.guiLeft, this.guiTop, this.right, this.bottom, this.field_73735_i, true);
        this.field_146297_k.field_71466_p.func_78261_a("Disk", this.xCenter - this.field_146297_k.field_71466_p.func_78256_a("Disk") / 2, this.guiTop + 10, 0xFFFFFF);
        if (this.editname) {
            Gui.func_73734_a((int)(this.guiLeft + 10), (int)(this.guiTop + 28), (int)(this.right - 10), (int)(this.guiTop + 45), (int)Color.getValue(Color.BLACK));
            Gui.func_73734_a((int)(this.guiLeft + 11), (int)(this.guiTop + 29), (int)(this.right - 11), (int)(this.guiTop + 44), (int)Color.getValue(Color.WHITE));
        } else {
            Gui.func_73734_a((int)(this.guiLeft + 11), (int)(this.guiTop + 29), (int)(this.right - 11), (int)(this.guiTop + 44), (int)Color.getValue(Color.BLACK));
        }
        Gui.func_73734_a((int)(this.guiLeft + 12), (int)(this.guiTop + 30), (int)(this.right - 12), (int)(this.guiTop + 43), (int)Color.getValue(Color.DARKER_GREY));
        this.field_146297_k.field_71466_p.func_78276_b(this.name1 + this.name2, this.guiLeft + 15, this.guiTop + 33, 0xFFFFFF);
        Gui.func_73734_a((int)(this.guiLeft + 6), (int)(this.guiTop + 46), (int)(this.right - 6), (int)(this.bottom - 30), (int)Color.getValue(Color.GREY));
        NBTTagCompound nbt = this.diskProvider.getDisk().func_77978_p();
        if (nbt == null) {
            this.diskProvider.getDisk().func_77982_d(new NBTTagCompound());
            nbt = this.diskProvider.getDisk().func_77978_p();
        }
        if (!nbt.func_74764_b("macroList")) {
            list = new NBTTagList();
            nbt.func_74782_a("macroList", (NBTBase)list);
        }
        if (this.scroll + 12 > (list = nbt.func_150295_c("macroList", 10)).func_74745_c()) {
            this.scroll = list.func_74745_c() - 12;
        }
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        boolean flag = false;
        if (this.guiLeft + 8 < this.mouseX && this.mouseX < this.right - 8 && this.guiTop + 48 < this.mouseY && this.mouseY < this.guiTop + 59 + 110) {
            this.selected = this.scroll + (this.mouseY - this.guiTop - 49) / 10;
        }
        for (int i = this.scroll; i < list.func_74745_c() && i - this.scroll < 12; ++i) {
            if (i == this.selected) {
                Gui.func_73734_a((int)(this.guiLeft + 8), (int)(this.guiTop + 48 + (i - this.scroll) * 10), (int)(this.right - 8), (int)(this.guiTop + 59 + (i - this.scroll) * 10), (int)Color.getValue(Color.DARKER_GREY));
                flag = true;
            }
            NBTTagCompound entry = list.func_150305_b(i);
            String name = entry.func_74779_i("name");
            this.field_146297_k.field_71466_p.func_78276_b(name, this.guiLeft + 10, this.guiTop + 50 + (i - this.scroll) * 10, 0xFFFFFF);
        }
        if (!flag) {
            this.selected = -1;
        }
        if (this.editname) {
            int linex = this.guiLeft + 15 + this.field_146297_k.field_71466_p.func_78256_a(this.name1);
            if (System.currentTimeMillis() - this.oldSystemTime > 500L) {
                this.displaycursor = !this.displaycursor;
                this.oldSystemTime = System.currentTimeMillis();
            }
            if (this.displaycursor) {
                Gui.func_73734_a((int)linex, (int)(this.guiTop + 31), (int)(linex + 1), (int)(this.guiTop + 42), (int)Color.getValue(Color.WHITE));
            }
        }
    }

    @Override
    public void handleMouseInputSub() {
        int wheel = Mouse.getDWheel() / 120;
        if (wheel == 0) {
            super.handleMouseInputSub();
        }
        if (wheel < 0) {
            ++this.scroll;
        } else if (wheel > 0 && this.scroll > 0) {
            --this.scroll;
        }
    }

    private void handleRequest() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(DiskMacroRequestPacket.class).setInteger(this.selected).setPosX(this.diskProvider.getX()).setPosY(this.diskProvider.getY()).setPosZ(this.diskProvider.getZ()));
    }

    private void handleDelete() {
        NBTTagList list;
        NBTTagCompound nbt = this.diskProvider.getDisk().func_77978_p();
        if (nbt == null) {
            this.diskProvider.getDisk().func_77982_d(new NBTTagCompound());
            nbt = this.diskProvider.getDisk().func_77978_p();
        }
        if (!nbt.func_74764_b("macroList")) {
            list = new NBTTagList();
            nbt.func_74782_a("macroList", (NBTBase)list);
        }
        list = nbt.func_150295_c("macroList", 10);
        NBTTagList listnew = new NBTTagList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (i == this.selected) continue;
            listnew.func_74742_a((NBTBase)list.func_150305_b(i));
        }
        this.selected = -1;
        nbt.func_74782_a("macroList", (NBTBase)listnew);
        MainProxy.sendPacketToServer(PacketHandler.getPacket(DiscContent.class).setStack(this.diskProvider.getDisk()).setPosX(this.diskProvider.getX()).setPosY(this.diskProvider.getY()).setPosZ(this.diskProvider.getZ()));
    }

    private void handleAddEdit() {
        String macroname = "";
        NBTTagCompound nbt = this.diskProvider.getDisk().func_77978_p();
        if (nbt != null && nbt.func_74764_b("macroList")) {
            NBTTagList list = nbt.func_150295_c("macroList", 10);
            if (this.selected != -1 && this.selected < list.func_74745_c()) {
                NBTTagCompound entry = list.func_150305_b(this.selected);
                macroname = entry.func_74779_i("name");
            }
        }
        this.setSubGui(new GuiAddMacro(this.diskProvider, macroname));
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0) {
            this.handleRequest();
        } else if (guibutton.field_146127_k == 1) {
            this.exitGui();
        } else if (guibutton.field_146127_k == 2) {
            this.handleAddEdit();
        } else if (guibutton.field_146127_k == 3) {
            this.handleDelete();
        } else if (guibutton.field_146127_k == 4) {
            if (this.scroll > 0) {
                --this.scroll;
            }
        } else if (guibutton.field_146127_k == 5) {
            ++this.scroll;
        } else {
            super.func_146284_a(guibutton);
        }
    }

    @Override
    protected void func_73869_a(char c, int i) {
        if (this.editname) {
            if (c == '\r') {
                this.writeDiskName();
                return;
            }
            if (i == 47 && Keyboard.isKeyDown((int)29)) {
                this.name1 = this.name1 + GuiScreen.func_146277_j();
            } else {
                if (c == '\b') {
                    if (this.name1.length() > 0) {
                        this.name1 = this.name1.substring(0, this.name1.length() - 1);
                    }
                    return;
                }
                if (Character.isLetterOrDigit(c) || c == ' ') {
                    if (this.field_146297_k.field_71466_p.func_78256_a(this.name1 + c + this.name2) <= 120) {
                        this.name1 = this.name1 + c;
                    }
                    return;
                }
                if (i == 203) {
                    if (this.name1.length() > 0) {
                        this.name2 = this.name1.substring(this.name1.length() - 1) + this.name2;
                        this.name1 = this.name1.substring(0, this.name1.length() - 1);
                    }
                } else if (i == 205) {
                    if (this.name2.length() > 0) {
                        this.name1 = this.name1 + this.name2.substring(0, 1);
                        this.name2 = this.name2.substring(1);
                    }
                } else if (i == 1) {
                    this.writeDiskName();
                } else if (i == 28) {
                    this.writeDiskName();
                } else if (i == 199) {
                    this.name2 = this.name1 + this.name2;
                    this.name1 = "";
                } else if (i == 207) {
                    this.name1 = this.name1 + this.name2;
                    this.name2 = "";
                } else if (i == 211 && this.name2.length() > 0) {
                    this.name2 = this.name2.substring(1);
                }
            }
        } else {
            super.func_73869_a(c, i);
        }
    }
}

