/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import logisticspipes.gui.hud.modules.HUDItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.network.guis.module.inhand.ItemSinkInHand;
import logisticspipes.network.guis.module.inpipe.ItemSinkSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.network.packets.modules.ItemSinkDefault;
import logisticspipes.network.packets.modules.ItemSinkFuzzy;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

@CCType(name="ItemSink Module")
public class ModuleItemSink
extends LogisticsGuiModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive {
    private final ItemIdentifierInventory _filterInventory = new ItemIdentifierInventory(9, "Requested items", 1);
    private boolean _isDefaultRoute;
    private BitSet ignoreData = new BitSet(this._filterInventory.func_70302_i_());
    private BitSet ignoreNBT = new BitSet(this._filterInventory.func_70302_i_());
    private IHUDModuleRenderer HUD = new HUDItemSink(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private SinkReply _sinkReply;
    private SinkReply _sinkReplyDefault;

    public ModuleItemSink() {
        this._filterInventory.addListener(this);
    }

    @CCCommand(description="Returns the FilterInventory of this Module")
    public ItemIdentifierInventory getFilterInventory() {
        return this._filterInventory;
    }

    @CCCommand(description="Returns true if the module is a default route")
    public boolean isDefaultRoute() {
        return this._isDefaultRoute;
    }

    @CCCommand(description="Sets the default route status of this module")
    public void setDefaultRoute(Boolean isDefaultRoute) {
        this._isDefaultRoute = isDefaultRoute;
        if (!this.localModeWatchers.isEmpty()) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ItemSinkDefault.class).setFlag(this._isDefaultRoute).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
        this._sinkReplyDefault = new SinkReply(SinkReply.FixedPriority.DefaultRoute, 0, true, true, 1, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (this._isDefaultRoute && !allowDefault) {
            return null;
        }
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        if (this._filterInventory.containsUndamagedItem(item.getUndamaged())) {
            if (this._service.canUseEnergy(1)) {
                return this._sinkReply;
            }
            return null;
        }
        if (this._service.getUpgradeManager(this.slot, this.positionInt).isFuzzyUpgrade()) {
            for (Pair<ItemIdentifierStack, Integer> stack : this._filterInventory) {
                if (stack == null || stack.getValue1() == null) continue;
                ItemIdentifier ident1 = item;
                ItemIdentifier ident2 = stack.getValue1().getItem();
                if (this.ignoreData.get(stack.getValue2())) {
                    ident1 = ident1.getIgnoringData();
                    ident2 = ident2.getIgnoringData();
                }
                if (this.ignoreNBT.get(stack.getValue2())) {
                    ident1 = ident1.getIgnoringNBT();
                    ident2 = ident2.getIgnoringNBT();
                }
                if (!ident1.equals(ident2)) continue;
                if (this._service.canUseEnergy(5)) {
                    return this._sinkReply;
                }
                return null;
            }
        }
        if (this._isDefaultRoute) {
            if (bestPriority > this._sinkReplyDefault.fixedPriority.ordinal() || bestPriority == this._sinkReplyDefault.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReplyDefault.customPriority) {
                return null;
            }
            if (this._service.canUseEnergy(1)) {
                return this._sinkReplyDefault;
            }
            return null;
        }
        return null;
    }

    @Override
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ItemSinkSlot.class).setDefaultRoute(this._isDefaultRoute).setIgnoreData(this.ignoreData).setIgnoreNBT(this.ignoreNBT).setHasFuzzyUpgrade(this._service.getUpgradeManager(this.slot, this.positionInt).isFuzzyUpgrade());
    }

    @Override
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ItemSinkInHand.class);
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this._isDefaultRoute = nbttagcompound.func_74767_n("defaultdestination");
        if (nbttagcompound.func_74764_b("ignoreData")) {
            this.ignoreData = BitSet.valueOf(nbttagcompound.func_74770_j("ignoreData"));
            this.ignoreNBT = BitSet.valueOf(nbttagcompound.func_74770_j("ignoreNBT"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("defaultdestination", this.isDefaultRoute());
        nbttagcompound.func_74773_a("ignoreData", this.ignoreData.toByteArray());
        nbttagcompound.func_74773_a("ignoreNBT", this.ignoreNBT.toByteArray());
    }

    @Override
    public void tick() {
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Default: " + (this.isDefaultRoute() ? "Yes" : "No"));
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._filterInventory)).setModulePos(this), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ItemSinkDefault.class).setFlag(this._isDefaultRoute).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer(this._world.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return this._isDefaultRoute;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        if (this._isDefaultRoute) {
            return null;
        }
        Map<ItemIdentifier, Integer> mapIC = this._filterInventory.getItemsAndCount();
        ArrayList<ItemIdentifier> li = new ArrayList<ItemIdentifier>(mapIC.size());
        li.addAll(mapIC.keySet());
        for (ItemIdentifier id : mapIC.keySet()) {
            li.add(id.getUndamaged());
        }
        if (this._service.getUpgradeManager(this.slot, this.positionInt).isFuzzyUpgrade()) {
            for (Pair stack : this._filterInventory) {
                if (stack.getValue1() == null) continue;
                ItemIdentifier ident = ((ItemIdentifierStack)stack.getValue1()).getItem();
                if (this.ignoreData.get((Integer)stack.getValue2())) {
                    li.add(ident.getIgnoringData());
                }
                if (this.ignoreNBT.get((Integer)stack.getValue2())) {
                    li.add(ident.getIgnoringNBT());
                }
                if (!this.ignoreData.get((Integer)stack.getValue2()) || !this.ignoreNBT.get((Integer)stack.getValue2())) continue;
                li.add(ident.getIgnoringData().getIgnoringNBT());
            }
        }
        return li;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleItemSink");
    }

    public void setIgnoreData(BitSet ignoreData) {
        this.ignoreData = ignoreData;
    }

    public void setIgnoreNBT(BitSet ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
    }

    public boolean isIgnoreData(int pos) {
        return this.ignoreData.get(pos);
    }

    public boolean isIgnoreNBT(int pos) {
        return this.ignoreNBT.get(pos);
    }

    public void setIgnoreData(int slot, EntityPlayer player) {
        if (slot < 0 || slot >= 9) {
            return;
        }
        if (MainProxy.isClient(this._world.getWorld())) {
            if (player == null) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(ItemSinkFuzzy.class).setPos(slot).setNBT(false).setModulePos(this));
            }
        } else {
            this.ignoreData.set(slot, !this.ignoreData.get(slot));
            ModuleCoordinatesPacket pak = PacketHandler.getPacket(ItemSinkFuzzy.class).setIgnoreData(this.ignoreData).setIgnoreNBT(this.ignoreNBT).setModulePos(this);
            if (player != null) {
                MainProxy.sendPacketToPlayer(pak, player);
            }
            MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), MainProxy.getDimensionForWorld(this._world.getWorld()), pak);
        }
    }

    public void setIgnoreNBT(int slot, EntityPlayer player) {
        if (slot < 0 || slot >= 9) {
            return;
        }
        if (MainProxy.isClient(this._world.getWorld())) {
            if (player == null) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(ItemSinkFuzzy.class).setPos(slot).setNBT(true).setModulePos(this));
            }
        } else {
            this.ignoreNBT.set(slot, !this.ignoreNBT.get(slot));
            ModuleCoordinatesPacket pak = PacketHandler.getPacket(ItemSinkFuzzy.class).setIgnoreData(this.ignoreData).setIgnoreNBT(this.ignoreNBT).setModulePos(this);
            if (player != null) {
                MainProxy.sendPacketToPlayer(pak, player);
            }
            MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), MainProxy.getDimensionForWorld(this._world.getWorld()), pak);
        }
    }

    public void importFromInventory() {
        if (this._service == null) {
            return;
        }
        IInventoryUtil inv = this._service.getPointedInventory(false);
        if (inv == null) {
            return;
        }
        int count = 0;
        for (ItemIdentifier item : inv.getItems()) {
            this._filterInventory.setInventorySlotContents(count, item.makeStack(1));
            if (++count < this._filterInventory.func_70302_i_()) continue;
            break;
        }
    }
}

