/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ThaumicAspectSinkModuleInHand;
import logisticspipes.network.guis.module.inpipe.ThaumicAspectSinkModuleSlot;
import logisticspipes.network.packets.module.ThaumicAspectsSinkList;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleThaumicAspectSink
extends LogisticsGuiModule
implements IClientInformationProvider,
IModuleWatchReciver {
    public final List<String> aspectList = new LinkedList<String>();
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private SinkReply _sinkReply;

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, -2, true, false, 5, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        if (this.isOfInterest(item)) {
            return this._sinkReply;
        }
        return null;
    }

    private boolean isOfInterest(ItemIdentifier itemID) {
        if (itemID == null || this.aspectList.size() == 0) {
            return false;
        }
        ItemStack item = itemID.makeNormalStack(1);
        List<String> itemAspectList = SimpleServiceLocator.thaumCraftProxy.getListOfTagsForStack(item);
        if (itemAspectList == null || itemAspectList.size() == 0) {
            return false;
        }
        for (int i = 0; i < itemAspectList.size(); ++i) {
            if (!this.aspectList.contains(itemAspectList.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.aspectList.clear();
        int size = nbttagcompound.func_74762_e("aspectTagListSize");
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.aspectList.add(nbttagcompound.func_74779_i("aspectTag" + i));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("aspectTagListSize", this.aspectList.size());
        if (this.aspectList.size() <= 0) {
            return;
        }
        for (int i = 0; i < this.aspectList.size(); ++i) {
            nbttagcompound.func_74778_a("aspectTag" + i, this.aspectList.get(i));
        }
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ThaumicAspectsSinkList.class).setTag(nbt).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    public void aspectListChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ThaumicAspectsSinkList.class).setTag(nbt).setModulePos(this), this.localModeWatchers);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ThaumicAspectsSinkList.class).setTag(nbt).setModulePos(this));
        }
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Aspects: ");
        if (this.aspectList.size() == 0) {
            info.add("none");
        }
        for (int i = 0; i < this.aspectList.size(); ++i) {
            info.add(" - " + this.aspectList.get(i));
        }
        return info;
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return NewGuiHandler.getGui(ThaumicAspectSinkModuleSlot.class).setNbt(tag);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ThaumicAspectSinkModuleInHand.class);
    }

    public void guiAddAspect(String aspect) {
        if (this.aspectList.contains(aspect) || this.aspectList.size() >= 9) {
            return;
        }
        this.aspectList.add(aspect);
        this.aspectListChanged();
    }

    public void guiRemoveAspect(String aspect) {
        if (!this.aspectList.contains(aspect)) {
            return;
        }
        this.aspectList.remove(aspect);
        this.aspectListChanged();
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleThaumicAspectSink");
    }
}

