/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialtankhandler;

import buildcraft.factory.TileTank;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.ISpecialTankAccessHandler;
import logisticspipes.utils.FluidIdentifier;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class BuildCraftTankHandler
implements ISpecialTankAccessHandler {
    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return tile instanceof TileTank;
    }

    @Override
    public List<TileEntity> getBaseTilesFor(TileEntity tile) {
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>(1);
        tiles.add((TileEntity)((TileTank)tile).getBottomTank());
        return tiles;
    }

    @Override
    public Map<FluidIdentifier, Long> getAvailableLiquid(TileEntity tile) {
        FluidTankInfo[] tanks;
        HashMap<FluidIdentifier, Long> map = new HashMap<FluidIdentifier, Long>();
        for (FluidTankInfo tank : tanks = ((IFluidHandler)tile).getTankInfo(ForgeDirection.UNKNOWN)) {
            FluidStack liquid;
            if (tank == null || (liquid = tank.fluid) == null || liquid.getFluidID() == 0) continue;
            FluidIdentifier ident = FluidIdentifier.get(liquid);
            if (((IFluidHandler)tile).drain(ForgeDirection.UNKNOWN, 1, false) == null) continue;
            if (map.containsKey(ident)) {
                long addition = (Long)map.get(ident) + (long)tank.fluid.amount;
                map.put(ident, addition);
                continue;
            }
            map.put(ident, Long.valueOf(tank.fluid.amount));
        }
        return map;
    }

    @Override
    public FluidStack drainFrom(TileEntity tile, FluidIdentifier ident, Integer amount, boolean drain) {
        tile = ((TileTank)tile).getBottomTank();
        return ((IFluidHandler)tile).drain(ForgeDirection.UNKNOWN, ident.makeFluidStack(amount), drain);
    }
}

