/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import openmods.structured.FieldContainer;
import openperipheral.addons.glasses.IOwnerProxy;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Env;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.architecture.IArchitecture;
import openperipheral.api.helpers.Index;
import openperipheral.api.property.IIndexedPropertyListener;
import openperipheral.api.property.ISinglePropertyListener;

@Asynchronous
public abstract class StructuredObjectBase
extends FieldContainer
implements ISinglePropertyListener,
IIndexedPropertyListener {
    private boolean deleted;
    private int id;
    private IOwnerProxy owner = IOwnerProxy.DUMMY;

    @ScriptCallable
    public void delete() {
        this.checkState();
        this.owner.removeContainer(this.id);
        this.setDeleted();
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, name="getId")
    public Index getId(@Env(value="architecture") IArchitecture access) {
        this.checkState();
        return access.createIndex(this.id);
    }

    public void setOwner(IOwnerProxy owner) {
        this.owner = owner;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    private void handleFieldSet(Field field) {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"Object is already deleted");
        Integer elementId = this.getElementIdForField(field);
        if (elementId != null) {
            this.owner.markElementModified(elementId);
        }
    }

    private void checkState() {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"Object is already deleted");
    }

    @Override
    public void onPropertySet(Field field, Object value) {
        this.handleFieldSet(field);
    }

    @Override
    public void onPropertySet(Field field, Object key, Object value) {
        this.handleFieldSet(field);
    }

    @Override
    public void onPropertyGet(Field field) {
        this.checkState();
    }

    @Override
    public void onPropertyGet(Field field, Object key) {
        this.checkState();
    }

    public void setDeleted() {
        this.deleted = true;
    }

    protected void markModified(int id) {
        this.owner.markElementModified(id);
    }
}

