/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.server;

import com.google.common.base.Objects;
import openperipheral.addons.glasses.IContainer;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.drawable.GradientBox;
import openperipheral.addons.glasses.drawable.GradientLine;
import openperipheral.addons.glasses.drawable.GradientLineStrip;
import openperipheral.addons.glasses.drawable.GradientPolygon;
import openperipheral.addons.glasses.drawable.GradientQuad;
import openperipheral.addons.glasses.drawable.GradientTriangle;
import openperipheral.addons.glasses.drawable.ItemIcon;
import openperipheral.addons.glasses.drawable.LiquidIcon;
import openperipheral.addons.glasses.drawable.Point;
import openperipheral.addons.glasses.drawable.SolidBox;
import openperipheral.addons.glasses.drawable.SolidLine;
import openperipheral.addons.glasses.drawable.SolidLineStrip;
import openperipheral.addons.glasses.drawable.SolidPolygon;
import openperipheral.addons.glasses.drawable.SolidQuad;
import openperipheral.addons.glasses.drawable.SolidTriangle;
import openperipheral.addons.glasses.drawable.Text;
import openperipheral.addons.glasses.server.IDrawableFactory;
import openperipheral.addons.glasses.utils.ColorPoint2d;
import openperipheral.addons.glasses.utils.Point2d;

public class DrawableFactory
implements IDrawableFactory {
    private final IContainer<Drawable> container;

    private static Integer defaultColor(Integer color) {
        return (Integer)Objects.firstNonNull((Object)color, (Object)0xFFFFFF);
    }

    private static Float defaultOpacity(Float opacity) {
        return (Float)Objects.firstNonNull((Object)opacity, (Object)Float.valueOf(1.0f));
    }

    public DrawableFactory(IContainer<Drawable> container) {
        this.container = container;
    }

    @Override
    public synchronized Drawable addText(float x, float y, String text, Integer color) {
        return this.container.addObject(new Text(x, y, text, DrawableFactory.defaultColor(color)));
    }

    @Override
    public synchronized Drawable addBox(float x, float y, float width, float height, Integer color, Float opacity) {
        return this.container.addObject(new SolidBox(x, y, width, height, DrawableFactory.defaultColor(color), DrawableFactory.defaultOpacity(opacity).floatValue()));
    }

    @Override
    public synchronized Drawable addGradientBox(float x, float y, float width, float height, int color, float alpha, int color2, float alpha2, int gradient) {
        return this.container.addObject(new GradientBox(x, y, width, height, color, alpha, color2, alpha2, gradient));
    }

    @Override
    public synchronized Drawable addIcon(float x, float y, String id, Short meta) {
        return this.container.addObject(new ItemIcon(x, y, id, meta != null ? meta : (short)0));
    }

    @Override
    public synchronized Drawable addLiquid(float x, float y, float width, float height, String id) {
        return this.container.addObject(new LiquidIcon(x, y, width, height, id));
    }

    @Override
    public Drawable addTriangle(Point2d p1, Point2d p2, Point2d p3, Integer color, Float opacity) {
        return this.container.addObject(new SolidTriangle(p1, p2, p3, DrawableFactory.defaultColor(color), DrawableFactory.defaultOpacity(opacity).floatValue()));
    }

    @Override
    public Drawable addGradientTriangle(ColorPoint2d p1, ColorPoint2d p2, ColorPoint2d p3) {
        return this.container.addObject(new GradientTriangle(p1, p2, p3));
    }

    @Override
    public Drawable addQuad(Point2d p1, Point2d p2, Point2d p3, Point2d p4, Integer color, Float opacity) {
        return this.container.addObject(new SolidQuad(p1, p2, p3, p4, DrawableFactory.defaultColor(color), DrawableFactory.defaultOpacity(opacity).floatValue()));
    }

    @Override
    public Drawable addGradientQuad(ColorPoint2d p1, ColorPoint2d p2, ColorPoint2d p3, ColorPoint2d p4) {
        return this.container.addObject(new GradientQuad(p1, p2, p3, p4));
    }

    @Override
    public Drawable addLine(Point2d p1, Point2d p2, Integer color, Float opacity) {
        return this.container.addObject(new SolidLine(p1, p2, DrawableFactory.defaultColor(color), DrawableFactory.defaultOpacity(opacity).floatValue()));
    }

    @Override
    public Drawable addGradientLine(ColorPoint2d p1, ColorPoint2d p2) {
        return this.container.addObject(new GradientLine(p1, p2));
    }

    @Override
    public Drawable addLineList(Integer color, Float opacity, Point2d ... points) {
        return this.container.addObject(new SolidLineStrip(DrawableFactory.defaultColor(color), DrawableFactory.defaultOpacity(opacity).floatValue(), points));
    }

    @Override
    public Drawable addGradientLineList(ColorPoint2d ... points) {
        return this.container.addObject(new GradientLineStrip(points));
    }

    @Override
    public Drawable addPolygon(Integer color, Float opacity, Point2d ... points) {
        return this.container.addObject(new SolidPolygon(DrawableFactory.defaultColor(color), DrawableFactory.defaultOpacity(opacity).floatValue(), points));
    }

    @Override
    public Drawable addGradientPolygon(ColorPoint2d ... points) {
        return this.container.addObject(new GradientPolygon(points));
    }

    @Override
    public Drawable addPoint(Point2d p, Integer color, Float opacity) {
        return this.container.addObject(new Point(p, DrawableFactory.defaultColor(color), DrawableFactory.defaultOpacity(opacity).floatValue()));
    }
}

