/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.appeng;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.converter.IConverter;
import openperipheral.integration.appeng.CraftingRequester;

public class CraftingCallback
implements ICraftingCallback {
    private final IArchitectureAccess access;
    private final IConverter converter;
    private final IMEMonitor<IAEItemStack> monitor;
    private final MachineSource source;
    private final IActionHost actionHost;
    private final ICraftingGrid craftingGrid;
    private final ICraftingCPU wantedCpu;
    private final Object requestedStack;

    public CraftingCallback(IArchitectureAccess access, IConverter converter, ICraftingGrid craftingGrid, IMEMonitor<IAEItemStack> monitor, IActionHost actionHost, ICraftingCPU wantedCpu, IAEItemStack requestedStack) {
        this.access = access;
        this.converter = converter;
        this.monitor = monitor;
        this.source = new MachineSource(actionHost);
        this.actionHost = actionHost;
        this.craftingGrid = craftingGrid;
        this.wantedCpu = wantedCpu;
        this.requestedStack = converter.fromJava(requestedStack);
    }

    public void calculationComplete(ICraftingJob job) {
        if (job.isSimulation()) {
            this.sendSimulationInfo(job);
        } else {
            CraftingRequester craftingRequester = new CraftingRequester(this.actionHost, this.access, this.requestedStack);
            this.craftingGrid.submitJob(job, (ICraftingRequester)craftingRequester, this.wantedCpu, false, (BaseActionSource)this.source);
        }
    }

    private void sendSimulationInfo(ICraftingJob job) {
        IItemList plan = AEApi.instance().storage().createItemList();
        job.populatePlan(plan);
        ArrayList missingItems = Lists.newArrayList();
        for (IAEItemStack needed : plan) {
            IAEItemStack toExtract = needed.copy();
            toExtract.reset();
            toExtract.setStackSize(needed.getStackSize());
            IAEItemStack extracted = (IAEItemStack)this.monitor.extractItems((IAEStack)toExtract, Actionable.SIMULATE, (BaseActionSource)this.source);
            long missing = needed.getStackSize();
            if (extracted != null) {
                missing -= extracted.getStackSize();
            }
            if (missing <= 0L) continue;
            IAEItemStack missingStack = needed.copy();
            missingItems.add(missingStack);
        }
        this.access.signal("crafting_state", this.converter.fromJava(this.requestedStack), "missing_items", this.converter.fromJava(missingItems));
    }
}

