/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft.v2;

import com.google.common.collect.Sets;
import com.xcompwiz.mystcraft.api.hook.PageAPI;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.api.meta.IItemStackCustomMetaProvider;
import openperipheral.integration.mystcraft.v2.MystcraftAccess;

public class LinkingPanelMetaProvider
implements IItemStackCustomMetaProvider<Item> {
    @Override
    public Class<? extends Item> getTargetClass() {
        return Item.class;
    }

    @Override
    public boolean canApply(Item target, ItemStack stack) {
        PageAPI pageApi = MystcraftAccess.pageApi;
        if (pageApi == null) {
            return false;
        }
        return pageApi.hasLinkPanel(stack);
    }

    @Override
    public String getKey() {
        return "link_panel";
    }

    @Override
    public Object getMeta(Item target, ItemStack stack) {
        if (MystcraftAccess.pageApi == null) {
            return null;
        }
        HashSet result = Sets.newHashSet();
        Collection props = MystcraftAccess.pageApi.getPageLinkProperties(stack);
        if (props != null) {
            result.addAll(props);
        }
        return result;
    }
}

