/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import net.minecraft.tileentity.TileEntitySign;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.helpers.Index;
import org.apache.commons.lang3.StringUtils;

public class AdapterSign
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return TileEntitySign.class;
    }

    @Override
    public String getSourceId() {
        return "vanilla_sign";
    }

    @ScriptCallable(description="Sets the text on the sign")
    public void setLine(TileEntitySign sign, @Arg(name="line", description="The line number to set the text on the sign") Index line, @Arg(name="text", description="The text to display on the sign") String text) {
        line.checkElementIndex("line", sign.field_145915_a.length);
        AdapterSign.setLine(sign, line.value, text);
        AdapterSign.updateSign(sign);
    }

    private static void updateSign(TileEntitySign sign) {
        sign.func_145831_w().func_147471_g(sign.field_145851_c, sign.field_145848_d, sign.field_145849_e);
    }

    private static void setLine(TileEntitySign sign, int index, String text) {
        sign.field_145915_a[index] = text.length() < 15 ? text : text.substring(0, 15);
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.STRING}, description="Gets the text from the supplied line of the sign")
    public String getLine(TileEntitySign sign, @Arg(name="line", description="The line number to get from the sign") Index line) {
        line.checkElementIndex("line", sign.field_145915_a.length);
        return sign.field_145915_a[line.value];
    }

    @ScriptCallable(description="Sets all text from table")
    public void setLines(TileEntitySign sign, @Arg(name="lines") String[] lines) {
        String[] signText = sign.field_145915_a;
        for (int i = 0; i < signText.length; ++i) {
            String line;
            signText[i] = line = i < lines.length ? Strings.nullToEmpty((String)lines[i]) : "";
        }
        AdapterSign.updateSign(sign);
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Gets all text as table")
    public String[] getLines(TileEntitySign sign) {
        return sign.field_145915_a;
    }

    @ScriptCallable(description="Sets the text on the sign")
    public void setText(TileEntitySign sign, @Arg(name="text", description="The text to display on the sign") String text) {
        String[] lines = text.split("\n");
        int newLength = lines.length;
        int maxLength = sign.field_145915_a.length;
        Preconditions.checkArgument((newLength >= 0 && newLength < maxLength ? 1 : 0) != 0, (String)"Value must be in range [1,%s]", (Object[])new Object[]{maxLength});
        for (int i = 0; i < maxLength; ++i) {
            AdapterSign.setLine(sign, i, i < newLength ? lines[i] : "");
        }
        AdapterSign.updateSign(sign);
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.STRING}, description="Gets the text on the sign")
    public String getText(TileEntitySign sign) {
        return StringUtils.join((Object[])sign.field_145915_a, (char)'\n');
    }
}

