/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.tmt.ModelRendererTurbo;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.vector.Vector3f;

public class ModelVehicle
extends ModelDriveable {
    public ModelRendererTurbo[] turretModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] barrelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[][] ammoModel = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[] frontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] backWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftFrontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightFrontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftBackWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightBackWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightTrackWheelModels = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftTrackWheelModels = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyDoorOpenModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyDoorCloseModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] trailerModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] steeringWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] drillHeadModel = new ModelRendererTurbo[0];
    public Vector3f drillHeadOrigin = new Vector3f();

    @Override
    public void render(EntityDriveable driveable, float f1) {
        this.render(0.0625f, (EntityVehicle)driveable, f1);
    }

    @Override
    public void render(DriveableType type) {
        super.render(type);
        this.renderPart(this.leftBackWheelModel);
        this.renderPart(this.rightBackWheelModel);
        this.renderPart(this.leftFrontWheelModel);
        this.renderPart(this.rightFrontWheelModel);
        this.renderPart(this.rightTrackModel);
        this.renderPart(this.leftTrackModel);
        this.renderPart(this.rightTrackWheelModels);
        this.renderPart(this.leftTrackWheelModels);
        this.renderPart(this.bodyDoorCloseModel);
        this.renderPart(this.trailerModel);
        this.renderPart(this.turretModel);
        this.renderPart(this.barrelModel);
        this.renderPart(this.drillHeadModel);
        for (ModelRendererTurbo[] mods : this.ammoModel) {
            this.renderPart(mods);
        }
        this.renderPart(this.steeringWheelModel);
    }

    public void render(float f5, EntityVehicle vehicle, float f) {
        boolean rotateWheels = vehicle.getVehicleType().rotateWheels;
        if (vehicle.isPartIntact(EnumDriveablePart.core)) {
            for (ModelRendererTurbo modelRendererTurbo : this.bodyModel) {
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.bodyDoorOpenModel) {
                if (!vehicle.varDoor) continue;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.bodyDoorCloseModel) {
                if (vehicle.varDoor) continue;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.steeringWheelModel) {
                modelRendererTurbo.field_78795_f = vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backLeftWheel)) {
            for (ModelRendererTurbo modelRendererTurbo : this.leftBackWheelModel) {
                modelRendererTurbo.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backRightWheel)) {
            for (ModelRendererTurbo modelRendererTurbo : this.rightBackWheelModel) {
                modelRendererTurbo.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontLeftWheel)) {
            for (ModelRendererTurbo modelRendererTurbo : this.leftFrontWheelModel) {
                modelRendererTurbo.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                modelRendererTurbo.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontRightWheel)) {
            for (ModelRendererTurbo modelRendererTurbo : this.rightFrontWheelModel) {
                modelRendererTurbo.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                modelRendererTurbo.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontWheel)) {
            for (ModelRendererTurbo modelRendererTurbo : this.frontWheelModel) {
                modelRendererTurbo.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                modelRendererTurbo.field_78796_g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backWheel)) {
            for (ModelRendererTurbo modelRendererTurbo : this.backWheelModel) {
                modelRendererTurbo.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.leftTrack)) {
            for (ModelRendererTurbo modelRendererTurbo : this.leftTrackModel) {
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.leftTrackWheelModels) {
                modelRendererTurbo.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.rightTrack)) {
            for (ModelRendererTurbo modelRendererTurbo : this.rightTrackModel) {
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo modelRendererTurbo : this.rightTrackWheelModels) {
                modelRendererTurbo.field_78808_h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.trailer)) {
            for (ModelRendererTurbo modelRendererTurbo : this.trailerModel) {
                modelRendererTurbo.render(f5, this.oldRotateOrder);
            }
        }
        for (EntitySeat entitySeat : vehicle.seats) {
            if (entitySeat == null || entitySeat.seatInfo == null || entitySeat.seatInfo.gunName == null || this.gunModels.get(entitySeat.seatInfo.gunName) == null || !vehicle.isPartIntact(entitySeat.seatInfo.part) || vehicle.rotateWithTurret(entitySeat.seatInfo)) continue;
            float yaw = entitySeat.prevLooking.getYaw() + (entitySeat.looking.getYaw() - entitySeat.prevLooking.getYaw()) * f;
            float pitch = entitySeat.prevLooking.getPitch() + (entitySeat.looking.getPitch() - entitySeat.prevLooking.getPitch()) * f;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(entitySeat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.field_78796_g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.func_78785_a(f5);
            }
        }
    }

    public void renderTurret(float f, float f1, float f2, float f3, float f4, float f5, EntityVehicle vehicle, float dt) {
        VehicleType type = vehicle.getVehicleType();
        float yaw = vehicle.seats[0].looking.getYaw();
        float pitch = vehicle.seats[0].looking.getPitch();
        for (ModelRendererTurbo aTurretModel : this.turretModel) {
            aTurretModel.render(f5, this.oldRotateOrder);
        }
        for (ModelRendererTurbo aBarrelModel : this.barrelModel) {
            aBarrelModel.field_78808_h = -pitch * (float)Math.PI / 180.0f;
            aBarrelModel.render(f5, this.oldRotateOrder);
        }
        for (int i = 0; i < this.ammoModel.length; ++i) {
            if (i < type.numMissileSlots && vehicle.getDriveableData().missiles[i] == null) continue;
            for (int j = 0; j < this.ammoModel[i].length; ++j) {
                this.ammoModel[i][j].field_78808_h = -pitch * (float)Math.PI / 180.0f;
                this.ammoModel[i][j].render(f5, this.oldRotateOrder);
            }
        }
        for (EntitySeat seat : vehicle.seats) {
            if (seat == null || seat.seatInfo == null || seat.seatInfo.gunName == null || this.gunModels.get(seat.seatInfo.gunName) == null || !vehicle.isPartIntact(seat.seatInfo.part) || !vehicle.rotateWithTurret(seat.seatInfo)) continue;
            EntitySeat driverSeat = vehicle.seats[0];
            float driverYaw = driverSeat.prevLooking.getYaw() + (driverSeat.looking.getYaw() - driverSeat.prevLooking.getYaw()) * dt;
            float yaw2 = seat.prevLooking.getYaw() + (seat.looking.getYaw() - seat.prevLooking.getYaw()) * dt;
            float pitch2 = seat.prevLooking.getPitch() + (seat.looking.getPitch() - seat.prevLooking.getPitch()) * dt;
            float effectiveYaw = yaw2 - driverYaw;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(seat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch2 * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.field_78796_g = -effectiveYaw * (float)Math.PI / 180.0f;
                gunModelPart.field_78808_h = -pitch2 * (float)Math.PI / 180.0f;
                gunModelPart.render(f5, this.oldRotateOrder);
            }
        }
    }

    public void renderDrillBit(EntityVehicle vehicle, float f) {
        if (vehicle.isPartIntact(EnumDriveablePart.harvester)) {
            for (ModelRendererTurbo adrillHeadModel : this.drillHeadModel) {
                adrillHeadModel.render(0.0625f, this.oldRotateOrder);
            }
        }
    }

    @Override
    public void flipAll() {
        super.flipAll();
        this.flip(this.bodyDoorOpenModel);
        this.flip(this.bodyDoorCloseModel);
        this.flip(this.turretModel);
        this.flip(this.barrelModel);
        this.flip(this.leftFrontWheelModel);
        this.flip(this.rightFrontWheelModel);
        this.flip(this.leftBackWheelModel);
        this.flip(this.rightBackWheelModel);
        this.flip(this.rightTrackModel);
        this.flip(this.leftTrackModel);
        this.flip(this.rightTrackWheelModels);
        this.flip(this.leftTrackWheelModels);
        this.flip(this.trailerModel);
        this.flip(this.steeringWheelModel);
        this.flip(this.frontWheelModel);
        this.flip(this.backWheelModel);
        this.flip(this.drillHeadModel);
    }

    @Override
    public void translateAll(float x, float y, float z) {
        super.translateAll(x, y, z);
        this.translate(this.bodyDoorOpenModel, x, y, z);
        this.translate(this.bodyDoorCloseModel, x, y, z);
        this.translate(this.turretModel, x, y, z);
        this.translate(this.barrelModel, x, y, z);
        this.translate(this.leftFrontWheelModel, x, y, z);
        this.translate(this.rightFrontWheelModel, x, y, z);
        this.translate(this.leftBackWheelModel, x, y, z);
        this.translate(this.rightBackWheelModel, x, y, z);
        this.translate(this.rightTrackModel, x, y, z);
        this.translate(this.leftTrackModel, x, y, z);
        this.translate(this.rightTrackWheelModels, x, y, z);
        this.translate(this.leftTrackWheelModels, x, y, z);
        this.translate(this.trailerModel, x, y, z);
        this.translate(this.steeringWheelModel, x, y, z);
        this.translate(this.frontWheelModel, x, y, z);
        this.translate(this.backWheelModel, x, y, z);
        this.translate(this.drillHeadModel, x, y, z);
    }
}

