/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.ItemOpStick;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityFlagpole
extends Entity
implements ITeamBase {
    public int defaultTeamID;
    public int currentTeamID;
    public TeamsMap map;
    public List<ITeamObject> objects = new ArrayList<ITeamObject>();
    public String name = "Default Name";
    private int ID;
    private EntityFlag flag;
    public static TeamsManager teamsManager = TeamsManager.getInstance();
    private boolean uninitialized = true;
    private int loadDistance = 1;

    public EntityFlagpole(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
        this.field_70155_l = 100.0;
    }

    public EntityFlagpole(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.flag = new EntityFlag(this.field_70170_p, this);
        this.objects.add(this.flag);
        this.field_70170_p.func_72838_d((Entity)this.flag);
        if (EntityFlagpole.teamsManager.maps.size() > 0) {
            this.map = EntityFlagpole.teamsManager.maps.values().iterator().next();
        }
    }

    public EntityFlagpole(World world, int x, int y, int z) {
        this(world, (double)x + 0.5, (double)y, (double)z + 0.5);
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tags) {
        this.setBaseID(tags.func_74762_e("ID"));
        this.currentTeamID = this.defaultTeamID = tags.func_74762_e("TeamID");
        this.map = EntityFlagpole.teamsManager.maps.get(tags.func_74779_i("Map"));
        this.name = tags.func_74779_i("Name");
        this.setMap(this.map);
    }

    protected void func_70014_b(NBTTagCompound tags) {
        tags.func_74768_a("TeamID", this.defaultTeamID);
        tags.func_74778_a("Map", this.map == null ? "" : this.map.shortName);
        tags.func_74768_a("ID", this.getBaseID());
        tags.func_74778_a("Name", this.name);
    }

    @Override
    public TeamsMap getMap() {
        return this.map;
    }

    @Override
    public void setMap(TeamsMap newMap) {
        if (newMap == null) {
            FlansMod.log("Flagpole given invalid map");
            return;
        }
        if (this.map != null && this.map != newMap) {
            this.map.removeBase(this);
        }
        this.map = newMap;
        newMap.addBase(this);
    }

    @Override
    public void setMapFirstTime(TeamsMap newMap) {
        if (newMap == null) {
            FlansMod.log("Flagpole given invalid map");
            return;
        }
        if (this.map != null && this.map != newMap) {
            this.map.removeBase(this);
        }
        this.map = newMap;
        newMap.addBaseFirstTime(this);
    }

    @Override
    public List<ITeamObject> getObjects() {
        return this.objects;
    }

    @Override
    public void tick() {
    }

    @Override
    public void startRound() {
        this.currentTeamID = this.defaultTeamID;
    }

    @Override
    public void addObject(ITeamObject object) {
        this.objects.add(object);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public void destroy() {
        this.func_70106_y();
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    @Override
    public double getPosX() {
        return this.field_70165_t;
    }

    @Override
    public double getPosY() {
        return this.field_70163_u;
    }

    @Override
    public double getPosZ() {
        return this.field_70161_v;
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public void roundCleanup() {
        if (this.flag != null) {
            this.flag.reset();
        }
    }

    @Override
    public ITeamObject getFlag() {
        return this.flag;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.flag == null) {
                this.flag = new EntityFlag(this.field_70170_p, this);
                this.objects.add(this.flag);
            }
            if (!this.flag.field_70175_ag) {
                this.field_70170_p.func_72838_d((Entity)this.flag);
            }
            if (this.flag.isHome) {
                this.flag.func_70107_b(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public boolean func_130002_c(EntityPlayer player) {
        PlayerData data = PlayerHandler.getPlayerData(player);
        if (!(this.field_70170_p.field_72995_K || data.team != null || !TeamsManager.getInstance().playerIsOp(player) || player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemOpStick)) {
            ItemOpStick.openBaseEditGUI(this, (EntityPlayerMP)player);
        }
        return false;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack stack = new ItemStack((Item)FlansMod.flag, 1, 0);
        return stack;
    }

    @Override
    public void setBaseID(int i) {
        this.ID = i;
    }

    @Override
    public int getBaseID() {
        return this.ID;
    }

    @Override
    public int getDefaultOwnerID() {
        return this.defaultTeamID;
    }

    @Override
    public void setDefaultOwnerID(int id) {
        this.currentTeamID = this.defaultTeamID = id;
        for (ITeamObject object : this.objects) {
            object.onBaseSet(id);
        }
    }

    @Override
    public int getOwnerID() {
        return this.currentTeamID;
    }

    @Override
    public void setOwnerID(int id) {
        this.currentTeamID = id;
    }

    public boolean func_70027_ad() {
        return false;
    }
}

