/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class GametypeTDM
extends Gametype {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;
    public int autoBalanceInterval = 1200;

    public GametypeTDM() {
        super("Team Deathmatch", "TDM", 2);
    }

    @Override
    public void roundStart() {
    }

    @Override
    public void roundEnd() {
    }

    @Override
    public void roundCleanup() {
    }

    @Override
    public void tick() {
    }

    public boolean needAutobalance() {
        return false;
    }

    public void autobalance() {
    }

    @Override
    public void playerJoined(EntityPlayerMP player) {
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeTDM.getPlayerData(player) == null || GametypeTDM.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        EntityPlayerMP attacker = GametypeTDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeTDM.getPlayerData(attacker) == null || GametypeTDM.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeTDM.getPlayerData((EntityPlayerMP)player).team == GametypeTDM.getPlayerData((EntityPlayerMP)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GametypeTDM.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public boolean playerCanAttack(EntityPlayerMP attacker, Team attackerTeam, EntityPlayerMP victim, Team victimTeam) {
        return attackerTeam != victimTeam || this.friendlyFire;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GametypeTDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeTDM.getPlayerData((EntityPlayerMP)player).score;
            } else if (GametypeTDM.getPlayerData((EntityPlayerMP)attacker).team == GametypeTDM.getPlayerData((EntityPlayerMP)player).team) {
                --GametypeTDM.getPlayerData((EntityPlayerMP)attacker).score;
            } else {
                GametypeTDM.givePoints(attacker, 1);
                ++GametypeTDM.getPlayerData((EntityPlayerMP)attacker).kills;
            }
        } else {
            --GametypeTDM.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GametypeTDM.getPlayerData((EntityPlayerMP)player).deaths;
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        if (GametypeTDM.teamsManager.currentRound == null) {
            return null;
        }
        PlayerData data = GametypeTDM.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.newTeam == null) {
            return null;
        }
        ArrayList<ITeamBase> bases = GametypeTDM.teamsManager.currentRound.map.getBasesPerTeam(GametypeTDM.teamsManager.currentRound.getTeamID(data.newTeam));
        for (ITeamBase base : bases) {
            if (base.getMap() != GametypeTDM.teamsManager.currentRound.map) continue;
            for (int i = 0; i < base.getObjects().size(); ++i) {
                if (!base.getObjects().get(i).isSpawnPoint()) continue;
                validSpawnPoints.add(base.getObjects().get(i));
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return Vec3.func_72443_a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("TDMScoreLimit");
        this.friendlyFire = tags.func_74767_n("TDMFriendlyFire");
        this.autoBalance = tags.func_74767_n("TDMAutoBalance");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("TDMScoreLimit", this.scoreLimit);
        tags.func_74757_a("TDMFriendlyFire", this.friendlyFire);
        tags.func_74757_a("TDMAutoBalance", this.autoBalance);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }

    @Override
    public boolean teamHasWon(Team team) {
        return GametypeTDM.teamsManager.currentRound != null && team.score == GametypeTDM.teamsManager.currentRound.scoreLimit;
    }
}

