/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.blocks;

import cofh.api.block.IDismantleable;
import com.vanhal.progressiveautomation.ProgressiveAutomation;
import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.items.ItemBlockMachine;
import com.vanhal.progressiveautomation.upgrades.UpgradeRegistry;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseBlock
extends BlockContainer
implements IDismantleable {
    public String name;
    public String machineType;
    public int GUIid = -1;
    protected int rangeCount = -1;
    protected int blockLevel = 0;
    protected IIcon[] blockIcons = new IIcon[6];
    protected IIcon blankSide;

    public static String returnLevelName(int level) {
        if (level == 1) {
            return "Stone";
        }
        if (level == 2) {
            return "Iron";
        }
        if (level == 3) {
            return "Diamond";
        }
        return "";
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.blockLevel == 0) {
            return 5;
        }
        return 0;
    }

    public BaseBlock(String machineType, int level) {
        super(Material.field_151573_f);
        this.machineType = machineType;
        this.name = machineType + BaseBlock.returnLevelName(level);
        this.func_149663_c(this.name);
        this.func_149711_c(1.0f);
        this.func_149647_a(ProgressiveAutomation.PATab);
        this.blockLevel = level;
        this.GUIid = ProgressiveAutomation.proxy.registerGui(machineType);
    }

    public String getLevelName() {
        String thisName = BaseBlock.returnLevelName(this.blockLevel);
        if (thisName == "") {
            thisName = "Wooden";
        }
        return thisName;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && this.GUIid >= 0 && !(player instanceof FakePlayer)) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ProgressiveAutomation.instance, (int)this.GUIid, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (this.rangeCount >= 0 && side >= 2 && side <= 5 && world.func_147438_o(x, y, z) instanceof UpgradeableTileEntity) {
            UpgradeableTileEntity tileEntity = (UpgradeableTileEntity)world.func_147438_o(x, y, z);
            int range = tileEntity.getRange() + this.rangeCount;
            ForgeDirection dir = tileEntity.facing;
            if (side == dir.ordinal() && range < 2) {
                return this.blankSide;
            }
            if (side == (dir = this.nextFace(dir)).ordinal() && range < 4) {
                return this.blankSide;
            }
            if (side == (dir = this.nextFace(dir)).ordinal() && range < 6) {
                return this.blankSide;
            }
            if (side == (dir = this.nextFace(dir)).ordinal() && range < 8) {
                return this.blankSide;
            }
        }
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String iconPrefix = "progressiveautomation:" + this.machineType.toLowerCase() + "/" + this.getLevelName();
        this.blockIcons[0] = register.func_94245_a(iconPrefix + "_Bottom");
        this.blockIcons[1] = register.func_94245_a(iconPrefix + "_Top");
        this.blockIcons[2] = register.func_94245_a(iconPrefix + "_Side");
        this.blockIcons[3] = register.func_94245_a(iconPrefix + "_Side");
        this.blockIcons[4] = register.func_94245_a(iconPrefix + "_Side");
        this.blockIcons[5] = register.func_94245_a(iconPrefix + "_Side");
        this.blankSide = register.func_94245_a("progressiveautomation:" + this.getLevelName() + "_Side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.blockIcons[side];
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        BaseTileEntity tileEntity = (BaseTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            ArrayList<ItemStack> items = this.getInsides(world, x, y, z);
            for (ItemStack item : items) {
                this.dumpItems(world, x, y, z, item);
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
    }

    public void dumpItems(World world, int x, int y, int z, ItemStack items) {
        EntityItem entItem = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), items);
        float f3 = 0.05f;
        entItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
        entItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
        entItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
        world.func_72838_d((Entity)entItem);
    }

    public void addRecipe(Block previousTier) {
    }

    public void preInit(Block previousTier) {
        GameRegistry.registerBlock((Block)this, ItemBlockMachine.class, (String)this.name);
        this.addRecipe(previousTier);
    }

    public void init() {
    }

    public void postInit() {
    }

    protected ArrayList<ItemStack> getInsides(World world, int x, int y, int z) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        BaseTileEntity tileEntity = (BaseTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            for (int i = 0; i < tileEntity.func_70302_i_(); ++i) {
                ItemStack itemstack = tileEntity.func_70301_a(i);
                if (itemstack == null) continue;
                items.add(itemstack);
            }
            if (tileEntity instanceof UpgradeableTileEntity) {
                UpgradeableTileEntity tileMachine = (UpgradeableTileEntity)tileEntity;
                for (UpgradeType upgradeType : tileMachine.getInstalledUpgradeTypes()) {
                    int stackSize;
                    for (int amount = tileMachine.getUpgradeAmount(upgradeType).intValue(); amount > 0; amount -= stackSize) {
                        ItemStack upgradeItemStack = new ItemStack((Item)UpgradeRegistry.getUpgradeItem(upgradeType));
                        upgradeItemStack.field_77994_a = stackSize = amount > 64 ? 64 : amount;
                        items.add(upgradeItemStack);
                    }
                }
            }
        }
        return items;
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        Block targetBlock = world.func_147439_a(x, y, z);
        ItemStack block = new ItemStack(targetBlock);
        if (world.func_147438_o(x, y, z) instanceof BaseTileEntity) {
            BaseTileEntity tileEntity = (BaseTileEntity)world.func_147438_o(x, y, z);
            tileEntity.writeToItemStack(block);
        }
        if (!returnDrops) {
            this.dumpItems(world, x, y, z, block);
            world.func_147475_p(x, y, z);
            world.func_147468_f(x, y, z);
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(block);
        return items;
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        BaseTileEntity tileEntity = (BaseTileEntity)worldObj.func_147438_o(x, y, z);
        if (tileEntity.facing == ForgeDirection.NORTH) {
            tileEntity.facing = ForgeDirection.EAST;
        } else if (tileEntity.facing == ForgeDirection.EAST) {
            tileEntity.facing = ForgeDirection.SOUTH;
        } else if (tileEntity.facing == ForgeDirection.SOUTH) {
            tileEntity.facing = ForgeDirection.WEST;
        } else if (tileEntity.facing == ForgeDirection.WEST) {
            tileEntity.facing = ForgeDirection.NORTH;
        }
        worldObj.func_147471_g(x, y, z);
        return true;
    }

    protected ForgeDirection nextFace(ForgeDirection dir) {
        if (dir == ForgeDirection.NORTH) {
            return ForgeDirection.EAST;
        }
        if (dir == ForgeDirection.EAST) {
            return ForgeDirection.SOUTH;
        }
        if (dir == ForgeDirection.SOUTH) {
            return ForgeDirection.WEST;
        }
        if (dir == ForgeDirection.WEST) {
            return ForgeDirection.NORTH;
        }
        return dir;
    }
}

