/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.blocks;

import com.vanhal.progressiveautomation.blocks.BaseBlock;
import com.vanhal.progressiveautomation.entities.generator.TileGenerator;
import com.vanhal.progressiveautomation.entities.generator.TileGeneratorDiamond;
import com.vanhal.progressiveautomation.entities.generator.TileGeneratorIron;
import com.vanhal.progressiveautomation.entities.generator.TileGeneratorStone;
import com.vanhal.progressiveautomation.items.PAItems;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockGenerator
extends BaseBlock {
    public IIcon iconTop;
    public IIcon iconSide;
    public IIcon inactiveGenerator;
    public IIcon activeGenerator;
    public static final Block firstTier = Blocks.field_150451_bX;

    public BlockGenerator(int level) {
        super("Generator", level);
    }

    @Override
    public TileEntity func_149915_a(World world, int var2) {
        if (this.blockLevel >= 3) {
            return new TileGeneratorDiamond();
        }
        if (this.blockLevel == 2) {
            return new TileGeneratorIron();
        }
        if (this.blockLevel == 1) {
            return new TileGeneratorStone();
        }
        return new TileGenerator();
    }

    @Override
    public void addRecipe(Block previousTier) {
        ShapedOreRecipe recipe = null;
        recipe = this.blockLevel == 1 ? new ShapedOreRecipe(new ItemStack((Block)this), new Object[]{"ses", "scs", "sss", Character.valueOf('s'), Blocks.field_150348_b, Character.valueOf('c'), previousTier, Character.valueOf('e'), PAItems.rfEngine}) : (this.blockLevel == 2 ? new ShapedOreRecipe(new ItemStack((Block)this), new Object[]{"ses", "scs", "sbs", Character.valueOf('s'), Items.field_151042_j, Character.valueOf('c'), previousTier, Character.valueOf('b'), Blocks.field_150339_S, Character.valueOf('e'), PAItems.rfEngine}) : (this.blockLevel >= 3 ? new ShapedOreRecipe(new ItemStack((Block)this), new Object[]{"ses", "scs", "sss", Character.valueOf('s'), Items.field_151045_i, Character.valueOf('c'), previousTier, Character.valueOf('e'), PAItems.rfEngine}) : new ShapedOreRecipe(new ItemStack((Block)this), new Object[]{"sps", "ses", "srs", Character.valueOf('s'), "logWood", Character.valueOf('r'), Blocks.field_150460_al, Character.valueOf('p'), previousTier, Character.valueOf('e'), PAItems.rfEngine})));
        GameRegistry.addRecipe((IRecipe)recipe);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String iconPrefix = "progressiveautomation:" + this.machineType.toLowerCase() + "/" + this.getLevelName();
        this.iconTop = register.func_94245_a(iconPrefix + "_Top");
        this.iconSide = register.func_94245_a(iconPrefix + "_Side");
        this.inactiveGenerator = register.func_94245_a(iconPrefix + "_Front");
        this.activeGenerator = register.func_94245_a(iconPrefix + "_FrontActive");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata == 0) {
            metadata = 3;
        }
        return side == 1 ? this.iconTop : (side == 0 ? this.iconTop : (side != metadata ? this.iconSide : this.inactiveGenerator));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        int metadata = block.func_72805_g(x, y, z);
        TileGenerator entity = (TileGenerator)block.func_147438_o(x, y, z);
        if (side == metadata && entity.isBurning()) {
            return this.activeGenerator;
        }
        return this.func_149691_a(side, metadata);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (l == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (l == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (l == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
        if (itemStack.func_82837_s()) {
            ((TileEntityFurnace)world.func_147438_o(x, y, z)).func_145951_a(itemStack.func_82833_r());
        }
    }

    @Override
    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int metadata = worldObj.func_72805_g(x, y, z) + 1;
        if (metadata > 5) {
            metadata = 2;
        }
        worldObj.func_72921_c(x, y, z, metadata, 2);
        return true;
    }
}

