/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.compat.mods;

import com.vanhal.progressiveautomation.compat.BaseMod;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class Pneumaticcraft
extends BaseMod {
    public Pneumaticcraft() {
        this.modID = "PneumaticCraft";
    }

    @Override
    public boolean isPlantible(ItemStack item) {
        return item.func_77977_a().startsWith("item.plasticPlant");
    }

    @Override
    public boolean isPlant(Block plantBlock, int metadata) {
        return plantBlock.getClass().getName().startsWith("pneumaticCraft.common.block.pneumaticPlants");
    }

    @Override
    public boolean isGrown(Point3I plantPoint, Block plantBlock, int metadata, World worldObj) {
        return plantBlock.getDrops(worldObj, plantPoint.getX(), plantPoint.getY(), plantPoint.getZ(), metadata, 0).size() >= 2;
    }

    @Override
    public boolean validBlock(World worldObj, ItemStack itemStack, Point3I testPoint) {
        Point3I point = new Point3I(testPoint);
        if (!this.isPlantible(itemStack)) {
            return false;
        }
        int seedMeta = itemStack.func_77960_j();
        if (!worldObj.func_147437_c(point.getX(), point.getY(), point.getZ())) {
            return false;
        }
        if (seedMeta == 11) {
            point.setY(point.getY() + 1);
        } else {
            point.setY(point.getY() - 1);
        }
        Block testBlock = worldObj.func_147439_a(point.getX(), point.getY(), point.getZ());
        return seedMeta == 0 ? testBlock == Blocks.field_150355_j : (seedMeta == 5 ? testBlock == Blocks.field_150377_bs : (seedMeta == 1 || seedMeta == 11 ? testBlock == Blocks.field_150424_aL : testBlock == Blocks.field_150346_d || testBlock == Blocks.field_150349_c || testBlock == Blocks.field_150458_ak));
    }

    @Override
    public boolean placeSeed(World worldObj, ItemStack itemStack, Point3I point, boolean doAction) {
        if (Pneumaticcraft.checkClear(worldObj, point)) {
            if (doAction) {
                int seedMeta = itemStack.func_77960_j();
                ItemStack items = new ItemStack(itemStack.func_77973_b(), 1, seedMeta);
                EntityItem entItem = new EntityItem(worldObj, (double)((float)point.getX() + 0.5f), (double)((float)point.getY() + 0.5f), (double)((float)point.getZ() + 0.5f), items);
                entItem.field_70159_w = 0.0;
                entItem.field_70181_x = 0.0;
                entItem.field_70179_y = 0.0;
                entItem.field_145804_b = 20;
                entItem.field_70290_d = 0.0f;
                entItem.field_70129_M = 0.0f;
                if (items.func_77942_o()) {
                    entItem.func_92059_d().func_77982_d((NBTTagCompound)items.func_77978_p().func_74737_b());
                }
                worldObj.func_72838_d((Entity)entItem);
            }
            return true;
        }
        return false;
    }

    private static boolean checkClear(World world, Point3I point) {
        AxisAlignedBB block = AxisAlignedBB.func_72330_a((double)point.getX(), (double)(point.getY() - 1), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 1), (double)(point.getZ() + 1));
        List entities = world.func_72872_a(EntityItem.class, block);
        return entities.isEmpty();
    }
}

