/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.chopper;

import com.vanhal.progressiveautomation.PAConfig;
import com.vanhal.progressiveautomation.compat.ModHelper;
import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.ref.ToolHelper;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.CoordList;
import com.vanhal.progressiveautomation.util.Point2I;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.oredict.OreDictionary;

public class TileChopper
extends UpgradeableTileEntity {
    protected final int CUTTING_EXTRA_RANGE = 6;
    private boolean forceRecalculate;
    protected int maxCuttingX;
    protected int minCuttingX;
    protected int maxCuttingZ;
    protected int minCuttingZ;
    protected int searchBlock = -1;
    protected boolean plantSapling;
    protected boolean chopping;
    protected CoordList blockList = new CoordList();
    protected Point3I currentBlock = null;
    protected int choppingTime = 0;
    public int SLOT_SAPLINGS = 1;
    public int SLOT_SHEARS = 4;
    protected boolean removeShears = false;
    protected int lastAxe = -1;
    private int previousUpgrades;

    public TileChopper() {
        super(13);
        this.setUpgradeLevel(0);
        this.setAllowedUpgrades(UpgradeType.WOODEN, UpgradeType.WITHER);
        this.allowSheer();
        this.forceRecalculate = true;
        this.SLOT_AXE = 2;
        this.SLOT_UPGRADE = 3;
    }

    protected void allowSheer() {
        if (PAConfig.shearTrees && PAConfig.allowShearingUpgrade) {
            if (!this.isAllowedUpgrade(UpgradeType.SHEARING)) {
                this.addAllowedUpgrade(UpgradeType.SHEARING);
            }
        } else {
            this.removeShears = true;
        }
    }

    @Override
    public void writeNonSyncableNBT(NBTTagCompound nbt) {
        super.writeNonSyncableNBT(nbt);
        if (this.currentBlock != null) {
            nbt.func_74782_a("CurrentBlock", (NBTBase)this.currentBlock.getNBT());
        } else if (nbt.func_74764_b("CurrentBlock")) {
            nbt.func_82580_o("CurrentBlock");
        }
        nbt.func_74782_a("BlockList", (NBTBase)this.blockList.saveToNBT());
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("choppingTime", this.choppingTime);
    }

    @Override
    public void writeSyncOnlyNBT(NBTTagCompound nbt) {
        super.writeSyncOnlyNBT(nbt);
        nbt.func_74757_a("chopping", this.chopping);
        nbt.func_74757_a("planting", this.plantSapling);
    }

    @Override
    public void readNonSyncableNBT(NBTTagCompound nbt) {
        super.readNonSyncableNBT(nbt);
        if (nbt.func_74764_b("CurrentBlock")) {
            this.currentBlock = new Point3I();
            this.currentBlock.setNBT((NBTTagCompound)nbt.func_74781_a("CurrentBlock"));
        } else {
            this.currentBlock = null;
        }
        NBTTagList contents = nbt.func_150295_c("BlockList", 10);
        this.blockList.loadFromNBT(contents);
        this.forceRecalculate = true;
        if (this.blockList.size() > 0) {
            this.chopping = true;
        }
        if (this.removeShears) {
            if (this.slots[this.SLOT_SHEARS] != null) {
                this.slots[this.SLOT_SHEARS] = null;
            }
            if (this.hasUpgrade(UpgradeType.SHEARING)) {
                this.removeUpgradeCompletely(UpgradeType.SHEARING);
            }
            this.removeShears = false;
        }
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        this.choppingTime = nbt.func_74762_e("choppingTime");
    }

    @Override
    public void readSyncOnlyNBT(NBTTagCompound nbt) {
        super.readSyncOnlyNBT(nbt);
        if (nbt.func_74764_b("chopping")) {
            this.chopping = nbt.func_74767_n("chopping");
        }
        if (nbt.func_74764_b("planting")) {
            this.plantSapling = nbt.func_74767_n("planting");
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.checkForChanges();
            this.checkInventory();
            if (this.isBurning()) {
                if (this.chopping && this.blockList.size() == 0) {
                    this.chopping = false;
                    this.addPartialUpdate("chopping", false);
                }
                if (this.blockList.size() > 0) {
                    this.cutTree();
                } else if (this.plantSapling) {
                    this.plantSaplings(this.searchBlock, true);
                    this.plantSapling = false;
                    this.addPartialUpdate("planting", false);
                }
                this.scanBlocks();
            }
        }
    }

    protected boolean scanBlocks() {
        int i;
        for (i = 0; i < this.getRange(); ++i) {
            this.findTree(i);
        }
        if (this.blockList.size() > 0) {
            return true;
        }
        for (i = 0; i < this.getRange(); ++i) {
            if (!this.plantSaplings(i, false)) continue;
            this.searchBlock = i;
            this.plantSapling = true;
            this.addPartialUpdate("planting", true);
            return true;
        }
        return false;
    }

    protected void cutTree() {
        if (this.slots[this.SLOT_AXE] == null) {
            return;
        }
        if (this.currentBlock != null) {
            if (this.choppingTime <= 0) {
                this.choppingTime = 0;
                if (this.validBlock(this.currentBlock)) {
                    boolean targetTree = this.isTree(this.currentBlock);
                    int fortuneLevel = 0;
                    if (targetTree) {
                        fortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.slots[this.SLOT_AXE]);
                    }
                    Block actualBlock = this.field_145850_b.func_147439_a(this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ());
                    int metaData = this.field_145850_b.func_72805_g(this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ());
                    ArrayList items = new ArrayList();
                    if (!targetTree && this.slots[this.SLOT_SHEARS] != null && this.hasUpgrade(UpgradeType.SHEARING)) {
                        items.add(new ItemStack(Item.func_150898_a((Block)actualBlock), 1, metaData));
                        if (ToolHelper.damageTool(this.slots[this.SLOT_SHEARS], this.field_145850_b, this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ())) {
                            this.destroyTool(this.SLOT_SHEARS);
                        }
                    } else {
                        items = actualBlock.getDrops(this.field_145850_b, this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ(), metaData, fortuneLevel);
                    }
                    for (ItemStack item : items) {
                        this.addToInventory(item);
                    }
                    if (targetTree && ToolHelper.damageTool(this.slots[this.SLOT_AXE], this.field_145850_b, this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ())) {
                        this.destroyTool(this.SLOT_AXE);
                    }
                    this.field_145850_b.func_147475_p(this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ());
                    this.field_145850_b.func_147468_f(this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ());
                }
                this.currentBlock = null;
            } else {
                --this.choppingTime;
            }
        } else if (this.blockList.size() > 0) {
            this.currentBlock = this.blockList.pop();
            if (this.validBlock(this.currentBlock)) {
                Block actualBlock = this.field_145850_b.func_147439_a(this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ());
                this.choppingTime = (int)Math.ceil((double)actualBlock.func_149712_f(this.field_145850_b, this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ()) * 1.5 * 20.0);
                Item tool = this.slots[this.SLOT_AXE].func_77973_b();
                float choppingSpeed = 1.0f;
                if (this.isTree(this.currentBlock)) {
                    choppingSpeed = tool.getDigSpeed(this.slots[this.SLOT_AXE], actualBlock, this.field_145850_b.func_72805_g(this.currentBlock.getX(), this.currentBlock.getY(), this.currentBlock.getZ()));
                    int eff = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)this.slots[this.SLOT_AXE]);
                    if (eff > 0) {
                        for (int i = 0; i < eff; ++i) {
                            choppingSpeed *= 1.3f;
                        }
                    }
                } else {
                    choppingSpeed = ToolHelper.getSpeed(this.getUpgradeLevel() - 1);
                }
                this.choppingTime = (int)Math.ceil((float)this.choppingTime / choppingSpeed);
            }
        }
    }

    protected void findTree(int n) {
        Point2I p1 = this.spiral(n + 2, this.field_145851_c, this.field_145849_e);
        Point3I point = new Point3I(p1.getX(), this.field_145848_d, p1.getY());
        if (!this.blockList.inList(point) && this.validBlock(point)) {
            this.blockList.push(point);
            if (!this.chopping) {
                this.chopping = true;
                this.addPartialUpdate("chopping", true);
            }
            point.stepUp();
            this.searchTree(point);
        }
    }

    protected void searchTree(Point3I point) {
        if (this.validBlock(point)) {
            this.blockList.push(point);
            for (int i = 0; i < 8; ++i) {
                Point3I newPoint = new Point3I(point);
                Point2I spiralPoint = this.spiral(2 + i, newPoint.getX(), newPoint.getZ());
                newPoint.setX(spiralPoint.getX());
                newPoint.setZ(spiralPoint.getY());
                if (!this.isWithinCuttingRange(spiralPoint.getX(), spiralPoint.getY()) || this.blockList.inList(newPoint)) continue;
                this.searchTree(newPoint);
            }
            Point3I origPoint = new Point3I(point);
            origPoint.stepUp();
            this.searchTree(origPoint);
        }
    }

    protected boolean validBlock(Point3I point) {
        return this.validBlock(point.getX(), point.getY(), point.getZ());
    }

    protected boolean validBlock(int x, int y, int z) {
        if (this.field_145850_b.func_72899_e(x, y, z) && !this.field_145850_b.func_147437_c(x, y, z)) {
            String type = this.testBlock(x, y, z);
            if (this.isTree(type)) {
                return true;
            }
            return this.isLeaf(type);
        }
        return false;
    }

    protected boolean isTree(Point3I point) {
        return this.isTree(point.getX(), point.getY(), point.getZ());
    }

    protected boolean isTree(int x, int y, int z) {
        return this.isTree(this.testBlock(x, y, z));
    }

    protected boolean isTree(String type) {
        return type.equalsIgnoreCase("logWood") || type.equalsIgnoreCase("woodRubber");
    }

    protected boolean isLeaf(Point3I point) {
        return this.isLeaf(point.getX(), point.getY(), point.getZ());
    }

    protected boolean isLeaf(int x, int y, int z) {
        return this.isLeaf(this.testBlock(x, y, z));
    }

    protected boolean isLeaf(String type) {
        return type.equalsIgnoreCase("treeLeaves") || type.equalsIgnoreCase("leavesRubber");
    }

    protected String testBlock(int x, int y, int z) {
        Block _block = this.field_145850_b.func_147439_a(x, y, z);
        int metaData = this.field_145850_b.func_72805_g(x, y, z);
        ItemStack testItem = new ItemStack(Item.func_150898_a((Block)_block), 1, metaData);
        int ordID = OreDictionary.getOreID((ItemStack)testItem);
        if (ordID >= 0) {
            return OreDictionary.getOreName((int)ordID);
        }
        if (ModHelper.isLeaf(testItem)) {
            return "treeLeaves";
        }
        if (ModHelper.isLog(testItem)) {
            return "logWood";
        }
        return "Unknown";
    }

    protected boolean testOre(int OreID, int x, int y, int z) {
        Block _block = this.field_145850_b.func_147439_a(x, y, z);
        int metaData = this.field_145850_b.func_72805_g(x, y, z);
        ItemStack testItem = new ItemStack(Item.func_150898_a((Block)_block), 1, metaData);
        int[] ordIDs = OreDictionary.getOreIDs((ItemStack)testItem);
        return false;
    }

    @Override
    public boolean readyToBurn() {
        return this.slots[this.SLOT_AXE] != null && this.scanBlocks() && (this.plantSapling && this.slots[this.SLOT_SAPLINGS] != null || this.blockList.size() > 0);
    }

    protected boolean plantSaplings(int n, boolean doAction) {
        if (this.slots[this.SLOT_SAPLINGS] != null && this.slots[this.SLOT_SAPLINGS].field_77994_a > 0) {
            Block tree;
            Point2I p1 = this.spiral(n + 2, this.field_145851_c, this.field_145849_e);
            if (Block.func_149634_a((Item)this.slots[this.SLOT_SAPLINGS].func_77973_b()) instanceof IPlantable && (tree = Block.func_149634_a((Item)this.slots[this.SLOT_SAPLINGS].func_77973_b())).func_149742_c(this.field_145850_b, p1.getX(), this.field_145848_d, p1.getY()) && tree.func_149718_j(this.field_145850_b, p1.getX(), this.field_145848_d, p1.getY()) && this.field_145850_b.func_147439_a(p1.getX(), this.field_145848_d, p1.getY()).isReplaceable((IBlockAccess)this.field_145850_b, p1.getX(), this.field_145848_d, p1.getY())) {
                if (doAction) {
                    this.field_145850_b.func_147465_d(p1.getX(), this.field_145848_d, p1.getY(), tree, this.slots[this.SLOT_SAPLINGS].func_77973_b().getDamage(this.slots[this.SLOT_SAPLINGS]), 7);
                    --this.slots[this.SLOT_SAPLINGS].field_77994_a;
                    if (this.slots[this.SLOT_SAPLINGS].field_77994_a == 0) {
                        this.slots[this.SLOT_SAPLINGS] = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isPlanting() {
        return this.plantSapling;
    }

    public boolean isChopping() {
        return this.chopping;
    }

    public void checkForChanges() {
        boolean update = false;
        if (this.slots[this.SLOT_AXE] == null && this.lastAxe >= 0) {
            this.lastAxe = -1;
            update = true;
        } else if (this.slots[this.SLOT_AXE] != null && ToolHelper.getLevel(this.slots[this.SLOT_AXE]) != this.lastAxe) {
            this.lastAxe = ToolHelper.getLevel(this.slots[this.SLOT_AXE]);
            update = true;
        }
        if (this.forceRecalculate || this.previousUpgrades != this.getUpgrades()) {
            this.forceRecalculate = false;
            this.previousUpgrades = this.getUpgrades();
            this.recalculateChoppingRange();
            update = true;
        }
        if (update) {
            this.scanBlocks();
        }
    }

    @Override
    public int extraSlotCheck(ItemStack item) {
        if (TileChopper.checkSapling(item)) {
            return this.SLOT_SAPLINGS;
        }
        return super.extraSlotCheck(item);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == this.SLOT_SHEARS && stack.func_77973_b() == Items.field_151097_aZ && this.hasUpgrade(UpgradeType.SHEARING)) {
            return true;
        }
        if (slot == this.SLOT_SAPLINGS && TileChopper.checkSapling(stack)) {
            return true;
        }
        return super.func_94041_b(slot, stack);
    }

    public static boolean checkSapling(ItemStack stack) {
        return ModHelper.checkSapling(stack);
    }

    private void recalculateChoppingRange() {
        int cuttingSideSize = 6 + (int)Math.ceil((Math.sqrt(this.getUpgrades() + 1) - 1.0) / 2.0);
        this.maxCuttingX = this.field_145851_c + cuttingSideSize;
        this.minCuttingX = this.field_145851_c - cuttingSideSize;
        this.maxCuttingZ = this.field_145849_e + cuttingSideSize;
        this.minCuttingZ = this.field_145849_e - cuttingSideSize;
    }

    private boolean isWithinCuttingRange(int x, int z) {
        return x >= this.minCuttingX && x <= this.maxCuttingX && z >= this.minCuttingZ && z <= this.maxCuttingZ;
    }

    @Override
    protected Point3I adjustedSpiral(int n) {
        Point3I point = super.adjustedSpiral(n + 1);
        return point;
    }
}

