/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.crafter;

import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.ref.WrenchModes;
import com.vanhal.progressiveautomation.util.BlockHelper;
import com.vanhal.progressiveautomation.util.OreHelper;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCrafter
extends UpgradeableTileEntity {
    public int CRAFT_GRID_START = 1;
    public int CRAFT_GRID_END = 9;
    public int CRAFT_RESULT = 10;
    public int OUTPUT_SLOT = 11;
    public int craftTime = 100;
    public int currentTime = 0;

    public TileCrafter() {
        super(20);
        this.setUpgradeLevel(0);
        this.setCraftTime(120);
    }

    public void setCraftTime(int time) {
        this.craftTime = time;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.outputItems();
            if (this.isBurning()) {
                if (this.readyToBurn()) {
                    if (this.currentTime > 0 && this.currentTime <= this.craftTime) {
                        ++this.currentTime;
                        this.addPartialUpdate("currentTime", this.currentTime);
                    } else if (this.currentTime > this.craftTime) {
                        this.currentTime = 0;
                        this.addPartialUpdate("currentTime", this.currentTime);
                        if (this.consumeIngredients()) {
                            if (this.slots[this.OUTPUT_SLOT] != null) {
                                if (this.canCraft()) {
                                    this.slots[this.OUTPUT_SLOT].field_77994_a += this.slots[this.CRAFT_RESULT].field_77994_a;
                                }
                            } else {
                                this.slots[this.OUTPUT_SLOT] = this.slots[this.CRAFT_RESULT].func_77946_l();
                            }
                        }
                    } else if (this.currentTime != 1) {
                        this.currentTime = 1;
                        this.addPartialUpdate("currentTime", this.currentTime);
                    }
                } else if (this.currentTime != 0) {
                    this.currentTime = 0;
                    this.addPartialUpdate("currentTime", this.currentTime);
                }
            }
        }
    }

    protected void outputItems() {
        for (int x = 0; x < 6; ++x) {
            ISidedInventory externalInv;
            if (this.sides[x] != WrenchModes.Mode.Output || this.slots[this.OUTPUT_SLOT] == null) continue;
            ForgeDirection testSide = ForgeDirection.getOrientation((int)x);
            if (BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide) instanceof ISidedInventory) {
                externalInv = (ISidedInventory)BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide);
                this.addtoSidedExtInventory(externalInv, this.OUTPUT_SLOT);
                continue;
            }
            if (!(BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide) instanceof IInventory)) continue;
            externalInv = (IInventory)BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide);
            this.addtoExtInventory((IInventory)externalInv, this.OUTPUT_SLOT);
        }
    }

    @Override
    public boolean readyToBurn() {
        return this.validRecipe() && this.canCraft() && this.hasIngredients();
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("currentTime", this.currentTime);
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("currentTime")) {
            this.currentTime = nbt.func_74762_e("currentTime");
        }
    }

    public boolean canCraft() {
        return this.slots[this.OUTPUT_SLOT] == null || this.slots[this.OUTPUT_SLOT].func_77969_a(this.slots[this.CRAFT_RESULT]) && this.slots[this.OUTPUT_SLOT].field_77994_a + this.slots[this.CRAFT_RESULT].field_77994_a <= this.slots[this.OUTPUT_SLOT].func_77976_d();
    }

    public boolean validRecipe() {
        return this.slots[this.CRAFT_RESULT] != null;
    }

    public boolean hasIngredients() {
        return this.checkIngredients(false);
    }

    public boolean consumeIngredients() {
        if (this.checkIngredients(false)) {
            return this.checkIngredients(true);
        }
        return false;
    }

    protected boolean checkIngredients(boolean consume) {
        int i;
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        for (i = this.CRAFT_GRID_START; i <= this.CRAFT_GRID_END; ++i) {
            if (this.slots[i] == null) continue;
            required.add(this.slots[i].func_77946_l());
        }
        if (required.size() == 0) {
            return false;
        }
        for (i = this.SLOT_INVENTORY_START; i <= this.SLOT_INVENTORY_END; ++i) {
            if (this.slots[i] == null) continue;
            int amtItems = this.slots[i].field_77994_a;
            for (int j = 0; j < required.size(); ++j) {
                if (required.get(j) == null || !OreHelper.ItemOreMatch((ItemStack)required.get(j), this.slots[i]) || amtItems <= 0) continue;
                --amtItems;
                required.set(j, null);
            }
            if (!consume) continue;
            if (amtItems <= 0) {
                if (this.slots[i].func_77973_b().hasContainerItem(this.slots[i])) {
                    ItemStack container = this.slots[i].func_77973_b().getContainerItem(this.slots[i]);
                    this.addToInventory(new ItemStack(container.func_77973_b(), this.slots[i].field_77994_a, container.func_77960_j()));
                }
                this.slots[i] = null;
                continue;
            }
            if (this.slots[i] == null || this.slots[i].field_77994_a == amtItems) continue;
            if (this.slots[i].func_77973_b().hasContainerItem(this.slots[i])) {
                ItemStack container = this.slots[i].func_77973_b().getContainerItem(this.slots[i]);
                this.addToInventory(new ItemStack(container.func_77973_b(), this.slots[i].field_77994_a - amtItems, container.func_77960_j()));
            }
            this.slots[i].field_77994_a = amtItems;
        }
        for (int j = 0; j < required.size(); ++j) {
            if (required.get(j) == null) continue;
            required = null;
            return false;
        }
        required = null;
        return true;
    }

    public float getPercentCrafted() {
        if (this.currentTime != 0) {
            float done = this.craftTime - this.currentTime;
            done /= (float)this.craftTime;
            done = 1.0f - done;
            return done;
        }
        return 0.0f;
    }

    public int getScaledCrafted(int scale) {
        return (int)Math.floor((float)scale * this.getPercentCrafted());
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot >= this.SLOT_INVENTORY_START && slot <= this.SLOT_INVENTORY_END) {
            return true;
        }
        return super.func_94041_b(slot, stack);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (this.sides[side] == WrenchModes.Mode.Disabled) {
            return false;
        }
        if ((this.sides[side] == WrenchModes.Mode.Output || this.sides[side] == WrenchModes.Mode.Normal) && slot == this.OUTPUT_SLOT) {
            return true;
        }
        return this.sides[side] == WrenchModes.Mode.Input && slot >= this.SLOT_INVENTORY_START && slot <= this.SLOT_INVENTORY_END;
    }

    @Override
    public int[] func_94128_d(int var1) {
        int[] output = new int[this.slots.length - 9];
        output[0] = 0;
        for (int i = 1; i < this.slots.length - 9; ++i) {
            output[i] = i + 9;
        }
        return output;
    }
}

