/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.generator;

import cofh.api.energy.IEnergyHandler;
import com.vanhal.progressiveautomation.PAConfig;
import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.ref.WrenchModes;
import com.vanhal.progressiveautomation.util.BlockHelper;
import com.vanhal.progressiveautomation.util.Point2I;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileGenerator
extends BaseTileEntity {
    protected float fireRisk = 0.02f;
    protected int maxStorage = 10000;
    protected int currentStorage = 0;
    protected int generationRate = 10;
    protected int consumeRate = 1;
    protected boolean burnUpdate = false;

    public TileGenerator() {
        super(0);
        this.setEnergyStorage(20000, 0.5f);
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("energy", this.currentStorage);
        this.sides[this.extDirection.ordinal()] = WrenchModes.Mode.Normal;
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("energy")) {
            this.currentStorage = nbt.func_74762_e("energy");
        }
    }

    public void setFireChance(float chance) {
        this.fireRisk = chance;
    }

    public void setEnergyStorage(int size, float rate) {
        this.maxStorage = size;
        this.generationRate = (int)((float)PAConfig.rfCost * rate);
        this.consumeRate = (int)((float)PAConfig.fuelCost * rate);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning()) {
                this.changeCharge(this.generationRate);
                this.checkForFire();
            }
            this.outputEnergy();
        } else {
            this.checkUpdate();
        }
    }

    protected void checkUpdate() {
        if (this.isBurning() != this.burnUpdate) {
            this.burnUpdate = this.isBurning();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected void checkForFire() {
        if (this.fireRisk > this.field_145850_b.field_73012_v.nextFloat()) {
            int n = (int)Math.floor(8.0f * this.field_145850_b.field_73012_v.nextFloat()) + 1;
            Point2I p2 = this.spiral(n, this.field_145851_c, this.field_145849_e);
            Block supportBlock = this.field_145850_b.func_147439_a(p2.getX(), this.field_145848_d - 1, p2.getY());
            Block fireBlock = this.field_145850_b.func_147439_a(p2.getX(), this.field_145848_d, p2.getY());
            if (fireBlock.isAir((IBlockAccess)this.field_145850_b, p2.getX(), this.field_145848_d, p2.getY()) && supportBlock.isFlammable((IBlockAccess)this.field_145850_b, p2.getX(), this.field_145848_d - 1, p2.getY(), ForgeDirection.UP)) {
                this.field_145850_b.func_147449_b(p2.getX(), this.field_145848_d, p2.getY(), (Block)Blocks.field_150480_ab);
            }
        }
    }

    @Override
    public boolean readyToBurn() {
        return this.currentStorage < this.maxStorage;
    }

    public int getProduceRate() {
        return this.generationRate;
    }

    @Override
    public int getBurnTime(ItemStack item) {
        return TileGenerator.getItemBurnTime(item) / this.consumeRate;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.currentStorage, maxExtract);
        if (!simulate) {
            this.changeCharge(energyExtracted * -1);
        }
        return energyExtracted;
    }

    public void changeCharge(int amount) {
        int prevAmount = this.currentStorage;
        this.currentStorage += amount;
        if (this.currentStorage >= this.maxStorage) {
            this.currentStorage = this.maxStorage;
        }
        if (this.currentStorage < 0) {
            this.currentStorage = 0;
        }
        if (this.currentStorage != prevAmount) {
            this.addPartialUpdate("energy", this.currentStorage);
        }
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.currentStorage;
    }

    public int getEnergyStored() {
        return this.currentStorage;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.maxStorage;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public void outputEnergy() {
        for (int i = 0; i < 6; ++i) {
            int giveAmount;
            ForgeDirection fromDirection;
            IEnergyHandler energy;
            TileEntity entity;
            if (this.currentStorage <= 0 || !((entity = BlockHelper.getAdjacentTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, i)) instanceof IEnergyHandler) || !(energy = (IEnergyHandler)entity).canConnectEnergy(fromDirection = ForgeDirection.values()[ForgeDirection.OPPOSITES[i]]) || (giveAmount = energy.receiveEnergy(fromDirection, this.currentStorage, false)) <= 0) continue;
            this.changeCharge(giveAmount * -1);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return super.func_94041_b(slot, stack);
    }
}

