/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.miner;

import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.ref.ToolHelper;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.Point2I;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;

public class TileMiner
extends UpgradeableTileEntity {
    protected int totalMineBlocks = -1;
    protected int currentMineBlocks = 0;
    protected int currentColumn = 0;
    protected int currentYLevel = 0;
    protected Block currentBlock = null;
    protected int miningTime = 0;
    protected int miningWith = 0;
    protected int lastPick = -1;
    protected int lastShovel = -1;
    private int previousUpgrades;

    public TileMiner() {
        super(13);
        this.setUpgradeLevel(0);
        this.setAllowedUpgrades(UpgradeType.WOODEN, UpgradeType.WITHER, UpgradeType.COBBLE_GEN, UpgradeType.FILLER);
        this.SLOT_PICKAXE = 2;
        this.SLOT_SHOVEL = 3;
        this.SLOT_UPGRADE = 4;
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("MineBlocks", this.totalMineBlocks);
        nbt.func_74768_a("MinedBlocks", this.currentMineBlocks);
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("MineBlocks")) {
            this.totalMineBlocks = nbt.func_74762_e("MineBlocks");
        }
        if (nbt.func_74764_b("MinedBlocks")) {
            this.currentMineBlocks = nbt.func_74762_e("MinedBlocks");
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.checkForChanges();
            this.checkInventory();
            if (this.isBurning()) {
                this.useCobbleGen();
                if (!this.isDone()) {
                    this.mine();
                }
            }
        }
    }

    public void scanBlocks() {
        this.currentMineBlocks = 0;
        this.totalMineBlocks = 0;
        for (int i = 1; i <= this.getRange(); ++i) {
            Point2I currentPoint = this.spiral(i, this.field_145851_c, this.field_145849_e);
            boolean bedrock = false;
            int newY = this.field_145848_d - 1;
            while (!bedrock) {
                int result = this.canMineBlock(currentPoint.getX(), newY, currentPoint.getY());
                if (result >= 1) {
                    ++this.totalMineBlocks;
                } else if (result == -1) {
                    ++this.totalMineBlocks;
                    ++this.currentMineBlocks;
                }
                if (--newY >= 0) continue;
                bedrock = true;
            }
        }
        this.addPartialUpdate("MineBlocks", this.totalMineBlocks);
        this.addPartialUpdate("MinedBlocks", this.currentMineBlocks);
        this.notifyUpdate();
    }

    public int canMineBlock(int x, int y, int z) {
        Block tryBlock = this.field_145850_b.func_147439_a(x, y, z);
        if (tryBlock != null) {
            int meta = this.field_145850_b.func_72805_g(x, y, z);
            if (tryBlock.func_149712_f(this.field_145850_b, x, y, z) >= 0.0f && !tryBlock.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
                boolean mine = false;
                if (tryBlock == Blocks.field_150347_e) {
                    return -1;
                }
                if (tryBlock.getHarvestTool(meta) == "chisel") {
                    return 2;
                }
                if (tryBlock.getHarvestTool(meta) == "pickaxe") {
                    if (ForgeHooks.canToolHarvestBlock((Block)tryBlock, (int)meta, (ItemStack)this.func_70301_a(2))) {
                        return 2;
                    }
                } else if (tryBlock.getHarvestTool(meta) == "shovel") {
                    if (ForgeHooks.canToolHarvestBlock((Block)tryBlock, (int)meta, (ItemStack)this.func_70301_a(3))) {
                        return 3;
                    }
                } else if (!tryBlock.func_149688_o().func_76224_d()) {
                    return 1;
                }
            }
            if (this.hasUpgrade(UpgradeType.FILLER) && (tryBlock.isAir((IBlockAccess)this.field_145850_b, x, y, z) || tryBlock.func_149688_o().func_76224_d())) {
                return 4;
            }
        }
        return 0;
    }

    public void mine() {
        if (this.slots[1] == null || this.slots[2] == null || this.slots[3] == null) {
            return;
        }
        if (this.currentBlock != null) {
            if (this.miningTime <= 0) {
                this.miningTime = 0;
                Point2I currentPoint = this.spiral(this.currentColumn, this.field_145851_c, this.field_145849_e);
                if (this.miningWith != 4) {
                    if (this.field_145850_b.func_147438_o(currentPoint.getX(), this.currentYLevel, currentPoint.getY()) instanceof IInventory) {
                        IInventory inv = (IInventory)this.field_145850_b.func_147438_o(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            if (inv.func_70301_a(i) == null) continue;
                            this.addToInventory(inv.func_70301_a(i));
                            inv.func_70299_a(i, null);
                        }
                    }
                    int silkTouch = 0;
                    if (this.miningWith != 1) {
                        silkTouch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)this.slots[this.miningWith]);
                    }
                    if (silkTouch > 0) {
                        ItemStack item = new ItemStack(this.currentBlock, 1, this.field_145850_b.func_72805_g(currentPoint.getX(), this.currentYLevel, currentPoint.getY()));
                        this.addToInventory(item);
                    } else {
                        int fortuneLevel = 0;
                        if (this.miningWith != 1) {
                            fortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.slots[this.miningWith]);
                        }
                        ArrayList items = this.currentBlock.getDrops(this.field_145850_b, currentPoint.getX(), this.currentYLevel, currentPoint.getY(), this.field_145850_b.func_72805_g(currentPoint.getX(), this.currentYLevel, currentPoint.getY()), fortuneLevel);
                        for (ItemStack item : items) {
                            this.addToInventory(item);
                        }
                    }
                    if (this.miningWith != 1 && ToolHelper.damageTool(this.slots[this.miningWith], this.field_145850_b, currentPoint.getX(), this.currentYLevel, currentPoint.getY())) {
                        this.destroyTool(this.miningWith);
                    }
                }
                this.field_145850_b.func_147475_p(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
                this.field_145850_b.func_147449_b(currentPoint.getX(), this.currentYLevel, currentPoint.getY(), Blocks.field_150347_e);
                --this.slots[1].field_77994_a;
                if (this.slots[1].field_77994_a == 0) {
                    this.slots[1] = null;
                }
                ++this.currentMineBlocks;
                this.addPartialUpdate("MinedBlocks", this.currentMineBlocks);
                this.currentBlock = null;
            } else {
                --this.miningTime;
            }
        } else if (!this.isDone()) {
            this.currentBlock = this.getNextBlock();
            if (this.currentBlock != null) {
                Point2I currentPoint = this.spiral(this.currentColumn, this.field_145851_c, this.field_145849_e);
                if (this.miningWith == 4) {
                    this.miningTime = 1;
                } else {
                    this.miningTime = (int)Math.ceil((double)this.currentBlock.func_149712_f(this.field_145850_b, currentPoint.getX(), this.currentYLevel, currentPoint.getY()) * 1.5 * 20.0);
                    if (this.miningWith != 1) {
                        Item tool = this.slots[this.miningWith].func_77973_b();
                        float miningSpeed = tool.getDigSpeed(this.slots[this.miningWith], this.currentBlock, this.field_145850_b.func_72805_g(currentPoint.getX(), this.currentYLevel, currentPoint.getY()));
                        int eff = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)this.slots[this.miningWith]);
                        if (eff > 0) {
                            for (int i = 0; i < eff; ++i) {
                                miningSpeed *= 1.3f;
                            }
                        }
                        this.miningTime = (int)Math.ceil((float)this.miningTime / miningSpeed);
                    }
                }
            }
        }
        if (this.isDone()) {
            this.scanBlocks();
            this.currentColumn = this.getRange();
        }
    }

    public Block getNextBlock() {
        Point2I currentPoint = this.spiral(this.currentColumn, this.field_145851_c, this.field_145849_e);
        this.miningWith = this.canMineBlock(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
        while (this.miningWith <= 0 && this.currentYLevel >= 0) {
            if (this.miningWith > 0) {
                return this.field_145850_b.func_147439_a(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
            }
            --this.currentYLevel;
            if (this.currentYLevel < 0) continue;
            this.miningWith = this.canMineBlock(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
        }
        if (this.miningWith > 0) {
            return this.field_145850_b.func_147439_a(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
        }
        if (this.currentYLevel < 0) {
            this.currentYLevel = this.field_145848_d - 1;
            --this.currentColumn;
            if (this.currentColumn < 0) {
                this.scanBlocks();
                this.currentColumn = this.getRange();
            } else {
                return this.getNextBlock();
            }
        }
        return null;
    }

    protected int getCurrentUpgrades() {
        if (this.SLOT_UPGRADE == -1) {
            return 0;
        }
        if (this.func_70301_a(this.SLOT_UPGRADE) == null) {
            return 0;
        }
        return this.func_70301_a((int)this.SLOT_UPGRADE).field_77994_a;
    }

    public int getMinedBlocks() {
        return this.currentMineBlocks;
    }

    public void setMinedBlocks(int value) {
        this.currentMineBlocks = value;
    }

    public int getMineBlocks() {
        return this.totalMineBlocks;
    }

    public void setMineBlocks(int value) {
        this.totalMineBlocks = value;
    }

    public boolean isDone() {
        return this.totalMineBlocks == this.currentMineBlocks && this.totalMineBlocks > 0 && this.slots[this.SLOT_PICKAXE] != null && this.slots[this.SLOT_SHOVEL] != null;
    }

    public void useCobbleGen() {
        if (this.hasUpgrade(UpgradeType.COBBLE_GEN) && (this.slots[1] == null || this.slots[1].field_77994_a == 0) && this.slots[this.SLOT_PICKAXE] != null) {
            if (ToolHelper.damageTool(this.slots[this.SLOT_PICKAXE], this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.destroyTool(this.SLOT_PICKAXE);
            }
            this.slots[1] = new ItemStack(Blocks.field_150347_e);
        }
    }

    public void checkForChanges() {
        boolean update = false;
        if (this.slots[2] == null && this.lastPick >= 0) {
            this.lastPick = -1;
            update = true;
        } else if (this.slots[2] != null && ToolHelper.getLevel(this.slots[2]) != this.lastPick) {
            this.lastPick = ToolHelper.getLevel(this.slots[2]);
            update = true;
        }
        if (this.slots[3] == null && this.lastShovel >= 0) {
            this.lastShovel = -1;
            update = true;
        } else if (this.slots[3] != null && ToolHelper.getLevel(this.slots[3]) != this.lastShovel) {
            this.lastShovel = ToolHelper.getLevel(this.slots[3]);
            update = true;
        }
        if (this.previousUpgrades != this.getUpgrades()) {
            this.previousUpgrades = this.getUpgrades();
            update = true;
        }
        if (update) {
            this.scanBlocks();
            this.currentColumn = this.getRange();
            this.currentBlock = null;
            this.miningTime = 0;
            this.currentYLevel = this.field_145848_d - 1;
        }
    }

    @Override
    public boolean readyToBurn() {
        if (this.totalMineBlocks > 0 && this.currentMineBlocks < this.totalMineBlocks && (this.slots[1] != null || this.hasUpgrade(UpgradeType.COBBLE_GEN)) && this.slots[2] != null && this.slots[3] != null) {
            return true;
        }
        return (this.slots[1] == null || this.slots[1].field_77994_a == 0) && this.hasUpgrade(UpgradeType.COBBLE_GEN) && this.slots[2] != null && this.slots[3] != null;
    }

    @Override
    public int extraSlotCheck(ItemStack item) {
        if (item.func_77969_a(new ItemStack(Blocks.field_150347_e))) {
            return 1;
        }
        return super.extraSlotCheck(item);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 1 && stack.func_77969_a(new ItemStack(Blocks.field_150347_e))) {
            return true;
        }
        return super.func_94041_b(slot, stack);
    }
}

