/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.planter;

import com.vanhal.progressiveautomation.compat.ModHelper;
import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.ref.ToolHelper;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.Point2I;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePlanter
extends UpgradeableTileEntity {
    protected int searchBlock = -1;
    public int SLOT_SEEDS = 1;
    public int harvestTime = 80;
    public int currentTime = 0;
    protected int statusSet = 0;

    public TilePlanter() {
        super(12);
        this.setUpgradeLevel(0);
        this.setAllowedUpgrades(UpgradeType.WOODEN, UpgradeType.WITHER);
        this.setHarvestTime(80);
        this.setExtDirection(ForgeDirection.DOWN);
        this.SLOT_HOE = 2;
        this.SLOT_UPGRADE = 3;
    }

    protected void setHarvestTime(int time) {
        this.harvestTime = time;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.checkInventory();
            if (this.isBurning()) {
                if (this.searchBlock > -1) {
                    if (this.currentTime > 0) {
                        if (this.checkPlant(this.searchBlock)) {
                            --this.currentTime;
                            if (this.currentTime <= 0) {
                                this.harvestPlant(this.searchBlock);
                                this.searchBlock = -1;
                                this.addPartialUpdate("currentBlock", this.searchBlock);
                            }
                        } else {
                            this.currentTime = 0;
                            this.searchBlock = -1;
                            this.addPartialUpdate("currentBlock", this.searchBlock);
                        }
                        this.addPartialUpdate("currentTime", this.currentTime);
                    } else if (this.plantSeed(this.searchBlock, true)) {
                        this.searchBlock = -1;
                        this.addPartialUpdate("currentBlock", this.searchBlock);
                    } else if (this.checkPlant(this.searchBlock)) {
                        this.currentTime = this.harvestTime;
                        this.addPartialUpdate("currentTime", this.currentTime);
                    }
                } else {
                    this.doSearch();
                }
            }
        }
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("currentTime", this.currentTime);
        nbt.func_74768_a("currentBlock", this.searchBlock);
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("currentTime")) {
            this.currentTime = nbt.func_74762_e("currentTime");
        }
        if (nbt.func_74764_b("currentBlock")) {
            this.searchBlock = nbt.func_74762_e("currentBlock");
        }
    }

    public boolean doSearch() {
        int i;
        if (this.searchBlock >= 0) {
            return true;
        }
        for (i = 0; i < this.getRange(); ++i) {
            if (!this.checkPlant(i)) continue;
            this.searchBlock = i;
            this.addPartialUpdate("currentBlock", this.searchBlock);
            return true;
        }
        for (i = 0; i < this.getRange(); ++i) {
            if (!this.plantSeed(i, false)) continue;
            this.searchBlock = i;
            this.addPartialUpdate("currentBlock", this.searchBlock);
            return true;
        }
        return false;
    }

    protected void harvestPlant(int n) {
        ArrayList<ItemStack> items;
        Point3I currentBlock = this.getPoint(n);
        Block actualBlock = this.field_145850_b.func_147439_a(currentBlock.getX(), currentBlock.getY(), currentBlock.getZ());
        int metaData = this.field_145850_b.func_72805_g(currentBlock.getX(), currentBlock.getY(), currentBlock.getZ());
        if (this.slots[this.SLOT_HOE] != null && (items = ModHelper.harvestPlant(currentBlock, actualBlock, metaData, this.field_145850_b)) != null) {
            for (ItemStack item : items) {
                this.addToInventory(item);
            }
            this.damageHoe(currentBlock);
        }
    }

    protected boolean plantSeed(int n, boolean doAction) {
        if (this.slots[this.SLOT_SEEDS] != null && this.slots[this.SLOT_SEEDS].field_77994_a > 0) {
            Point3I point = this.getPoint(n);
            if (ModHelper.shouldHoe(this.slots[this.SLOT_SEEDS])) {
                this.hoeGround(n);
            }
            if (ModHelper.placeSeed(this.field_145850_b, this.slots[this.SLOT_SEEDS], point, doAction)) {
                if (doAction) {
                    --this.slots[this.SLOT_SEEDS].field_77994_a;
                    if (this.slots[this.SLOT_SEEDS].field_77994_a == 0) {
                        this.slots[this.SLOT_SEEDS] = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected boolean checkPlant(int n) {
        Point3I plantPoint = this.getPoint(n);
        Block plantBlock = this.field_145850_b.func_147439_a(plantPoint.getX(), plantPoint.getY(), plantPoint.getZ());
        int metadata = this.field_145850_b.func_72805_g(plantPoint.getX(), plantPoint.getY(), plantPoint.getZ());
        return ModHelper.isGrown(plantPoint, plantBlock, metadata, this.field_145850_b);
    }

    protected Point3I getPoint(int n) {
        Point2I p1 = this.spiral(n + 1, this.field_145851_c, this.field_145849_e);
        return new Point3I(p1.getX(), this.field_145848_d + 2, p1.getY());
    }

    protected void hoeGround(int n) {
        this.hoeGround(n, false);
    }

    protected void hoeGround(int n, boolean reverse) {
        Point3I plantPoint = this.getPoint(n);
        Block plantBlock = this.field_145850_b.func_147439_a(plantPoint.getX(), plantPoint.getY(), plantPoint.getZ());
        Point3I dirtPoint = new Point3I(plantPoint.getX(), plantPoint.getY() - 1, plantPoint.getZ());
        Block dirtBlock = this.field_145850_b.func_147439_a(dirtPoint.getX(), dirtPoint.getY(), dirtPoint.getZ());
        if (reverse) {
            if (dirtBlock == Blocks.field_150458_ak) {
                this.field_145850_b.func_147449_b(dirtPoint.getX(), dirtPoint.getY(), dirtPoint.getZ(), Blocks.field_150346_d);
            }
        } else if (this.slots[this.SLOT_HOE] != null && plantBlock.isAir((IBlockAccess)this.field_145850_b, plantPoint.getX(), plantPoint.getY(), plantPoint.getZ()) && (dirtBlock == Blocks.field_150349_c || dirtBlock == Blocks.field_150346_d)) {
            this.field_145850_b.func_147449_b(dirtPoint.getX(), dirtPoint.getY(), dirtPoint.getZ(), Blocks.field_150458_ak);
            this.damageHoe(dirtPoint);
        }
    }

    protected void damageHoe(Point3I point) {
        if (ToolHelper.damageTool(this.slots[this.SLOT_HOE], this.field_145850_b, point.getX(), point.getY(), point.getZ())) {
            this.destroyTool(this.SLOT_HOE);
        }
    }

    public int getStatus() {
        if (this.field_145850_b.field_72995_K) {
            return this.statusSet;
        }
        if (this.searchBlock > -1) {
            if (this.currentTime > 0) {
                if (this.checkPlant(this.searchBlock)) {
                    return 1;
                }
            } else if (this.plantSeed(this.searchBlock, false)) {
                return 2;
            }
        }
        return 0;
    }

    public void setStatus(int status) {
        this.statusSet = status;
    }

    @Override
    public boolean readyToBurn() {
        return this.slots[this.SLOT_HOE] != null && this.doSearch();
    }

    public static boolean isPlantable(ItemStack item) {
        return ModHelper.isPlantible(item) && !ModHelper.checkSapling(item);
    }

    @Override
    public int extraSlotCheck(ItemStack item) {
        if (TilePlanter.isPlantable(item)) {
            return this.SLOT_SEEDS;
        }
        return super.extraSlotCheck(item);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == this.SLOT_SEEDS && TilePlanter.isPlantable(stack)) {
            return true;
        }
        return super.func_94041_b(slot, stack);
    }

    @Override
    protected Point3I adjustedSpiral(int n) {
        Point3I point = super.adjustedSpiral(n);
        point.setY(point.getY() + 2);
        return point;
    }
}

