/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.events;

import com.vanhal.progressiveautomation.ProgressiveAutomation;
import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.items.PAItems;
import com.vanhal.progressiveautomation.util.Point3I;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EventRenderWorld {
    public static List<UpgradeableTileEntity> machines = new ArrayList<UpgradeableTileEntity>();
    private static List<UpgradeableTileEntity> toRemove = new ArrayList<UpgradeableTileEntity>();
    private int[] colors = new int[]{15, 26, 46, 52, 76, 89, 113, 156, 188, 204, 219, 231, 241};

    public static boolean containsMachine(UpgradeableTileEntity machine) {
        try {
            if (machines.contains(machine)) {
                return true;
            }
            ArrayList<UpgradeableTileEntity> tempList = new ArrayList<UpgradeableTileEntity>(machines);
            for (UpgradeableTileEntity testMachine : tempList) {
                if (testMachine.field_145851_c != machine.field_145851_c || testMachine.field_145848_d != machine.field_145848_d || testMachine.field_145849_e != machine.field_145849_e) continue;
                tempList = null;
                return true;
            }
            tempList = null;
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void removeMachines() {
        try {
            if (toRemove.size() > 0) {
                for (UpgradeableTileEntity remove : toRemove) {
                    if (!EventRenderWorld.containsMachine(remove)) continue;
                    machines.remove(toRemove);
                }
                toRemove.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addMachine(UpgradeableTileEntity machine) {
        if (!EventRenderWorld.containsMachine(machine)) {
            machines.add(machine);
        }
    }

    public static void removeMachine(UpgradeableTileEntity machine) {
        if (EventRenderWorld.containsMachine(machine)) {
            toRemove.add(machine);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(WorldEvent.Unload world) {
        if (world.world.field_73011_w == null || Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71439_g.field_70170_p == null || Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w == null) {
            return;
        }
        if (world.world.field_73011_w.field_76574_g == Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.field_76574_g) {
            machines.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderWorldLast(RenderWorldLastEvent e) {
        if (ProgressiveAutomation.proxy.isServer()) {
            return;
        }
        EventRenderWorld.removeMachines();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        boolean holdingWrench = false;
        if (player.field_71071_by.func_70448_g() == null) {
            return;
        }
        if (!player.field_71071_by.func_70448_g().func_77973_b().equals((Object)PAItems.wrench)) {
            return;
        }
        holdingWrench = true;
        float playerOffsetX = -((float)(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)e.partialTicks));
        float playerOffsetY = -((float)(player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)e.partialTicks));
        float playerOffsetZ = -((float)(player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)e.partialTicks));
        GL11.glPushMatrix();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7424);
        for (UpgradeableTileEntity machine : machines) {
            if (machine == null || machine.func_145837_r() || machine.func_145831_w() == null || !machine.func_145831_w().field_72995_K || !holdingWrench && !machine.displayRange()) continue;
            float r = this.randomColour(machine.field_145851_c);
            float g = this.randomColour(machine.field_145848_d);
            float b = this.randomColour(machine.field_145849_e);
            GL11.glPushMatrix();
            GL11.glColor4f((float)r, (float)g, (float)b, (float)0.4f);
            GL11.glTranslatef((float)playerOffsetX, (float)playerOffsetY, (float)playerOffsetZ);
            Point3I block = machine.getRangeBlock();
            EventRenderWorld.renderBlock(block.getX(), block.getY(), block.getZ());
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    private float randomColour(int c) {
        c = Math.abs(c);
        int remainder = (int)Math.floor(c % this.colors.length);
        return (float)this.colors[remainder] / 255.0f;
    }

    public static void renderBlock(int x, int y, int z) {
        double shrink = -0.005;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x + shrink, (double)(y + 1) - shrink, (double)z + shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)(y + 1) - shrink, (double)z + shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)y + shrink, (double)z + shrink);
        tessellator.func_78377_a((double)x + shrink, (double)y + shrink, (double)z + shrink);
        tessellator.func_78377_a((double)x + shrink, (double)y + shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)y + shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)(y + 1) - shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)x + shrink, (double)(y + 1) - shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)x + shrink, (double)y + shrink, (double)z + shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)y + shrink, (double)z + shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)y + shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)x + shrink, (double)y + shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)x + shrink, (double)(y + 1) - shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)(y + 1) - shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)(y + 1) - shrink, (double)z + shrink);
        tessellator.func_78377_a((double)x + shrink, (double)(y + 1) - shrink, (double)z + shrink);
        tessellator.func_78377_a((double)x + shrink, (double)y + shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)x + shrink, (double)(y + 1) - shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)x + shrink, (double)(y + 1) - shrink, (double)z + shrink);
        tessellator.func_78377_a((double)x + shrink, (double)y + shrink, (double)z + shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)y + shrink, (double)z + shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)(y + 1) - shrink, (double)z + shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)(y + 1) - shrink, (double)(z + 1) - shrink);
        tessellator.func_78377_a((double)(x + 1) - shrink, (double)y + shrink, (double)(z + 1) - shrink);
        tessellator.func_78381_a();
    }
}

