/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.container;

import com.vanhal.progressiveautomation.blocks.network.NetworkHandler;
import com.vanhal.progressiveautomation.blocks.network.PartialTileNBTUpdateMessage;
import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.gui.slots.SlotBurn;
import com.vanhal.progressiveautomation.gui.slots.SlotPower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BaseContainer
extends Container {
    public static final byte TICKS_PER_MESSAGE = 5;
    protected BaseTileEntity entity;

    public BaseContainer(BaseTileEntity inEntity, int x, int y) {
        this(inEntity, x, y, true);
    }

    public BaseContainer(BaseTileEntity inEntity, int x, int y, boolean canPower) {
        this.entity = inEntity;
        if (canPower) {
            this.func_75146_a(new SlotPower((IInventory)this.entity, this.entity.SLOT_FUEL, x, y));
        } else {
            this.func_75146_a(new SlotBurn((IInventory)this.entity, this.entity.SLOT_FUEL, x, y));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.entity.isLooked()) {
            this.entity.setLooked();
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot < this.entity.func_70302_i_()) {
                if (!this.func_75135_a(stackInSlot, this.entity.func_70302_i_(), this.field_75151_b.size(), true)) {
                    return null;
                }
            } else {
                boolean foundSlot = false;
                for (Object targetSlot : this.field_75151_b) {
                    if (!(targetSlot instanceof Slot)) continue;
                    Slot theTargetSlot = (Slot)targetSlot;
                    int slotNum = theTargetSlot.field_75222_d;
                    if (slot == slotNum) continue;
                    if (slotNum >= this.entity.SLOT_INVENTORY_START && this.entity.SLOT_INVENTORY_START != this.entity.SLOT_INVENTORY_END && this.entity.SLOT_INVENTORY_START != -1) {
                        if (!this.func_75135_a(stackInSlot, this.entity.SLOT_INVENTORY_START, this.entity.SLOT_INVENTORY_END + 1, false)) {
                            return null;
                        }
                        foundSlot = true;
                        break;
                    }
                    if (!theTargetSlot.func_75214_a(stackInSlot) || theTargetSlot.func_75219_a() <= 1 || theTargetSlot.func_75216_d() && theTargetSlot.func_75211_c().field_77994_a >= theTargetSlot.func_75219_a()) continue;
                    if (!this.func_75135_a(stackInSlot, slotNum, slotNum + 1, false)) {
                        return null;
                    }
                    foundSlot = true;
                    break;
                }
                if (!foundSlot) {
                    return null;
                }
            }
            if (stackInSlot.field_77994_a == 0) {
                slotObject.func_75215_d(null);
            } else {
                slotObject.func_75218_e();
            }
        }
        return stack;
    }

    public void addPlayerInventory(InventoryPlayer inv) {
        this.addPlayerInventory(inv, 8, 84);
    }

    public void addPlayerInventory(InventoryPlayer inv, int y) {
        this.addPlayerInventory(inv, 8, y);
    }

    public void addPlayerInventory(InventoryPlayer inv, int x, int y) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + (i + 1) * 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inv, i, 8 + i * 18, y + 58));
        }
    }

    public void addInventory(IInventory inventory, int startSlot, int x, int y, int width, int height) {
        int i = 0;
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                this.func_75146_a(new Slot(inventory, startSlot + i++, x + w * 18, y + h * 18));
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.entity.isDirty() && this.entity.func_145831_w().func_72820_D() % 5L == 0L) {
            PartialTileNBTUpdateMessage message = this.entity.getPartialUpdateMessage();
            for (Object o : this.field_75149_d) {
                if (!(o instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)o;
                NetworkHandler.sendToPlayer(message, player);
            }
        }
    }
}

