/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.util;

import com.vanhal.progressiveautomation.util.Point3I;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CoordList {
    private TMap<String, Point3I> list = new THashMap();
    private TMap<Integer, String> map = new THashMap();

    public CoordList() {
        this.clear();
    }

    public boolean inList(Point3I point) {
        return this.list.containsKey((Object)this.hashPoint(point));
    }

    public NBTTagList saveToNBT() {
        NBTTagList contents = new NBTTagList();
        for (int i = 0; i < this.list.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            int index = this.list.size() - i;
            String key = (String)this.map.get((Object)index);
            tag.func_74768_a("index", index);
            tag.func_74778_a("key", key);
            tag.func_74782_a("coord", (NBTBase)((Point3I)this.list.get((Object)key)).getNBT());
            contents.func_74742_a((NBTBase)tag);
        }
        return contents;
    }

    public void loadFromNBT(NBTTagList contents) {
        this.clear();
        for (int i = 0; i < contents.func_74745_c(); ++i) {
            NBTTagCompound tag = contents.func_150305_b(i);
            int index = tag.func_74762_e("index");
            String key = tag.func_74779_i("key");
            Point3I point = new Point3I();
            point.setNBT(tag.func_74775_l("coord"));
            this.map.put((Object)index, (Object)key);
            this.list.put((Object)key, (Object)point);
        }
    }

    public boolean inList(int x, int y, int z) {
        return this.inList(new Point3I(x, y, z));
    }

    public boolean push(Point3I inPoint) {
        String key = this.hashPoint(inPoint);
        Point3I point = new Point3I(inPoint);
        if (this.list.containsKey((Object)key)) {
            return false;
        }
        this.list.put((Object)key, (Object)point);
        this.map.put((Object)this.list.size(), (Object)key);
        return true;
    }

    public Point3I pop() {
        if (this.list.size() > 0) {
            String key = (String)this.map.remove((Object)this.list.size());
            return (Point3I)this.list.remove((Object)key);
        }
        return null;
    }

    public Point3I peak() {
        if (this.list.size() > 0) {
            String key = (String)this.map.get((Object)this.list.size());
            return (Point3I)this.list.get((Object)key);
        }
        return null;
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public int size() {
        return this.list.size();
    }

    protected String hashPoint(Point3I point) {
        String hash = point.getX() + "|" + point.getY() + "|" + point.getZ();
        return hash;
    }
}

