/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.configuration;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.aobd.AOBD;
import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import java.awt.Color;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration configFile;
    public Set<String> usedCategories = new HashSet<String>();

    public void preInit(File file) {
        this.configFile = new Configuration(file, true);
        this.preInit();
        this.usedCategories.add("Recipes");
        this.usedCategories.add("Custom");
    }

    private void preInit() {
        for (CompatType type : CompatType.values()) {
            type.setStatus(this.getBoolean("Recipes", type.modID(), true, true));
        }
        AOBD.userDefinedItems = this.getStringWithComment("Custom", "items", "", "Add prefixes separated by commas.\nTextures will be aobd:prefix and aobd:prefix_overlay.\nExample: dust,cluster");
        AOBD.userDefinedGases = this.getStringWithComment("Custom", "gases", "", "Add ore names that will be turned into Mekanism gases (First letter must be capitalised). Example: Iron,Gold,Titanium");
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    public void initOreConfigs() {
        for (Ore ore : Ore.ores) {
            String name = ore.name();
            for (CompatType type : CompatType.values()) {
                ore.configType(this.getBoolean(name, type.modID(), true, true), type);
            }
            ore.setDisabled(this.getBoolean(name, "Disable All", true, false));
            ore.setExtra(this.getString(name, "extra", ore.extra()));
            ore.setEnergy(this.getDouble(name, "energy", ore.energy(1.0)));
            this.usedCategories.add(name);
        }
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    public void initColourConfigs() {
        for (Ore ore : Ore.ores) {
            ore.setColour(this.getColour(ore.name(), "colour", ore.colour()));
        }
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("aobd".equals(eventArgs.modID)) {
            this.configFile.load();
            this.preInit();
            this.initOreConfigs();
            this.initColourConfigs();
        }
    }

    private Color getColour(String category, String name, int def) {
        return Color.decode(this.getString(category, name, "0x" + Integer.toHexString(def)));
    }

    private String getString(String category, String name, String def) {
        return this.configFile.get(category, name, def).getString();
    }

    private String getStringWithComment(String category, String name, String def, String comment) {
        return this.configFile.get(category, name, def, comment).setRequiresMcRestart(true).getString();
    }

    private boolean getBoolean(String category, String name, boolean requiresRestart, boolean def) {
        return this.configFile.get(category, name, def).setRequiresMcRestart(requiresRestart).getBoolean(def);
    }

    private double getDouble(String category, String name, double def) {
        return this.configFile.get(category, name, def).getDouble(def);
    }
}

