/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vswe.stevescarts.Blocks.BlockSpecialRailBase;
import vswe.stevescarts.Blocks.ModBlocks;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.DetectorType;
import vswe.stevescarts.ModuleData.ModuleData;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.TileEntities.TileEntityActivator;
import vswe.stevescarts.TileEntities.TileEntityDetector;
import vswe.stevescarts.TileEntities.TileEntityManager;
import vswe.stevescarts.TileEntities.TileEntityUpgrade;
import vswe.stevescarts.Upgrades.BaseEffect;
import vswe.stevescarts.Upgrades.Disassemble;
import vswe.stevescarts.Upgrades.Transposer;

public class BlockRailAdvDetector
extends BlockSpecialRailBase {
    private IIcon normalIcon;
    private IIcon cornerIcon;

    public BlockRailAdvDetector() {
        super(false);
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
    }

    public IIcon func_149691_a(int side, int meta) {
        return meta >= 6 ? this.cornerIcon : this.normalIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.normalIcon = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + "advanced_detector_rail");
        this.cornerIcon = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + "advanced_detector_rail" + "_corner");
    }

    public boolean canMakeSlopes(IBlockAccess world, int i, int j, int k) {
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart Minecart, int x, int y, int z) {
        if (world.field_72995_K || !(Minecart instanceof MinecartModular)) {
            return;
        }
        MinecartModular cart = (MinecartModular)Minecart;
        if (world.func_147439_a(x, y - 1, z) == ModBlocks.DETECTOR_UNIT.getBlock() && DetectorType.getTypeFromMeta(world.func_72805_g(x, y - 1, z)).canInteractWithCart()) {
            TileEntity tileentity = world.func_147438_o(x, y - 1, z);
            if (tileentity != null && tileentity instanceof TileEntityDetector) {
                TileEntityDetector detector = (TileEntityDetector)tileentity;
                detector.handleCart(cart);
            }
            return;
        }
        if (!this.isCartReadyForAction(cart, x, y, z)) {
            return;
        }
        int side = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                TileEntityUpgrade upgrade;
                TileEntity tileentity;
                if (Math.abs(i) == Math.abs(j)) continue;
                Block block = world.func_147439_a(x + i, y, z + j);
                if (block == ModBlocks.CARGO_MANAGER.getBlock() || block == ModBlocks.LIQUID_MANAGER.getBlock()) {
                    TileEntityManager manager;
                    tileentity = world.func_147438_o(x + i, y, z + j);
                    if (tileentity != null && tileentity instanceof TileEntityManager && (manager = (TileEntityManager)tileentity).getCart() == null) {
                        manager.setCart(cart);
                        manager.setSide(side);
                    }
                    return;
                }
                if (block == ModBlocks.MODULE_TOGGLER.getBlock()) {
                    tileentity = world.func_147438_o(x + i, y, z + j);
                    if (tileentity != null && tileentity instanceof TileEntityActivator) {
                        TileEntityActivator activator = (TileEntityActivator)tileentity;
                        boolean isOrange = false;
                        if (cart.temppushX == 0.0 == (cart.temppushZ == 0.0)) continue;
                        if (i == 0) {
                            isOrange = j == -1 ? cart.temppushX < 0.0 : cart.temppushX > 0.0;
                        } else if (j == 0) {
                            isOrange = i == -1 ? cart.temppushZ > 0.0 : cart.temppushZ < 0.0;
                        }
                        boolean isBlueBerry = false;
                        activator.handleCart(cart, isOrange);
                        cart.releaseCart();
                    }
                    return;
                }
                if (block == ModBlocks.UPGRADE.getBlock() && (upgrade = (TileEntityUpgrade)(tileentity = world.func_147438_o(x + i, y, z + j))) != null && upgrade.getUpgrade() != null) {
                    for (BaseEffect effect : upgrade.getUpgrade().getEffects()) {
                        if (!(effect instanceof Transposer)) continue;
                        Transposer transposer = (Transposer)effect;
                        if (upgrade.getMaster() == null) continue;
                        for (TileEntityUpgrade tile : upgrade.getMaster().getUpgradeTiles()) {
                            if (tile.getUpgrade() == null) continue;
                            for (BaseEffect effect2 : tile.getUpgrade().getEffects()) {
                                if (!(effect2 instanceof Disassemble)) continue;
                                Disassemble disassembler = (Disassemble)effect2;
                                if (tile.func_70301_a(0) != null) continue;
                                tile.func_70299_a(0, ModuleData.createModularCart(cart));
                                upgrade.getMaster().managerInteract(cart, false);
                                for (int p = 0; p < cart.func_70302_i_(); ++p) {
                                    ItemStack item = cart.func_70304_b(p);
                                    if (item == null) continue;
                                    upgrade.getMaster().puke(item);
                                }
                                cart.func_70106_y();
                                return;
                            }
                        }
                    }
                }
                ++side;
            }
        }
        boolean receivesPower = world.func_72864_z(x, y, z);
        if (receivesPower) {
            cart.releaseCart();
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_147439_a(x, y - 1, z) == ModBlocks.DETECTOR_UNIT.getBlock() && DetectorType.getTypeFromMeta(world.func_72805_g(x, y - 1, z)).canInteractWithCart()) {
            return false;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                TileEntity tileentity;
                TileEntityUpgrade upgrade;
                if (Math.abs(i) == Math.abs(j)) continue;
                Block block = world.func_147439_a(x + i, y, z + j);
                if (block == ModBlocks.CARGO_MANAGER.getBlock() || block == ModBlocks.LIQUID_MANAGER.getBlock() || block == ModBlocks.MODULE_TOGGLER.getBlock()) {
                    return false;
                }
                if (block != ModBlocks.UPGRADE.getBlock() || (upgrade = (TileEntityUpgrade)(tileentity = world.func_147438_o(x + i, y, z + j))) == null || upgrade.getUpgrade() == null) continue;
                for (BaseEffect effect : upgrade.getUpgrade().getEffects()) {
                    if (!(effect instanceof Transposer) || upgrade.getMaster() == null) continue;
                    for (TileEntityUpgrade tile : upgrade.getMaster().getUpgradeTiles()) {
                        if (tile.getUpgrade() == null) continue;
                        for (BaseEffect effect2 : tile.getUpgrade().getEffects()) {
                            if (!(effect2 instanceof Disassemble)) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private boolean isCartReadyForAction(MinecartModular cart, int x, int y, int z) {
        if (cart.disabledX == x || cart.disabledY == y || cart.disabledZ == z) {
            return cart.isDisabled();
        }
        return false;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (world.func_147439_a(i, j - 1, k) == ModBlocks.DETECTOR_UNIT.getBlock()) {
            return ModBlocks.DETECTOR_UNIT.getBlock().func_149727_a(world, i, j - 1, k, entityplayer, par6, par7, par8, par9);
        }
        return false;
    }

    public void refreshState(World world, int x, int y, int z, boolean flag) {
        new BlockRailBase.Rail((BlockRailBase)this, world, x, y, z).func_150655_a(flag, false);
    }
}

