/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Upgrades;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import vswe.stevescarts.Containers.ContainerUpgrade;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Helpers.Tank;
import vswe.stevescarts.Interfaces.GuiUpgrade;
import vswe.stevescarts.Slots.SlotLiquidOutput;
import vswe.stevescarts.Slots.SlotLiquidUpgradeInput;
import vswe.stevescarts.TileEntities.TileEntityUpgrade;
import vswe.stevescarts.Upgrades.InventoryEffect;

public abstract class TankEffect
extends InventoryEffect {
    private static final int tankInterfaceX = 35;
    private static final int tankInterfaceY = 20;
    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation texture;

    public abstract int getTankSize();

    @Override
    public Class<? extends Slot> getSlot(int id) {
        return SlotLiquidOutput.class;
    }

    @Override
    public Slot createSlot(TileEntityUpgrade upgrade, int id) {
        if (id == 0) {
            return new SlotLiquidUpgradeInput(upgrade, upgrade.tank, 16, id, this.getSlotX(id), this.getSlotY(id));
        }
        return super.createSlot(upgrade, id);
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public int getSlotX(int id) {
        return 8;
    }

    @Override
    public int getSlotY(int id) {
        return 24 * (id + 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(TileEntityUpgrade upgrade, GuiUpgrade gui, int x, int y) {
        if (texture == null) {
            texture = ResourceHelper.getResource("/gui/tank.png");
        }
        upgrade.tank.drawFluid(gui, 35, 20);
        ResourceHelper.bindResource(texture);
        gui.func_73729_b(gui.getGuiLeft() + 35, gui.getGuiTop() + 20, 0, 0, 36, 51);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(TileEntityUpgrade upgrade, GuiUpgrade gui, int x, int y) {
        this.drawMouseOver(gui, upgrade.tank.getMouseOver(), x, y, new int[]{35, 20, 36, 51});
    }

    @Override
    public void checkGuiData(TileEntityUpgrade upgrade, ContainerUpgrade con, ICrafting crafting, boolean isNew) {
        boolean changed = false;
        int id = 0;
        int amount1 = 1;
        int amount2 = 2;
        int meta = 3;
        FluidStack oldfluid = (FluidStack)con.olddata;
        if ((isNew || oldfluid != null) && upgrade.tank.getFluid() == null) {
            upgrade.updateGuiData(con, crafting, id, (short)-1);
            changed = true;
        } else if (upgrade.tank.getFluid() != null) {
            if (isNew || oldfluid == null) {
                upgrade.updateGuiData(con, crafting, id, (short)upgrade.tank.getFluid().fluidID);
                upgrade.updateGuiData(con, crafting, amount1, upgrade.getShortFromInt(true, upgrade.tank.getFluid().amount));
                upgrade.updateGuiData(con, crafting, amount2, upgrade.getShortFromInt(false, upgrade.tank.getFluid().amount));
                changed = true;
            } else {
                if (oldfluid.fluidID != upgrade.tank.getFluid().fluidID) {
                    upgrade.updateGuiData(con, crafting, id, (short)upgrade.tank.getFluid().fluidID);
                    changed = true;
                }
                if (oldfluid.amount != upgrade.tank.getFluid().amount) {
                    upgrade.updateGuiData(con, crafting, amount1, upgrade.getShortFromInt(true, upgrade.tank.getFluid().amount));
                    upgrade.updateGuiData(con, crafting, amount2, upgrade.getShortFromInt(false, upgrade.tank.getFluid().amount));
                    changed = true;
                }
            }
        }
        if (changed) {
            con.olddata = upgrade.tank.getFluid() == null ? null : upgrade.tank.getFluid().copy();
        }
    }

    @Override
    public void receiveGuiData(TileEntityUpgrade upgrade, int id, short data) {
        if (id == 0) {
            if (data == -1) {
                upgrade.tank.setFluid(null);
            } else if (upgrade.tank.getFluid() == null) {
                upgrade.tank.setFluid(new FluidStack((int)data, 0));
            }
        } else if (upgrade.tank.getFluid() != null) {
            upgrade.tank.getFluid().amount = upgrade.getIntFromShort(id == 1, upgrade.tank.getFluid().amount, data);
        }
    }

    @Override
    public void init(TileEntityUpgrade upgrade) {
        upgrade.tank = new Tank(upgrade, this.getTankSize(), 0);
        upgrade.getCompound().func_74774_a("Tick", (byte)0);
    }

    @Override
    public void update(TileEntityUpgrade upgrade) {
        super.update(upgrade);
        upgrade.getCompound().func_74774_a("Tick", (byte)(upgrade.getCompound().func_74771_c("Tick") - 1));
        if (upgrade.getCompound().func_74771_c("Tick") > 0) {
            return;
        }
        upgrade.getCompound().func_74774_a("Tick", (byte)5);
        if (!upgrade.func_145831_w().field_72995_K && this.slots != null && this.slots.size() >= 2) {
            upgrade.tank.containerTransfer();
        }
    }

    @Override
    public void load(TileEntityUpgrade upgrade, NBTTagCompound compound) {
        if (compound.func_74771_c("Exists") != 0) {
            upgrade.tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound));
        } else {
            upgrade.tank.setFluid(null);
        }
    }

    @Override
    public void save(TileEntityUpgrade upgrade, NBTTagCompound compound) {
        if (upgrade.tank.getFluid() == null) {
            compound.func_74774_a("Exists", (byte)0);
        } else {
            compound.func_74774_a("Exists", (byte)1);
            upgrade.tank.getFluid().writeToNBT(compound);
        }
    }
}

