/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world;

import aroma1997.core.client.util.Colors;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.util.AromaRegistry;
import aroma1997.core.util.ItemUtil;
import aroma1997.core.version.VersionCheck;
import aroma1997.world.CommonProxy;
import aroma1997.world.Config;
import aroma1997.world.CraftingBook;
import aroma1997.world.CreativeTabDW;
import aroma1997.world.DimensionalWorldBlocks;
import aroma1997.world.DimensionalWorldItems;
import aroma1997.world.EventListener;
import aroma1997.world.Reference;
import aroma1997.world.dimension.BiomeGenMining;
import aroma1997.world.dimension.WorldProviderMiner;
import aroma1997.world.miner.MinerItems;
import aroma1997.world.miner.Miners;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="Aroma1997sDimension", name="Aroma1997's Dimensional World", dependencies="required-after:Aroma1997Core")
public class DimensionalWorld {
    @Mod.Instance(value="Aroma1997sDimension")
    public static DimensionalWorld instance;
    @SidedProxy(clientSide="aroma1997.world.client.ClientProxy", serverSide="aroma1997.world.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs creativeTabDW;
    public Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = LogHelperPre.genNewLogger((String)"Aroma1997sDimension");
        Config.instance.load();
        AromaRegistry.register(DimensionalWorldBlocks.class);
        AromaRegistry.register(DimensionalWorldItems.class);
        if (Config.instance.enableMiner) {
            AromaRegistry.register(MinerItems.class);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        BiomeGenMining.instance = new BiomeGenMining(Config.instance.biomeID);
        ItemStack igniter = new ItemStack((Item)DimensionalWorldItems.portalIgniter, 1, Short.MAX_VALUE);
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)DimensionalWorldItems.dimensionChanger), (boolean)false, (Object[])new Object[]{"DED", "PIP", "DED", Character.valueOf('D'), new ItemStack(Items.field_151045_i), Character.valueOf('E'), new ItemStack(Items.field_151061_bv), Character.valueOf('P'), new ItemStack(Items.field_151079_bi), Character.valueOf('I'), igniter});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)DimensionalWorldItems.dimensionChanger), (boolean)false, (Object[])new Object[]{"DPD", "EIE", "DPD", Character.valueOf('D'), new ItemStack(Items.field_151045_i), Character.valueOf('E'), new ItemStack(Items.field_151061_bv), Character.valueOf('P'), new ItemStack(Items.field_151079_bi), Character.valueOf('I'), igniter});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)DimensionalWorldItems.portalIgniter), (boolean)false, (Object[])new Object[]{"xwx", " y ", " z ", Character.valueOf('x'), new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE), Character.valueOf('w'), new ItemStack(Items.field_151033_d), Character.valueOf('y'), new ItemStack(Items.field_151050_s), Character.valueOf('z'), "stickWood"});
        AromaRegistry.registerShapelessAromicRecipe((ItemStack)new ItemStack(DimensionalWorldBlocks.portalFrame), (boolean)false, (Object[])new Object[]{igniter, new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE)});
        AromaRegistry.registerShapelessAromicRecipe((ItemStack)DimensionalWorld.getHelpBook(), (boolean)false, (Object[])new Object[]{new ItemStack(Items.field_151122_aG), igniter});
        GameRegistry.addRecipe((IRecipe)new CraftingBook());
        if (DimensionManager.isDimensionRegistered((int)Config.instance.dimensionID)) {
            this.logger.log(Level.ERROR, "Failed to register the Mining Dimension with the ID " + Config.instance.dimensionID + ". Please pick another one!");
        }
        DimensionManager.registerProviderType((int)Config.instance.dimensionID, WorldProviderMiner.class, (boolean)false);
        DimensionManager.registerDimension((int)Config.instance.dimensionID, (int)Config.instance.dimensionID);
        WorldProvider provider = DimensionManager.createProviderFor((int)Config.instance.dimensionID);
        if (provider == null || !WorldProviderMiner.class.isInstance(provider)) {
            throw new RuntimeException("The Mining World was registered, but wasn't. This is a severe issue!");
        }
        FMLInterModComms.sendMessage((String)"BuildCraft|Energy", (String)"oil-gen-exclude", (String)(Config.instance.biomeID + ""));
        FMLInterModComms.sendMessage((String)"Thaumcraft", (String)"dimensionBlacklist", (String)(Config.instance.dimensionID + ":1"));
        FMLInterModComms.sendMessage((String)"Thaumcraft", (String)"biomeBlacklist", (String)(Config.instance.biomeID + ":1"));
        new EventListener();
        BiomeManager.addStrongholdBiome((BiomeGenBase)BiomeGenMining.instance);
        BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenMining.instance, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN});
        VersionCheck.registerVersionChecker((String)"Aroma1997sDimension".replace(" ", ""), (String)Reference.VERSION);
        this.logger.log(Level.INFO, "Loaded.");
        this.logger.log(Level.TRACE, "Dimension registered with ID: " + Config.instance.dimensionID + ".");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void worldloaded(FMLServerStartedEvent event) {
        DimensionManager.init();
    }

    public static ItemStack getHelpBook() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("book.aroma1997sdimension:chapter.general");
        list.add("book.aroma1997sdimension:general.1");
        list.add("book.aroma1997sdimension:general.2");
        list.add("book.aroma1997sdimension:general.3");
        list.add("book.aroma1997sdimension:chapter.blocks");
        list.add("book.aroma1997sdimension:blocks.1");
        list.add("book.aroma1997sdimension:blocks.portalFrame");
        for (Miners miner : Miners.values()) {
            list.add("book.aroma1997sdimension:blocks." + miner.getName());
        }
        list.add("book.aroma1997sdimension:chapter.items");
        list.add("book.aroma1997sdimension:items.1");
        list.add("book.aroma1997sdimension:items.portalIgniter");
        list.add("book.aroma1997sdimension:items.dimensionChanger");
        list.add("book.aroma1997sdimension:chapter.setupPortal");
        list.add("book.aroma1997sdimension:setupPortal.1");
        list.add("book.aroma1997sdimension:setupPortal.2");
        list.add("book.aroma1997sdimension:chapter.setupMiner");
        list.add("book.aroma1997sdimension:setupMiner.1");
        list.add("book.aroma1997sdimension:setupMiner.2");
        list.add("book.aroma1997sdimension:setupMiner.3");
        list.add("book.aroma1997sdimension:setupMiner.4");
        list.add("book.aroma1997sdimension:setupMiner.5");
        ItemStack stack = ItemUtil.getWrittenBook((String)"book.aroma1997sdimension:name", (String)"SkyeFirez", (boolean)true, (String[])list.toArray(new String[list.size()]));
        stack.func_77978_p().func_74778_a("id", "DimensionalWorld");
        return stack;
    }

    public static String getWorldMessage() {
        if (!Config.instance.enableMessage || Config.instance.sendMessage == null) {
            return null;
        }
        String msg = Colors.applyColors((String)Config.instance.sendMessage);
        return msg;
    }

    static {
        creativeTabDW = new CreativeTabDW("Aroma1997sDimension".toLowerCase() + ":creativeTabDW");
    }
}

