/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.miner;

import aroma1997.core.client.inventories.SpecialImagesBase;
import aroma1997.core.inventories.AromaContainer;
import aroma1997.core.inventories.IProgressable;
import aroma1997.core.inventories.ISpecialGUIProvider;
import aroma1997.core.inventories.Inventories;
import aroma1997.core.items.wrench.IAromaWrenchable;
import aroma1997.core.log.LogHelper;
import aroma1997.world.DimensionalWorld;
import aroma1997.world.miner.ContainerMiner;
import aroma1997.world.miner.MinerState;
import aroma1997.world.miner.Miners;
import aroma1997.world.miner.api.IMinerEnchantProvider;
import aroma1997.world.miner.api.IMinerTile;
import aroma1997.world.miner.api.MinerConstants;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public final class TileEntityMinerCore
extends TileEntity
implements IAromaWrenchable,
ISpecialGUIProvider,
IProgressable {
    private int fuelLevel;
    private ArrayList<ItemStack> itemList = new ArrayList();
    public static final int sizeMinXZ = 1;
    public static final int sizeMaxXZ = 4;
    public static final int sizeMinY = 2;
    public static final int sizeMaxY = 6;
    public static final int maxItemBuffer = 300;
    private int sizeXZ;
    private int sizeY;
    private boolean validMultiblock;
    private boolean shouldUpdate = false;
    private boolean firsttick = true;
    private long tick;
    private boolean shouldUpdateEnch = false;
    private float progress;
    private MinerState currentState = MinerState.INVALID;
    private List<IMinerTile> tiles = new ArrayList<IMinerTile>();
    private Map<Integer, Integer> enchants = new HashMap<Integer, Integer>();
    private int whereami;
    private ChunkCoordinates target;
    private List<Integer> updateList = new ArrayList<Integer>();

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuelLevel = nbt.func_74762_e("fuelLevel");
        this.progress = nbt.func_74760_g("progress");
        this.whereami = nbt.func_74762_e("whereami");
        NBTTagList list = (NBTTagList)nbt.func_74781_a("items");
        this.itemList.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            this.itemList.add(item);
        }
    }

    public ArrayList<ItemStack> getItemList() {
        return this.itemList;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("fuelLevel", this.fuelLevel);
        nbt.func_74768_a("whereami", this.whereami);
        nbt.func_74776_a("progress", this.progress);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.itemList) {
            if (item == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            item.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int removeEnergy(int amount) {
        int enchant = this.getEnchantLevel(Enchantment.field_77347_r);
        if (enchant > 0) {
            float num = (float)amount * (1.0f - (float)this.field_145850_b.field_73012_v.nextInt(enchant) / 10.0f);
            return this.removeEnergyAbs((int)num);
        }
        return this.removeEnergyAbs(amount);
    }

    private int removeEnergyAbs(int amount) {
        this.markForUpdate(1);
        if (this.fuelLevel < amount) {
            int l = this.fuelLevel;
            this.fuelLevel = 0;
            return l;
        }
        this.fuelLevel -= amount;
        return amount;
    }

    public int getAmountFuel() {
        return this.fuelLevel;
    }

    public int getMaxEnergyBuffer() {
        return 50000;
    }

    private static boolean isAllowedTE(TileEntity te, boolean allowCore) {
        return te != null && (te instanceof IMinerTile || allowCore && te instanceof TileEntityMinerCore);
    }

    private void setInvalid() {
        this.validMultiblock = false;
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147458_c(this.field_145851_c - this.sizeXZ, this.field_145848_d, this.field_145849_e - this.sizeXZ, this.field_145851_c + this.sizeXZ, this.field_145848_d + this.sizeY, this.field_145849_e + this.sizeXZ);
        }
        this.setCurrentState(MinerState.INVALID);
        this.sizeXZ = 0;
        this.sizeY = 0;
        this.tiles.clear();
        this.enchants.clear();
        this.target = null;
        this.whereami = 0;
    }

    private void setIsValidMiner() {
        try {
            DimensionalWorld.instance.logger.log(Level.INFO, !this.field_145850_b.field_72995_K ? "Ping" : "Pong");
            this.shouldUpdate = false;
            int maxX = 0;
            int maxZ = 0;
            for (int xd = 1; xd <= 4; ++xd) {
                if (!TileEntityMinerCore.isAllowedTE(this.field_145850_b.func_147438_o(this.field_145851_c + xd, this.field_145848_d, this.field_145849_e), false)) continue;
                maxX = xd;
            }
            for (int zd = 1; zd <= 4; ++zd) {
                if (!TileEntityMinerCore.isAllowedTE(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + zd), false)) continue;
                maxZ = zd;
            }
            if (maxX != maxZ || maxX < 1) {
                this.setInvalid();
                return;
            }
            int validLayers = -1;
            int yd = 0;
            while (yd < 6 && this.isValidLayer(maxX, yd)) {
                validLayers = yd++;
            }
            if (validLayers < 1) {
                this.setInvalid();
                return;
            }
            for (int xd = -maxX; xd <= maxX; ++xd) {
                for (int zd = -maxX; zd <= maxX; ++zd) {
                    if (!TileEntityMinerCore.isAllowedTE(this.field_145850_b.func_147438_o(this.field_145851_c + xd, this.field_145848_d + validLayers + 1, this.field_145849_e + zd), true)) continue;
                    this.setInvalid();
                    return;
                }
            }
            if (!this.validMultiblock && this.target == null) {
                this.target = this.getNextTarget();
            }
            this.sizeXZ = maxX;
            this.sizeY = validLayers + 1;
            this.validMultiblock = true;
            this.tiles.clear();
            for (int x = -this.sizeXZ; x <= this.sizeXZ; ++x) {
                for (int z = -this.sizeXZ; z <= this.sizeXZ; ++z) {
                    for (int y = 0; y < this.sizeY; ++y) {
                        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                        if (te == this) continue;
                        this.tiles.add((IMinerTile)te);
                    }
                }
            }
            this.setCurrentState(MinerState.WORKING);
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147458_c(this.field_145851_c - this.sizeXZ, this.field_145848_d, this.field_145849_e - this.sizeXZ, this.field_145851_c + this.sizeXZ, this.field_145848_d + this.sizeY, this.field_145849_e + this.sizeXZ);
            }
            this.updateMinerEnchants();
            this.target = this.getNextTarget();
        }
        catch (Throwable t) {
            LogHelper.logException((String)"Failed to update Miner.", (Throwable)t);
            this.setInvalid();
        }
    }

    private void updateMinerEnchants() {
        DimensionalWorld.instance.logger.log(Level.INFO, !this.field_145850_b.field_72995_K ? "Ding" : "Dong");
        this.shouldUpdateEnch = false;
        this.enchants.clear();
        for (IMinerTile miner : this.tiles) {
            if (!(miner instanceof IMinerEnchantProvider)) continue;
            Map<Integer, Integer> map = ((IMinerEnchantProvider)miner).getProvidedEnchantment();
            for (Integer enchant : map.keySet()) {
                if (this.enchants.containsKey(enchant)) continue;
                this.enchants.put(enchant, map.get(enchant));
            }
        }
    }

    private boolean isValidLayer(int size, int layer) {
        for (int xd = -size - 1; xd <= size + 1; ++xd) {
            for (int zd = -size - 1; zd <= size + 1; ++zd) {
                if (!(Math.abs(xd) == size + 1 || Math.abs(zd) == size + 1 ? TileEntityMinerCore.isAllowedTE(this.field_145850_b.func_147438_o(this.field_145851_c + xd, this.field_145848_d + layer, this.field_145849_e + zd), true) : !TileEntityMinerCore.isAllowedTE(this.field_145850_b.func_147438_o(this.field_145851_c + xd, this.field_145848_d + layer, this.field_145849_e + zd), false) && (layer != 0 || this.field_145850_b.func_147438_o(this.field_145851_c + xd, this.field_145848_d, this.field_145849_e + zd) != this))) continue;
                return false;
            }
        }
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.shouldUpdate) {
                this.updateClient(0);
                this.setIsValidMiner();
            }
            if (this.shouldUpdateEnch) {
                this.updateMinerEnchants();
            }
        }
        if (this.firsttick) {
            this.target = this.getNextTarget();
            this.setIsValidMiner();
            this.firsttick = false;
        }
        ++this.tick;
        if (!(this.field_145850_b.field_72995_K || this.itemList.size() <= 0 && this.getCurrentState() == MinerState.FINISHED)) {
            for (IMinerTile miner : this.tiles) {
                miner.operate(this);
            }
            if (this.tick % 20L == 3L) {
                this.updatetypes();
            }
        }
    }

    public void markForUpdate() {
        this.shouldUpdate = true;
    }

    public void markForEnchUpdate() {
        this.shouldUpdateEnch = true;
    }

    public boolean isMinerDedicated(TileEntity miner) {
        if (miner == null || !(miner instanceof IMinerTile)) {
            throw new IllegalArgumentException("Miner has to be an instance of IMinerTile");
        }
        return this.tiles.contains(miner);
    }

    public boolean activate(World world, int x, int y, int z, EntityPlayer thePlayer, int s, float f1, float f2, float f3) {
        if (!this.validMultiblock) {
            return false;
        }
        Inventories.openContainerTileEntity((EntityPlayer)thePlayer, (TileEntity)this, (boolean)true);
        return true;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.markForUpdate();
    }

    public boolean onWrenchUsed(ItemStack wrench, EntityPlayer player, ForgeDirection side) {
        return false;
    }

    public boolean canPickup(ItemStack wrench, EntityPlayer player, ForgeDirection side) {
        return true;
    }

    public ItemStack shouldBeExact() {
        return Miners.CORE.getItem();
    }

    public void addToBuffer(int amount) {
        this.markForUpdate(1);
        this.fuelLevel = amount <= this.getMaxEnergyBuffer() - this.fuelLevel ? (this.fuelLevel += amount) : this.getMaxEnergyBuffer();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g, nbt);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.setIsValidMiner();
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean isValidMultiblock() {
        return this.validMultiblock;
    }

    private void decrProgress(float amount) {
        this.progress = this.progress - amount < 0.0f ? 0.0f : (this.progress -= amount);
    }

    public void addProgressToMining(float amount) {
        int efficiency = this.getEnchantLevel(Enchantment.field_77349_p);
        if (efficiency > 0) {
            this.addProgressToMiningAbs(amount * (1.0f + (float)efficiency * 0.2f));
        } else {
            this.addProgressToMiningAbs(amount);
        }
    }

    private void addProgressToMiningAbs(float amount) {
        this.progress = this.progress + amount > 100.0f ? 100.0f : (this.progress += amount);
    }

    public MinerState getCurrentState() {
        if (!this.isValidMultiblock()) {
            this.currentState = MinerState.INVALID;
        }
        return this.currentState;
    }

    private void setCurrentState(MinerState state) {
        if (this.currentState != state) {
            this.currentState = state;
            this.markForUpdate(3);
        }
    }

    public void mineNextBlockIfPossible() {
        if (this.target == null) {
            this.target = this.getNextTarget();
            if (this.target == null) {
                this.setCurrentState(MinerState.FINISHED);
            }
            this.decrProgress(0.5f);
            return;
        }
        if (this.itemList.size() > 300) {
            this.decrProgress(1.0f);
            this.setCurrentState(MinerState.FULL_BUFFER);
            return;
        }
        this.markForUpdate(2);
        Block block = this.field_145850_b.func_147439_a(this.target.field_71574_a, this.target.field_71572_b, this.target.field_71573_c);
        if (block == Blocks.field_150350_a || block == MinerConstants.filler || block == null) {
            ++this.whereami;
            this.target = this.getNextTarget();
            this.decrProgress(0.1f);
            this.setCurrentState(MinerState.WORKING);
            if (this.progress > 50.0f) {
                this.mineNextBlockIfPossible();
            }
            return;
        }
        if (block.func_149712_f(this.field_145850_b, this.target.field_71574_a, this.target.field_71572_b, this.target.field_71573_c) <= this.progress || this.progress >= 99.5f || block.func_149688_o().func_76224_d()) {
            this.setCurrentState(MinerState.WORKING);
            this.mineBlock(this.target.field_71574_a, this.target.field_71572_b, this.target.field_71573_c);
            this.target = this.getNextTarget();
        }
    }

    public void addStackToBuffer(ItemStack item) {
        if (Block.func_149634_a((Item)item.func_77973_b()) == MinerConstants.filler) {
            return;
        }
        this.itemList.add(item);
    }

    private void mineBlock(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        if (block != null && block != Blocks.field_150350_a && block.func_149712_f(this.field_145850_b, x, y, z) >= 0.0f && block != MinerConstants.filler) {
            int fort = this.getEnchantLevel(Enchantment.field_77346_s);
            int silk = this.getEnchantLevel(Enchantment.field_77348_q);
            if (silk > 0 && block.canSilkHarvest(this.field_145850_b, null, x, y, z, meta)) {
                this.addStackToBuffer(new ItemStack(block, 1, meta));
            } else {
                ArrayList items = block.getDrops(this.field_145850_b, x, y, z, meta, fort);
                for (ItemStack item : items) {
                    this.addStackToBuffer(item);
                }
            }
            this.decrProgress(block.func_149712_f(this.field_145850_b, x, y, z));
            this.field_145850_b.func_147465_d(x, y, z, MinerConstants.filler, 0, 2);
            return;
        }
        if (block == MinerConstants.filler) {
            this.decrProgress(0.2f);
        }
        this.decrProgress(0.2f);
        ++this.whereami;
    }

    public AromaContainer getContainer(EntityPlayer player, int i) {
        return new ContainerMiner(this);
    }

    @SideOnly(value=Side.CLIENT)
    public float getProgress(Object object) {
        if (object == null) {
            return this.getProgress();
        }
        if (object instanceof SpecialImagesBase.EnergyBar) {
            return (float)this.getAmountFuel() / (float)this.getMaxEnergyBuffer();
        }
        return this.getProgress();
    }

    public float getProgress() {
        return 0.0f;
    }

    public int getEnchantLevel(Enchantment e) {
        int n;
        if (this.enchants.containsKey(e.field_77352_x) && (n = this.enchants.get(e.field_77352_x).intValue()) > 0) {
            return n;
        }
        return 0;
    }

    private ChunkCoordinates getNextTarget() {
        int r = this.getRadius() * 2 + 1;
        int x = this.whereami / (r * this.getStartingHeight());
        if (x >= r) {
            return null;
        }
        int z = this.whereami % (r * this.getStartingHeight()) / this.getStartingHeight();
        int y = this.whereami % (r * this.getStartingHeight()) % this.getStartingHeight();
        int r1 = this.getRadius();
        return new ChunkCoordinates(this.field_145851_c + x - r1, y, this.field_145849_e + z - r1);
    }

    ChunkCoordinates getCurrentTarget() {
        return this.target;
    }

    private int getStartingHeight() {
        return this.field_145848_d;
    }

    public float getMiningProgress() {
        return this.progress;
    }

    int getRadius() {
        return this.sizeXZ * this.sizeXZ * 2 + this.sizeY * this.sizeXZ + 2;
    }

    int whereami() {
        return this.whereami;
    }

    int getAmountBlocks() {
        return (this.getRadius() * 2 + 1) * (this.getRadius() * 2 + 1) * this.getStartingHeight();
    }

    public List<IMinerTile> getMinerTiles() {
        return this.tiles;
    }

    public void markForUpdate(int type) {
        this.updateList.add(type);
    }

    private void updatetypes() {
        for (Integer type : this.updateList) {
            if (type == 1) {
                this.sendClientUpdate(1, this.fuelLevel);
                continue;
            }
            if (type == 2) {
                this.sendClientUpdate(2, this.whereami);
                continue;
            }
            if (type != 3) continue;
            this.sendClientUpdate(3, this.currentState.ordinal());
        }
    }

    private void sendClientUpdate(int type, int arg) {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), type, arg);
    }

    public boolean func_145842_c(int type, int num) {
        if (type == 0) {
            if (!this.field_145850_b.field_72995_K) {
                return true;
            }
            switch (num) {
                case 0: {
                    this.setIsValidMiner();
                }
            }
            return true;
        }
        if (this.field_145850_b.field_72995_K) {
            if (type == 1) {
                this.fuelLevel = num;
            } else if (type == 2) {
                this.whereami = num;
                this.target = this.getNextTarget();
            } else if (type == 3) {
                this.currentState = MinerState.values()[num];
            }
        }
        return true;
    }

    private void updateClient(int type) {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, type);
    }

    public long getTick() {
        return this.tick;
    }
}

