/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client;

import com.dynious.refinedrelocation.helper.LogHelper;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import paulscode.sound.SoundSystem;

public class KongaHandler {
    private static String kongaLoc = "konga" + File.separator + "konga.ogg";
    private static String kongaDl = "https://dl.dropbox.com/s/amdsf0512rda8t3/konga.ogg";
    private static String kongaIdentifier = "konga.ogg";
    private static SoundSystem soundSystem;
    private static ResourceLocation shader;
    private static Future<File> future;

    public static void toggleKonga() {
        if (future != null) {
            return;
        }
        File file = new File(kongaLoc);
        file.getParentFile().mkdirs();
        if (soundSystem == null) {
            KongaHandler.init();
        }
        if (soundSystem.playing(kongaIdentifier)) {
            KongaHandler.stopKonga();
            return;
        }
        if (!file.exists()) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            future = executorService.submit(new KongaDownloader());
        } else {
            KongaHandler.playKonga(file);
        }
    }

    public static void checkDownloadedAndPlay() {
        if (future != null && future.isDone()) {
            File file = null;
            try {
                file = future.get();
                future = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (file != null) {
                KongaHandler.playKonga(file);
            }
        }
    }

    private static void init() {
        SoundManager soundManager = (SoundManager)ObfuscationReflectionHelper.getPrivateValue(SoundHandler.class, (Object)Minecraft.func_71410_x().func_147118_V(), (String[])new String[]{"sndManager", "field_147694_f", "V"});
        soundSystem = (SoundSystem)ObfuscationReflectionHelper.getPrivateValue(SoundManager.class, (Object)soundManager, (String[])new String[]{"sndSystem", "field_148620_e", "e"});
    }

    private static void playKonga(File sound) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("-- ACTIVATING KONGA MODE --"));
        KongaHandler.activateKongaShader();
        try {
            soundSystem.newStreamingSource(false, kongaIdentifier, sound.toURI().toURL(), sound.getName(), true, 0.0f, 0.0f, 0.0f, 0, 16.0f);
            soundSystem.play(kongaIdentifier);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private static void stopKonga() {
        soundSystem.stop(kongaIdentifier);
        soundSystem.removeSource(kongaIdentifier);
        KongaHandler.deactivateKongaShader();
    }

    private static void activateKongaShader() {
        EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
        if (OpenGlHelper.field_148824_g) {
            if (renderer.field_147707_d != null) {
                renderer.field_147707_d.func_148021_a();
            }
            try {
                LogHelper.info("Selecting effect " + shader);
                renderer.field_147707_d = new ShaderGroup(Minecraft.func_71410_x().func_110434_K(), Minecraft.func_71410_x().func_110442_L(), Minecraft.func_71410_x().func_147110_a(), shader);
                renderer.field_147707_d.func_148026_a(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogHelper.warning("Failed to load shader: " + shader);
            }
        }
    }

    private static void deactivateKongaShader() {
        EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
        if (renderer.field_147707_d != null) {
            renderer.field_147707_d.func_148021_a();
            renderer.field_147707_d = null;
        }
    }

    static {
        shader = new ResourceLocation("shaders/post/wobble.json");
    }

    private static class KongaDownloader
    implements Callable<File> {
        private KongaDownloader() {
        }

        @Override
        public File call() {
            File file = new File(kongaLoc);
            try {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("-- DOWNLOADING KONGA --"));
                FileUtils.copyURLToFile((URL)new URL(kongaDl), (File)file);
                LogHelper.info("-- FINISHED DOWNLOADING KONGA --");
                return file;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

