/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.graphics;

import com.dynious.refinedrelocation.client.graphics.TextureAtlasPage;
import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class TextureAtlas {
    private final List<TextureAtlasPage> pages = Lists.newArrayList();

    public TextureAtlas(IResourceManager resourceManager, ResourceLocation resourceLocation) throws IOException {
        String line;
        String resourcePath = resourceLocation.func_110623_a();
        resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf(47) + 1);
        InputStream in = resourceManager.func_110536_a(resourceLocation).func_110527_b();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        TextureAtlasPage currentPage = null;
        TextureRegion currentRegion = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) {
                currentPage = null;
                continue;
            }
            if (currentPage == null) {
                currentPage = new TextureAtlasPage(line, new ResourceLocation(resourceLocation.func_110624_b(), resourcePath + line));
                this.pages.add(currentPage);
                continue;
            }
            int sepIdx = line.indexOf(58);
            if (sepIdx == -1) {
                currentRegion = new TextureRegion(currentPage.texture, line);
                currentPage.addRegion(currentRegion);
                continue;
            }
            String key = line.substring(0, sepIdx);
            String value = line.substring(sepIdx + 1);
            if (currentRegion == null) continue;
            if (key.equals("xy")) {
                String[] xy = value.split(",");
                currentRegion.setRegionX(Integer.parseInt(xy[0].trim()));
                currentRegion.setRegionY(Integer.parseInt(xy[1].trim()));
                continue;
            }
            if (!key.equals("size")) continue;
            String[] size = value.split(",");
            currentRegion.setRegionWidth(Integer.parseInt(size[0].trim()));
            currentRegion.setRegionHeight(Integer.parseInt(size[1].trim()));
        }
        reader.close();
        in.close();
    }

    public TextureRegion findRegion(String name) {
        for (TextureAtlasPage page : this.pages) {
            TextureRegion region = page.getRegion(name);
            if (region == null) continue;
            return region;
        }
        throw new RuntimeException("Could not find Refined Relocation atlas region '" + name + "'");
    }
}

