/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui;

import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.filter.IMultiFilterChild;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.GuiRefinedRelocationContainer;
import com.dynious.refinedrelocation.client.gui.GuiWidgetWrapper;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiFilterSettings;
import com.dynious.refinedrelocation.client.gui.widget.GuiFilterTypeList;
import com.dynious.refinedrelocation.client.gui.widget.GuiLabel;
import com.dynious.refinedrelocation.client.gui.widget.GuiTabButton;
import com.dynious.refinedrelocation.client.gui.widget.GuiTabPanel;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonBlacklist;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonDeleteFilter;
import com.dynious.refinedrelocation.container.ContainerRefinedRelocation;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileAdvancedFilteredBlockExtender;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiFiltered
extends GuiRefinedRelocationContainer {
    private IFilterTileGUI filterTile;
    private IFilterGUI filter;
    private GuiTabPanel panel;
    private GuiButtonBlacklist blacklistFilterButton;
    private GuiButtonDeleteFilter deleteFilterButton;
    private final List<GuiTabButton> tabButtons = new ArrayList<GuiTabButton>();
    private int lastFilterCount;

    public GuiFiltered(IFilterTileGUI filterTile, ContainerRefinedRelocation container) {
        super(container);
        this.filterTile = filterTile;
        this.filter = filterTile.getFilter();
        this.lastFilterCount = this.filter.getFilterCount();
        this.field_146999_f = 176;
        this.field_147000_g = 174;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        String title = BlockHelper.getTileEntityDisplayName(this.filterTile.getTileEntity());
        if (this.filterTile.getClass() == TileAdvancedFilteredBlockExtender.class) {
            title = StatCollector.func_74838_a((String)Strings.ADV_FILTERED_BLOCK_EXTENDER);
        }
        new GuiLabel(this, this.field_146294_l / 2, this.field_146295_m / 2 - 76, title);
        this.rebuildTabPanel(false);
    }

    public void rebuildTabPanel(boolean focusLast) {
        if (this.panel != null) {
            this.removeChild(this.panel);
        }
        if (this.deleteFilterButton != null) {
            this.removeChild(this.deleteFilterButton);
        }
        if (this.blacklistFilterButton != null) {
            this.removeChild(this.blacklistFilterButton);
        }
        for (GuiTabButton tabButton : this.tabButtons) {
            this.removeChild(tabButton);
        }
        this.tabButtons.clear();
        this.panel = new GuiTabPanel(this, this.field_146294_l / 2 - 80, this.field_146295_m / 2 - 60, 160, 140);
        int tabButtonX = this.field_146294_l / 2 - 118;
        int tabButtonY = this.field_146295_m / 2 - 60;
        GuiTabButton settingsTabButton = new GuiTabButton(this, this.panel, tabButtonX, tabButtonY, new GuiFilterSettings(this.panel.getX(), this.panel.getY(), this.panel.getWidth(), this.panel.getHeight(), this.filterTile), this.tabButtons.size(), SharedAtlas.findRegion("icon_settings"));
        settingsTabButton.setPlainTexture();
        if (!focusLast && this.filter.getFilterCount() == 0) {
            this.panel.setActiveTabButton(settingsTabButton);
        }
        this.tabButtons.add(settingsTabButton);
        tabButtonY = this.field_146295_m / 2 - 18;
        if (this.filter.getFilterCount() == 0) {
            GuiTabButton emptyTabButton = new GuiTabButton(this, this.panel, tabButtonX, tabButtonY, new GuiFilterTypeList(this, this.panel.getX(), this.panel.getY(), this.panel.getWidth(), this.panel.getHeight()), this.tabButtons.size(), SharedAtlas.findRegion("icon_add_filter"));
            if (focusLast) {
                this.panel.setActiveTabButton(emptyTabButton);
            }
            emptyTabButton.setPlainTexture();
            this.tabButtons.add(emptyTabButton);
        } else {
            for (int i = 0; i < this.filter.getFilterCount(); ++i) {
                IMultiFilterChild filterChild = this.filter.getFilterAtIndex(i);
                TextureRegion textureRegion = new TextureRegion(filterChild.getIconSheet(), filterChild.getTypeName(), filterChild.getIconX(), filterChild.getIconY(), filterChild.getIconWidth(), filterChild.getIconHeight());
                GuiWidgetWrapper page = new GuiWidgetWrapper(filterChild.getGuiWidget(this.panel.getX(), this.panel.getY(), this.panel.getWidth(), this.panel.getHeight()));
                GuiTabButton tabButton = new GuiTabButton(this, this.panel, tabButtonX, tabButtonY, page, this.tabButtons.size(), textureRegion);
                this.tabButtons.add(tabButton);
                tabButtonY += 25;
            }
            if (focusLast) {
                this.panel.setActiveTabButton(this.tabButtons.get(this.tabButtons.size() - 1));
            } else {
                this.panel.setActiveTabButton(this.tabButtons.get(1));
            }
            if (this.filter.getFilterCount() < 4) {
                GuiTabButton emptyTabButton = new GuiTabButton(this, this.panel, tabButtonX, tabButtonY, new GuiFilterTypeList(this, this.panel.getX(), this.panel.getY(), this.panel.getWidth(), this.panel.getHeight()), this.tabButtons.size(), SharedAtlas.findRegion("icon_add_filter"));
                emptyTabButton.setPlainTexture();
                this.tabButtons.add(emptyTabButton);
            }
        }
        this.blacklistFilterButton = new GuiButtonBlacklist(this, this.field_146294_l / 2 + 65 - 18, this.field_146295_m / 2 - 65);
        this.deleteFilterButton = new GuiButtonDeleteFilter(this, this.field_146294_l / 2 + 65, this.field_146295_m / 2 - 65);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.lastFilterCount != this.filter.getFilterCount()) {
            this.rebuildTabPanel(true);
            this.lastFilterCount = this.filter.getFilterCount();
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiFiltered.drawWindow(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(par1, par2, par3);
    }

    public boolean func_73868_f() {
        return false;
    }

    public boolean hasFilterSelected() {
        GuiTabButton activeTabButton = this.panel.getActiveTabButton();
        return activeTabButton != null && activeTabButton.getTabIndex() > 0 && !(activeTabButton.getTabPage() instanceof GuiFilterTypeList);
    }

    public int getSelectedFilterIndex() {
        return this.panel.getActiveTabButton().getTabIndex() - 1;
    }

    public IFilterGUI getFilter() {
        return this.filter;
    }
}

