/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.opengl.GL11;

public class GuiTextInputMultiline
extends GuiWidgetBase {
    private static final int MARGIN = 2;
    private final FontRenderer fontRenderer;
    protected boolean isMultiLine;
    private boolean enabled = true;
    private boolean hasFocus;
    private int cursorPosition;
    private int cursorCounter;
    private int maxLength;
    private int maxLengthPerLine;
    private String text;
    private String[] renderLines;
    private int scrollOffset;
    private int lineScrollOffset;

    public GuiTextInputMultiline(IGuiParent parent, int x, int y, int w, int h) {
        super(parent, x, y, w, h);
        this.fontRenderer = this.mc.field_71466_p;
    }

    @Override
    public void update() {
        super.update();
        ++this.cursorCounter;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        super.drawBackground(mouseX, mouseY);
        GuiTextInputMultiline.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.w + 1), (int)(this.y + this.h + 1), (int)-6250336);
        GuiTextInputMultiline.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + this.h), (int)-16777216);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        if (this.visible) {
            int offsetY;
            if (this.renderLines == null) {
                this.renderLines = this.text.split("\n");
            }
            for (int i = this.scrollOffset; i < this.renderLines.length && (offsetY = (i - this.scrollOffset) * this.fontRenderer.field_78288_b) + this.fontRenderer.field_78288_b < this.h; ++i) {
                if (this.lineScrollOffset >= this.renderLines[i].length()) continue;
                String lineText = this.fontRenderer.func_78269_a(this.renderLines[i].substring(this.lineScrollOffset), this.w - 2);
                this.fontRenderer.func_78276_b(lineText, this.x + 2, this.y + 2 + offsetY, Integer.MAX_VALUE);
            }
            int cursorLine = 0;
            int lastLineIdx = 0;
            for (int i = 0; i < this.cursorPosition; ++i) {
                if (this.text.charAt(i) != '\n') continue;
                ++cursorLine;
                lastLineIdx = i + 1;
            }
            if ((cursorLine - this.scrollOffset) * this.fontRenderer.field_78288_b >= 0 && (cursorLine - this.scrollOffset + 1) * this.fontRenderer.field_78288_b < this.h - 2) {
                this.drawCursorVertical(this.x + this.fontRenderer.func_78256_a(this.text.substring(lastLineIdx + this.lineScrollOffset, this.cursorPosition)) + 2, this.y + (cursorLine - this.scrollOffset) * this.fontRenderer.field_78288_b + 2);
            }
        }
    }

    private void drawCursorVertical(int x, int y) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x, (double)y + (double)this.fontRenderer.field_78288_b, 0.0);
        tessellator.func_78377_a((double)x + 1.0, (double)y + (double)this.fontRenderer.field_78288_b, 0.0);
        tessellator.func_78377_a((double)x + 1.0, (double)y, 0.0);
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    @Override
    public boolean keyTyped(char unicode, int keyCode) {
        if (!this.hasFocus) {
            return false;
        }
        switch (keyCode) {
            case 207: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.text.length());
                } else {
                    this.setCursorPosition(this.getEndOfLine(this.cursorPosition, 1));
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(0);
                } else {
                    this.setCursorPosition(this.getStartOfLine(this.cursorPosition, 1));
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getStartOfWord(this.cursorPosition - 1));
                } else {
                    this.setCursorPosition(this.cursorPosition - 1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getStartOfNextWord(this.cursorPosition + 1));
                } else {
                    this.setCursorPosition(this.cursorPosition + 1);
                }
                return true;
            }
            case 200: {
                if (GuiScreen.func_146271_m()) {
                    this.scroll(0, -1);
                } else {
                    int upLine = this.getStartOfLine(this.cursorPosition, 2);
                    this.setCursorPosition(upLine + Math.min(this.getLineLength(upLine), this.cursorPosition - this.getStartOfLine(this.cursorPosition, 1)));
                }
                return true;
            }
            case 208: {
                if (GuiScreen.func_146271_m()) {
                    this.scroll(0, 1);
                } else {
                    int downLine = this.getEndOfLine(this.cursorPosition, 2);
                    this.setCursorPosition(this.getStartOfLine(downLine, 1) + Math.min(this.getLineLength(downLine), this.cursorPosition - this.getStartOfLine(this.cursorPosition, 1)));
                }
                return true;
            }
            case 28: {
                if (this.enabled) {
                    this.insertText("\n");
                    this.markDirty();
                }
                return true;
            }
            case 211: {
                if (this.enabled) {
                    this.deleteFront(GuiScreen.func_146271_m());
                }
                return true;
            }
            case 14: {
                if (this.enabled) {
                    this.deleteBack(GuiScreen.func_146271_m());
                }
                return true;
            }
        }
        if (this.enabled && ChatAllowedCharacters.func_71566_a((char)unicode)) {
            this.insertText(Character.toString(unicode));
            return true;
        }
        return super.keyTyped(unicode, keyCode);
    }

    private int getLineLength(int position) {
        return this.getEndOfLine(position, 1) - this.getStartOfLine(position, 1);
    }

    private int getStartOfWord(int position) {
        if (this.text.charAt(position = Math.max(Math.min(position, this.text.length() - 1), 0)) == '\n') {
            return position;
        }
        boolean foundAlphabetic = false;
        for (int i = position; i >= 0; --i) {
            char c = this.text.charAt(i);
            if (c == '\n') {
                return i + 1;
            }
            if (Character.isAlphabetic(c)) {
                foundAlphabetic = true;
                continue;
            }
            if (!foundAlphabetic) continue;
            return i + 1;
        }
        return 0;
    }

    private int getStartOfNextWord(int position) {
        if (this.text.charAt(position = Math.max(Math.min(position, this.text.length() - 1), 0)) == '\n') {
            return position;
        }
        boolean foundNonAlphabetic = false;
        for (int i = position; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '\n') {
                return i;
            }
            if (!Character.isAlphabetic(c)) {
                foundNonAlphabetic = true;
                continue;
            }
            if (!foundNonAlphabetic) continue;
            return i;
        }
        return this.text.length();
    }

    private int getStartOfLine(int position, int iterations) {
        int startOfLine = position;
        for (int i = 0; i < iterations; ++i) {
            startOfLine = this.text.lastIndexOf(10, startOfLine - 1);
        }
        return startOfLine != -1 ? startOfLine + 1 : 0;
    }

    private int getEndOfLine(int position, int iteration) {
        int endOfLine = position - 1;
        for (int i = 0; i < iteration; ++i) {
            if ((endOfLine = this.text.indexOf(10, endOfLine + 1)) != -1) continue;
            return this.text.length();
        }
        return endOfLine != -1 ? endOfLine : this.text.length();
    }

    private void markDirty() {
        this.renderLines = null;
    }

    private void deleteBack(boolean wholeWord) {
        int deleteCount = 1;
        if (wholeWord) {
            deleteCount = this.cursorPosition - this.getStartOfWord(this.cursorPosition);
        }
        if (this.cursorPosition > 0) {
            this.text = this.text.substring(0, this.cursorPosition - deleteCount) + this.text.substring(this.cursorPosition);
            this.setCursorPosition(this.cursorPosition - deleteCount);
            this.markDirty();
            this.onTextChangedByUser(this.text);
        }
    }

    private void deleteFront(boolean wholeWord) {
        int deleteCount = 1;
        if (wholeWord) {
            deleteCount = this.getStartOfNextWord(this.cursorPosition) - this.cursorPosition;
        }
        if (this.cursorPosition < this.text.length()) {
            this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + deleteCount);
            this.markDirty();
            this.onTextChangedByUser(this.text);
        }
    }

    private void insertText(String s) {
        this.text = (this.cursorPosition > 0 ? this.text.substring(0, this.cursorPosition) : "") + s + (this.text.length() > this.cursorPosition ? this.text.substring(this.cursorPosition) : "");
        this.setCursorPosition(this.cursorPosition + s.length());
        this.markDirty();
        this.onTextChangedByUser(this.text);
    }

    public void setFocused(boolean hasFocus) {
        if (hasFocus && !this.hasFocus) {
            this.cursorCounter = 0;
        }
        this.hasFocus = hasFocus;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = Math.min(Math.max(cursorPosition, 0), this.text.length());
        int cursorLine = 0;
        for (int i = 0; i < this.cursorPosition; ++i) {
            if (this.text.charAt(i) != '\n') continue;
            ++cursorLine;
        }
        int visibleHeight = this.h - 2;
        int visibleCursorY = (cursorLine - this.scrollOffset) * this.fontRenderer.field_78288_b + 2;
        if (visibleCursorY < 0) {
            this.scroll(0, visibleCursorY / this.fontRenderer.field_78288_b - 1);
        } else if (visibleCursorY > visibleHeight - this.fontRenderer.field_78288_b) {
            this.scroll(0, (visibleCursorY - visibleHeight) / this.fontRenderer.field_78288_b + 1);
        }
        int visibleWidth = this.w - 2;
        int cursorLineStart = this.getStartOfLine(this.cursorPosition, 1);
        int cursorLineEnd = this.getEndOfLine(this.cursorPosition, 1);
        int cursorLineX = Math.min(this.getLineLength(this.cursorPosition), this.cursorPosition - cursorLineStart);
        String lineText = this.text.substring(cursorLineStart, cursorLineEnd);
        this.lineScrollOffset = Math.max(Math.min(this.lineScrollOffset, lineText.length()), 0);
        if (cursorLineX == this.lineScrollOffset) {
            this.lineScrollOffset -= this.fontRenderer.func_78262_a(lineText, visibleWidth, true).length();
        }
        this.lineScrollOffset = Math.max(Math.min(this.lineScrollOffset, lineText.length()), 0);
        String visibleLineText = this.fontRenderer.func_78269_a(lineText.substring(this.lineScrollOffset), visibleWidth);
        int l = visibleLineText.length() + this.lineScrollOffset;
        if (cursorLineX > l) {
            this.lineScrollOffset += cursorLineX - l;
        } else if (cursorLineX <= this.lineScrollOffset) {
            this.lineScrollOffset -= this.lineScrollOffset - cursorLineX;
        }
        this.lineScrollOffset = Math.max(Math.min(this.lineScrollOffset, lineText.length()), 0);
    }

    public void scroll(int x, int y) {
        this.lineScrollOffset = Math.max(this.lineScrollOffset + x, 0);
        this.scrollOffset = Math.max(this.scrollOffset + y, 0);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
        boolean isInside = this.isInsideBounds(mouseX, mouseY);
        this.setFocused(isInside);
        if (isInside && type == 0) {
            int relX = mouseX - this.x;
            int relY = mouseY - this.y - 2;
            int lineNumber = Math.round((float)relY / (float)this.fontRenderer.field_78288_b) + this.scrollOffset + 1;
            int startOfLine = this.getStartOfLine(this.getEndOfLine(0, lineNumber), 1);
            int endOfLine = this.getEndOfLine(startOfLine, 1);
            String visibleLine = this.fontRenderer.func_78269_a(this.text.substring(Math.max(startOfLine + this.lineScrollOffset, 0), endOfLine), this.w - 2);
            this.setCursorPosition(startOfLine + this.fontRenderer.func_78269_a(visibleLine, relX).length() + this.lineScrollOffset);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.markDirty();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void onTextChangedByUser(String newText) {
    }
}

