/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButton;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileWirelessBlockExtender;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.StatCollector;

public class GuiWirelessLinkStatus
extends GuiButton {
    private final TextureRegion[] activeTexture = new TextureRegion[2];
    private final TextureRegion[] inactiveTexture = new TextureRegion[2];
    protected TileWirelessBlockExtender tile;
    protected boolean linked;
    protected boolean lastLinked;

    public GuiWirelessLinkStatus(IGuiParent parent, int x, int y, TileWirelessBlockExtender tile) {
        super(parent, x, y, 16, 16, null, null);
        this.tile = tile;
        this.inactiveTexture[0] = SharedAtlas.findRegion("icon_link_inactive");
        this.inactiveTexture[1] = SharedAtlas.findRegion("icon_link_inactive_hover");
        this.activeTexture[0] = SharedAtlas.findRegion("icon_link_active");
        this.activeTexture[1] = SharedAtlas.findRegion("icon_link_active_hover");
        this.setButtonTextures(this.inactiveTexture);
        this.update();
    }

    public void setLinked(boolean state) {
        this.linked = state;
        if (state) {
            this.setButtonTextures(this.activeTexture);
        } else {
            this.setButtonTextures(this.inactiveTexture);
        }
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            String colorCode = "\u00a7";
            String grayColor = colorCode + "7";
            String yellowColor = colorCode + "e";
            tooltip.add(StatCollector.func_74838_a((String)Strings.WIRELESS_LINK));
            if (this.linked) {
                Block linkedBlock = this.tile.func_145831_w().func_147439_a(this.tile.xConnected, this.tile.yConnected, this.tile.zConnected);
                int linkedMetadata = this.tile.func_145831_w().func_72805_g(this.tile.xConnected, this.tile.yConnected, this.tile.zConnected);
                tooltip.add(grayColor + StatCollector.func_74837_a((String)Strings.LINKED_TO_AT, (Object[])new Object[]{BlockHelper.getBlockDisplayName(linkedBlock, linkedMetadata), this.tile.xConnected, this.tile.yConnected, this.tile.zConnected}));
                if (this.tile.hasConnection()) {
                    tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.CONNECTIONS) + ":");
                    List<String> connections = this.tile.getConnectionTypes();
                    for (int i = 0; i < connections.size(); ++i) {
                        connections.set(i, yellowColor + connections.get(i));
                    }
                    tooltip.addAll(connections);
                }
            } else {
                tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.UNLINKED));
                tooltip.add(yellowColor + StatCollector.func_74838_a((String)Strings.USE_LINKER_TO_LINK));
            }
        }
    }

    @Override
    public void update() {
        boolean isLinked;
        super.update();
        boolean bl = isLinked = this.tile.xConnected != Integer.MAX_VALUE;
        if (this.lastLinked != isLinked) {
            this.setLinked(isLinked);
        }
    }
}

