/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.IGuiWidgetBase;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiLabel;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiButton
extends GuiWidgetBase {
    private TextureRegion[] texture = new TextureRegion[2];
    protected GuiLabel label;
    private boolean adventureModeRestriction;

    public GuiButton(IGuiParent parent, int x, int y, String labelText) {
        super(parent);
        this.x = x;
        this.y = y;
        this.w = 24;
        this.h = 20;
        this.texture[0] = SharedAtlas.findRegion("button");
        this.texture[1] = SharedAtlas.findRegion("button_hover");
        this.label = new GuiLabel(this, x + this.w / 2, y + this.h / 2, labelText, 0xFFFFFF, true);
    }

    public GuiButton(IGuiParent parent, int x, int y, int w, int h, String textureName, String labelText) {
        super(parent, x, y, w, h);
        if (textureName != null) {
            this.texture[0] = SharedAtlas.findRegion(textureName);
            this.texture[1] = SharedAtlas.findRegion(textureName + "_hover");
        }
        this.label = new GuiLabel(this, this.x + this.w / 2, this.y + this.h / 2, labelText, 0xFFFFFF, true);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        boolean isHovering = this.isInsideBounds(mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.texture[isHovering ? 1 : 0].draw(this.x, this.y);
        for (IGuiWidgetBase child : this.children) {
            if (!(child instanceof GuiLabel)) continue;
            GuiLabel childLabel = (GuiLabel)child;
            childLabel.setColor(this.isInsideBounds(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF);
        }
        super.drawBackground(mouseX, mouseY);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
        if (this.isInsideBounds(mouseX, mouseY)) {
            this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
    }

    public final boolean isAdventureModeRestriction() {
        return this.adventureModeRestriction;
    }

    public final void setAdventureModeRestriction(boolean adventureModeRestriction) {
        this.adventureModeRestriction = adventureModeRestriction;
    }

    public void setButtonTextures(TextureRegion[] textures) {
        if (textures.length != 2) {
            throw new RuntimeException("Expected an array of size two for the button textures.");
        }
        this.texture = textures;
    }
}

