/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButton;
import com.dynious.refinedrelocation.container.ContainerPowerLimiter;
import com.dynious.refinedrelocation.helper.EnergyType;
import com.dynious.refinedrelocation.lib.Strings;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonEnergyTypes
extends GuiButton {
    private ContainerPowerLimiter container;
    private EnergyType currentEnergyType;

    public GuiButtonEnergyTypes(IGuiParent parent, int x, int y, ContainerPowerLimiter container) {
        super(parent, x, y, "");
        this.container = container;
        if (container != null) {
            this.setNextType();
        }
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            if (this.currentEnergyType == null) {
                tooltip.add("\u00a7a" + StatCollector.func_74838_a((String)Strings.ENERGY_TYPE) + "\u00a7f " + StatCollector.func_74838_a((String)Strings.NONE));
                tooltip.add("\u00a7c" + StatCollector.func_74838_a((String)Strings.NO_SUITABLE_ENERGY_CONNECTION));
            } else {
                tooltip.add("\u00a7a" + StatCollector.func_74838_a((String)Strings.ENERGY_TYPE) + "\u00a7f " + this.currentEnergyType.name());
                boolean foundOne = false;
                for (int i = 0; i < this.container.getEnergyTypes().length; ++i) {
                    if (!this.container.getEnergyTypes()[i]) continue;
                    if (foundOne) {
                        tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_TO_TOGGLE));
                        break;
                    }
                    foundOne = true;
                }
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.currentEnergyType == null) {
            this.setNextType();
        }
    }

    public void setValue(EnergyType energyType) {
        this.label.setText(energyType.name());
    }

    public EnergyType getCurrentEnergyType() {
        return this.currentEnergyType;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isInsideBounds(mouseX, mouseY) && (type == 0 || type == 1)) {
            if (this.container != null) {
                this.setNextType();
            } else {
                this.label.setText("--");
            }
        }
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
    }

    public void setNextType() {
        EnergyType t;
        int i;
        boolean[] energyTypes = this.container.getEnergyTypes();
        int ordinal = this.currentEnergyType != null ? this.currentEnergyType.ordinal() : -1;
        for (i = ordinal + 1; i < EnergyType.values().length; ++i) {
            t = EnergyType.values()[i];
            if (t == EnergyType.MJ || !energyTypes[i]) continue;
            this.currentEnergyType = t;
            this.setValue(t);
            return;
        }
        for (i = 0; i < ordinal + 1; ++i) {
            t = EnergyType.values()[i];
            if (t == EnergyType.MJ || !energyTypes[i]) continue;
            this.currentEnergyType = t;
            this.setValue(t);
            return;
        }
        this.label.setText("--");
    }
}

