/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonToggle;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.IAdvancedFilteredTile;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonFilterExtraction
extends GuiButtonToggle {
    protected IAdvancedFilteredTile tile;

    public GuiButtonFilterExtraction(IGuiParent parent, int x, int y, IAdvancedFilteredTile tile) {
        super(parent, x, y, 24, 20, "button_unfiltered_extraction", "button_filtered_extraction", null, null);
        this.tile = tile;
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        if (this.tile == null) {
            return;
        }
        this.tile.setRestrictionExtraction(newState);
        GuiHelper.sendBooleanMessage(3, newState);
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            String[] tooltipLines;
            tooltip.add(StatCollector.func_74838_a((String)(this.getState() ? Strings.FILTERED_EXTRACT : Strings.UNFILTERED_EXTRACT)));
            for (String tooltipLine : tooltipLines = StatCollector.func_74838_a((String)(this.getState() ? Strings.FILTERED_EXTRACT_DESC : Strings.UNFILTERED_EXTRACT_DESC)).split("\\\\n")) {
                tooltip.add("\u00a77" + tooltipLine);
            }
            tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_TO_TOGGLE));
        }
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setState(this.tile.getRestrictExtraction());
        }
        super.update();
    }
}

